/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.test.est.examples;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.security.cert.TrustAnchor;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.est.CSRRequestResponse;
import org.bouncycastle.est.ESTService;
import org.bouncycastle.est.jcajce.JcaJceUtils;
import org.bouncycastle.est.jcajce.JsseDefaultHostnameAuthorizer;
import org.bouncycastle.est.jcajce.JsseESTServiceBuilder;
import org.bouncycastle.est.jcajce.JsseHostnameAuthorizer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.test.est.examples.ExampleUtils;
import org.bouncycastle.test.est.examples.SuffixList;

public class CSRAttributesExample {
    public CSRAttributesExample(String[] args) throws Exception {
        if (args.length == 0) {
            this.printArguments();
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        File trustAnchorFile = null;
        String serverRootUrl = null;
        String tlsVersion = "TLS";
        String tlsProvider = "SunJSSE";
        String tlsProviderClass = null;
        boolean noNameVerifier = false;
        int timeout = 0;
        String label = null;
        String suffixList = null;
        try {
            for (int t = 0; t < args.length; ++t) {
                String arg = args[t];
                if (arg.equals("-t")) {
                    trustAnchorFile = ExampleUtils.nextArgAsFile("Trust Anchor File", args, t);
                    ++t;
                    continue;
                }
                if (arg.equals("-u")) {
                    serverRootUrl = ExampleUtils.nextArgAsString("Server Hostname", args, t);
                    ++t;
                    continue;
                }
                if (arg.equals("--tls")) {
                    tlsVersion = ExampleUtils.nextArgAsString("TLS version", args, t);
                    ++t;
                    continue;
                }
                if (arg.equals("--tlsProvider")) {
                    tlsProvider = ExampleUtils.nextArgAsString("TLS Provider", args, t);
                    tlsProviderClass = ExampleUtils.nextArgAsString("TLS Provider Class", args, ++t);
                    ++t;
                    continue;
                }
                if (arg.equals("--to")) {
                    timeout = ExampleUtils.nextArgAsInteger("Timeout", args, t);
                    ++t;
                    continue;
                }
                if (arg.equals("--no-name-verifier")) {
                    noNameVerifier = true;
                    continue;
                }
                if (arg.equals("--label")) {
                    label = ExampleUtils.nextArgAsString("CA Label", args, t);
                    ++t;
                    continue;
                }
                if (arg.equals("--sl")) {
                    suffixList = ExampleUtils.nextArgAsString("Suffix List", args, t);
                    ++t;
                    continue;
                }
                throw new IllegalArgumentException("Unknown argument " + arg);
            }
        }
        catch (IllegalArgumentException ilex) {
            System.err.println(ilex.getMessage());
            this.printArguments();
            System.exit(1);
        }
        if (serverRootUrl == null) {
            System.err.println("Server url (-u) must be defined.");
            System.exit(-1);
        }
        if (suffixList == null) {
            System.err.println("Known Suffix List (--sl)  must be defined.");
            System.exit(-1);
        }
        Set<TrustAnchor> trustAnchors = null;
        if (trustAnchorFile != null) {
            trustAnchors = ExampleUtils.toTrustAnchor(ExampleUtils.readPemCertificates(trustAnchorFile));
        }
        if (tlsProviderClass != null) {
            Security.addProvider((Provider)Class.forName(tlsProviderClass).newInstance());
        }
        JsseESTServiceBuilder builder = null;
        X509TrustManager[] trustManagers = null;
        trustManagers = trustAnchors != null && !trustAnchors.isEmpty() ? JcaJceUtils.getCertPathTrustManager(trustAnchors, null) : new X509TrustManager[]{JcaJceUtils.getTrustAllTrustManager()};
        builder = new JsseESTServiceBuilder(serverRootUrl, trustManagers);
        builder.withTimeout(timeout);
        builder.withLabel(label);
        builder.withTLSVersion(tlsVersion);
        builder.withProvider(tlsProvider);
        if (noNameVerifier) {
            builder.withHostNameAuthorizer(null);
        } else {
            builder.withHostNameAuthorizer((JsseHostnameAuthorizer)new JsseDefaultHostnameAuthorizer(SuffixList.loadSuffixes(suffixList)));
        }
        ESTService estService = builder.build();
        CSRRequestResponse csrAttributes = estService.getCSRAttributes();
        for (ASN1ObjectIdentifier id : csrAttributes.getAttributesResponse().getRequirements()) {
            System.out.println(id.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            new CSRAttributesExample(args);
        }
        catch (Exception ex) {
            System.out.println("\n\n-----------------");
            System.out.println(ex.getMessage());
            System.out.println("-----------------\n\n");
            throw ex;
        }
    }

    public void printArguments() {
        System.out.println("-t <file>                         Trust anchor file. (PEM)");
        System.out.println("-u <url>                          Server Hostname");
        System.out.println("--tls <version>                   Use this TLS version when creating socket factory, Eg TLSv1.2");
        System.out.println("--tlsProvider <provider> <class>  The JSSE Provider.");
        System.out.println("--to <milliseconds>               Timeout in milliseconds.");
        System.out.println("--no-name-verifier                No hostname verifier.");
        System.out.println("--label <ca label>                CA Label.");
        System.out.println("--sl <file>                       List of known suffixes.");
    }
}

