/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.test.est.examples;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.est.CACertsResponse;
import org.bouncycastle.est.ESTService;
import org.bouncycastle.est.jcajce.JcaJceUtils;
import org.bouncycastle.est.jcajce.JsseDefaultHostnameAuthorizer;
import org.bouncycastle.est.jcajce.JsseESTServiceBuilder;
import org.bouncycastle.est.jcajce.JsseHostnameAuthorizer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.test.est.examples.ExampleUtils;
import org.bouncycastle.test.est.examples.SuffixList;
import org.bouncycastle.util.Store;

public class CaCertsExample {
    public CaCertsExample(String[] args) throws Exception {
        if (args.length == 0) {
            this.printArguments();
            System.exit(1);
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        File trustAnchorFile = null;
        String serverRootUrl = null;
        boolean printTLSCerts = false;
        String tlsVersion = "TLS";
        String tlsProvider = "SunJSSE";
        String tlsProviderClass = null;
        boolean noNameVerifier = false;
        String label = null;
        int timeout = 0;
        String suffixList = null;
        try {
            for (int t = 0; t < args.length; ++t) {
                String arg = args[t];
                if (arg.equals("-t")) {
                    trustAnchorFile = ExampleUtils.nextArgAsFile("Trust Anchor File", args, t);
                    ++t;
                    continue;
                }
                if (arg.equals("-u")) {
                    serverRootUrl = ExampleUtils.nextArgAsString("Server Hostname", args, t);
                    ++t;
                    continue;
                }
                if (arg.equals("--printTLS")) {
                    printTLSCerts = true;
                    continue;
                }
                if (arg.equals("--tls")) {
                    tlsVersion = ExampleUtils.nextArgAsString("TLS version", args, t);
                    ++t;
                    continue;
                }
                if (arg.equals("--tlsProvider")) {
                    tlsProvider = ExampleUtils.nextArgAsString("TLS Provider", args, t);
                    tlsProviderClass = ExampleUtils.nextArgAsString("TLS Provider Class", args, ++t);
                    ++t;
                    continue;
                }
                if (arg.equals("--to")) {
                    timeout = ExampleUtils.nextArgAsInteger("Timeout", args, t);
                    ++t;
                    continue;
                }
                if (arg.equals("--no-name-verifier")) {
                    noNameVerifier = true;
                    continue;
                }
                if (arg.equals("--label")) {
                    label = ExampleUtils.nextArgAsString("CA Label", args, t);
                    ++t;
                    continue;
                }
                if (arg.equals("--sl")) {
                    suffixList = ExampleUtils.nextArgAsString("Suffix List", args, t);
                    ++t;
                    continue;
                }
                throw new IllegalArgumentException("Unknown argument " + arg);
            }
        }
        catch (IllegalArgumentException ilex) {
            System.err.println(ilex.getMessage());
            this.printArguments();
            System.exit(1);
        }
        if (serverRootUrl == null) {
            System.err.println("Server url (-u) must be defined.");
            System.exit(-1);
        }
        if (suffixList == null) {
            System.err.println("Known Suffix List (--sl)  must be defined.");
            System.exit(-1);
        }
        Set<TrustAnchor> trustAnchors = null;
        if (trustAnchorFile != null) {
            trustAnchors = ExampleUtils.toTrustAnchor(ExampleUtils.readPemCertificates(trustAnchorFile));
        }
        if (tlsProviderClass != null) {
            Security.addProvider((Provider)Class.forName(tlsProviderClass).newInstance());
        }
        X509TrustManager[] trustManagers = null;
        JsseESTServiceBuilder builder = null;
        trustManagers = trustAnchors != null && !trustAnchors.isEmpty() ? JcaJceUtils.getCertPathTrustManager(trustAnchors, null) : new X509TrustManager[]{JcaJceUtils.getTrustAllTrustManager()};
        builder = new JsseESTServiceBuilder(serverRootUrl, trustManagers);
        if (noNameVerifier) {
            builder.withHostNameAuthorizer(null);
        } else {
            builder.withHostNameAuthorizer((JsseHostnameAuthorizer)new JsseDefaultHostnameAuthorizer(SuffixList.loadSuffixes(suffixList)));
        }
        builder.withTimeout(timeout);
        builder.withLabel(label);
        builder.withTLSVersion(tlsVersion);
        builder.withProvider(tlsProvider);
        ESTService estService = builder.build();
        CACertsResponse caCertsResponse = estService.getCACerts();
        Certificate[] certs = ((SSLSession)caCertsResponse.getSession()).getPeerCertificates();
        if (!caCertsResponse.isTrusted()) {
            System.out.println();
            for (Certificate certificate : certs) {
                X509Certificate x509 = (X509Certificate)certificate;
                System.out.println("Subject: " + x509.getSubjectDN());
                System.out.println("Issuer: " + x509.getIssuerDN());
                System.out.println("Serial Number: " + x509.getSerialNumber());
                System.out.println("Not Before: " + x509.getNotBefore());
                System.out.println("Not After: " + x509.getNotAfter());
                System.out.println("Signature Algorithm: " + x509.getSigAlgName());
                System.out.println();
                System.out.println(certificate.toString());
            }
            System.out.println("As part of the TLS handshake, the server tendered to us these certificates.");
            if (!ExampleUtils.userSaysYes("Do you accept these certificates (y,n) ?")) {
                System.exit(0);
            }
            System.out.println();
            System.out.println("The untrusted server tendered to us these certificates as CA certs");
            for (Certificate certificate : ESTService.storeToArray((Store)caCertsResponse.getCertificateStore())) {
                System.out.println("Subject: " + certificate.getSubject());
                System.out.println("Issuer: " + certificate.getIssuer());
                System.out.println("Serial Number: " + certificate.getSerialNumber());
                System.out.println("Not Before: " + certificate.getNotBefore());
                System.out.println("Not After: " + certificate.getNotAfter());
                System.out.println("Signature Algorithm: " + certificate.getSignatureAlgorithm());
                System.out.println();
                System.out.println(ExampleUtils.toJavaX509Certificate(certificate));
            }
            if (!ExampleUtils.userSaysYes("Do you accept these certificates (y,n) ?")) {
                System.exit(0);
            }
        }
        System.out.println("Fetched CA Certs:\n\n");
        for (Certificate certificate : ESTService.storeToArray((Store)caCertsResponse.getCertificateStore())) {
            System.out.println(ExampleUtils.toPem((X509CertificateHolder)certificate));
        }
        if (printTLSCerts) {
            System.out.println("\n TLS Certificates");
            System.out.println();
            for (Certificate certificate : certs) {
                System.out.println(ExampleUtils.toPem(new X509CertificateHolder(certificate.getEncoded())));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            new CaCertsExample(args);
        }
        catch (Exception ex) {
            System.out.println("\n\n-----------------");
            System.out.println(ex.getMessage());
            System.out.println("-----------------\n\n");
            throw ex;
        }
    }

    public void printArguments() {
        System.out.println("-t <file>                         Trust anchor file. (PEM)");
        System.out.println("-u <url>                          Server Hostname.");
        System.out.println("--printTLS <url>                  Print TLS certificates as PEM format");
        System.out.println("--tls <version>                   Use this TLS version when creating socket factory, Eg TLSv1.2");
        System.out.println("--tlsProvider <provider> <class>  The JSSE Provider.");
        System.out.println("--to <milliseconds>               Timeout in milliseconds.");
        System.out.println("--no-name-verifier                No hostname verifier.");
        System.out.println("--label <ca label>                CA Label.");
        System.out.println("--sl <file>                       List of known suffixes.");
    }
}

