/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V1TBSCertificateGenerator;
import org.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class GenerationTest
extends SimpleTest {
    private byte[] v1Cert = Base64.decode("MIGtAgEBMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMMAkFVMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAxMlowNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMTAaMA0GCSqGSIb3DQEBAQUAAwkAMAYCAQECAQI=");
    private byte[] v3Cert = Base64.decode("MIIBSKADAgECAgECMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMMAkFVMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAwMlowNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMjAYMBAGBisOBwIBATAGAgEBAgECAwQAAgEDo4GVMIGSMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAyggECMCAGA1UdDgEB/wQWBBQ2T3aRz8you6PBCaJJEFNrqgh0UTALBgNVHQ8EBAMCBBA=");
    private byte[] v3CertNullSubject = Base64.decode("MIHGoAMCAQICAQIwDQYJKoZIhvcNAQEEBQAwJTELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUwHhcNNzAwMTAxMDAwMDAxWhcNNzAwMTAxMDAwMDAyWjAAMBgwEAYGKw4HAgEBMAYCAQECAQIDBAACAQOjSjBIMEYGA1UdEQEB/wQ8MDqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAy");
    private byte[] v2CertList = Base64.decode("MIIBQwIBATANBgkqhkiG9w0BAQUFADAlMQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZRcNNzAwMTAxMDAwMDAwWhcNNzAwMTAxMDAwMDAyWjAiMCACAQEXDTcwMDEwMTAwMDAwMVowDDAKBgNVHRUEAwoBCqCBxTCBwjBhBgNVHSMBAf8EVzBVgBQ2T3aRz8you6PBCaJJEFNrqgh0UaE6pDgwNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMoIBAjBDBgNVHRIEPDA6pDgwNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMzAKBgNVHRQEAwIBATAMBgNVHRwBAf8EAjAA");

    private AuthorityKeyIdentifier createAuthorityKeyId(SubjectPublicKeyInfo subjectPublicKeyInfo, X500Name x500Name, int n) {
        GeneralName generalName = new GeneralName(x500Name);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(generalName);
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo, GeneralNames.getInstance(new DERSequence(aSN1EncodableVector)), BigInteger.valueOf(n));
    }

    private static byte[] getDigest(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        return byArray;
    }

    public String getName() {
        return "Generation";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new GenerationTest());
    }

    public void performTest() throws Exception {
        this.testAllowedDuplicateExtensions();
        this.testDuplicateExtensions();
        this.tbsV1CertGen();
        this.tbsV3CertGen();
        this.tbsV3CertGenWithNullSubject();
        this.tbsV2CertListGen();
    }

    private void tbsV1CertGen() throws IOException {
        ASN1Primitive aSN1Primitive;
        V1TBSCertificateGenerator v1TBSCertificateGenerator = new V1TBSCertificateGenerator();
        Date date = new Date(1000L);
        Date date2 = new Date(12000L);
        v1TBSCertificateGenerator.setSerialNumber(new ASN1Integer(1L));
        v1TBSCertificateGenerator.setStartDate(new Time(date));
        v1TBSCertificateGenerator.setEndDate(new Time(date2));
        v1TBSCertificateGenerator.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
        v1TBSCertificateGenerator.setSubject(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 1"));
        v1TBSCertificateGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, DERNull.INSTANCE));
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPublicKey(BigInteger.valueOf(1L), BigInteger.valueOf(2L)));
        v1TBSCertificateGenerator.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        TBSCertificate tBSCertificate = v1TBSCertificateGenerator.generateTBSCertificate();
        byte[] byArray = tBSCertificate.getEncoded();
        if (!Arrays.areEqual(byArray, this.v1Cert)) {
            this.fail("failed v1 cert generation");
        }
        if (!Arrays.areEqual(byArray = (aSN1Primitive = ASN1Primitive.fromByteArray(this.v1Cert)).getEncoded(), this.v1Cert)) {
            this.fail("failed v1 cert read back test");
        }
    }

    private void tbsV2CertListGen() throws IOException {
        V2TBSCertListGenerator v2TBSCertListGenerator = new V2TBSCertListGenerator();
        v2TBSCertListGenerator.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
        v2TBSCertListGenerator.addCRLEntry(new ASN1Integer(1L), new Time(new Date(1000L)), 10);
        v2TBSCertListGenerator.setNextUpdate(new Time(new Date(2000L)));
        v2TBSCertListGenerator.setThisUpdate(new Time(new Date(500L)));
        v2TBSCertListGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, DERNull.INSTANCE));
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new ASN1Integer(3L));
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        extensionsGenerator.addExtension(Extension.authorityKeyIdentifier, true, this.createAuthorityKeyId(subjectPublicKeyInfo, new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2));
        extensionsGenerator.addExtension(Extension.issuerAlternativeName, false, new GeneralNames(new GeneralName(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 3"))));
        extensionsGenerator.addExtension(Extension.cRLNumber, false, new ASN1Integer(1L));
        extensionsGenerator.addExtension(Extension.issuingDistributionPoint, true, IssuingDistributionPoint.getInstance(new DERSequence()));
        this.isTrue(extensionsGenerator.hasExtension(Extension.cRLNumber));
        this.isTrue(extensionsGenerator.hasExtension(Extension.freshestCRL) ^ true);
        this.isEquals(new Extension(Extension.cRLNumber, false, new ASN1Integer(1L).getEncoded()), extensionsGenerator.getExtension(Extension.cRLNumber));
        Extensions extensions = extensionsGenerator.generate();
        v2TBSCertListGenerator.setExtensions(extensions);
        TBSCertList tBSCertList = v2TBSCertListGenerator.generateTBSCertList();
        byte[] byArray = tBSCertList.getEncoded();
        if (!Arrays.areEqual(byArray, this.v2CertList)) {
            System.out.println(new String(Base64.encode(byArray)));
            this.fail("failed v2 cert list generation");
        }
        extensionsGenerator.replaceExtension(Extension.cRLNumber, false, new ASN1Integer(2L));
        this.isEquals(new Extension(Extension.cRLNumber, false, new ASN1Integer(2L).getEncoded()), extensionsGenerator.getExtension(Extension.cRLNumber));
        extensionsGenerator.removeExtension(Extension.cRLNumber);
        this.isTrue(extensionsGenerator.hasExtension(Extension.cRLNumber) ^ true);
        extensions = extensionsGenerator.generate();
        ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(this.v2CertList);
        byArray = aSN1Primitive.getEncoded();
        if (!Arrays.areEqual(byArray, this.v2CertList)) {
            this.fail("failed v2 cert list read back test");
        }
        v2TBSCertListGenerator.addCRLEntry(new ASN1Integer(1L), new Time(new Date(1000L)), 10);
        v2TBSCertListGenerator.addCRLEntry(new ASN1Integer(2L), new Time(new Date(1000L)), 3, new ASN1GeneralizedTime(new Date(2000L)));
        TBSCertList tBSCertList2 = v2TBSCertListGenerator.generateTBSCertList();
        TBSCertList.CRLEntry[] cRLEntryArray = tBSCertList2.getRevokedCertificates();
        int n = 0;
        while (n != cRLEntryArray.length) {
            CRLReason cRLReason;
            Extension extension;
            Extensions extensions2;
            TBSCertList.CRLEntry cRLEntry = cRLEntryArray[n];
            if (cRLEntry.getUserCertificate().equals(new ASN1Integer(1L))) {
                extensions2 = cRLEntry.getExtensions();
                extension = extensions2.getExtension(Extension.reasonCode);
                cRLReason = CRLReason.getInstance(extension.getParsedValue());
                if (cRLReason.getValue().intValue() != 10) {
                    this.fail("reason code mismatch");
                }
            } else if (cRLEntry.getUserCertificate().equals(new ASN1Integer(2L))) {
                extensions2 = cRLEntry.getExtensions();
                extension = extensions2.getExtension(Extension.reasonCode);
                cRLReason = CRLReason.getInstance(extension.getParsedValue());
                if (cRLReason.getValue().intValue() != 3) {
                    this.fail("reason code mismatch");
                }
                extension = extensions2.getExtension(Extension.invalidityDate);
                ASN1GeneralizedTime aSN1GeneralizedTime = ASN1GeneralizedTime.getInstance(extension.getParsedValue());
                try {
                    if (!aSN1GeneralizedTime.getDate().equals(new Date(2000L))) {
                        this.fail("invalidity date mismatch");
                    }
                }
                catch (ParseException parseException) {
                    this.fail("can't parse date", parseException);
                }
            }
            ++n;
        }
    }

    private void tbsV3CertGen() throws IOException {
        ASN1Primitive aSN1Primitive;
        V3TBSCertificateGenerator v3TBSCertificateGenerator = new V3TBSCertificateGenerator();
        Date date = new Date(1000L);
        Date date2 = new Date(2000L);
        v3TBSCertificateGenerator.setSerialNumber(new ASN1Integer(2L));
        v3TBSCertificateGenerator.setStartDate(new Time(date));
        v3TBSCertificateGenerator.setEndDate(new Time(date2));
        v3TBSCertificateGenerator.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
        v3TBSCertificateGenerator.setSubject(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"));
        v3TBSCertificateGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, DERNull.INSTANCE));
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new ASN1Integer(3L));
        v3TBSCertificateGenerator.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        Extensions extensions = new Extensions(new Extension[]{new Extension(Extension.authorityKeyIdentifier, true, (ASN1OctetString)new DEROctetString(this.createAuthorityKeyId(subjectPublicKeyInfo, new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))), new Extension(Extension.subjectKeyIdentifier, true, (ASN1OctetString)new DEROctetString(new SubjectKeyIdentifier(GenerationTest.getDigest(subjectPublicKeyInfo)))), new Extension(Extension.keyUsage, false, (ASN1OctetString)new DEROctetString(new KeyUsage(16)))});
        v3TBSCertificateGenerator.setExtensions(extensions);
        TBSCertificate tBSCertificate = v3TBSCertificateGenerator.generateTBSCertificate();
        byte[] byArray = tBSCertificate.getEncoded();
        if (!Arrays.areEqual(byArray, this.v3Cert)) {
            this.fail("failed v3 cert generation");
        }
        if (!Arrays.areEqual(byArray = (aSN1Primitive = ASN1Primitive.fromByteArray(this.v3Cert)).getEncoded(), this.v3Cert)) {
            this.fail("failed v3 cert read back test");
        }
    }

    private void tbsV3CertGenWithNullSubject() throws IOException {
        ASN1Primitive aSN1Primitive;
        V3TBSCertificateGenerator v3TBSCertificateGenerator;
        block4: {
            v3TBSCertificateGenerator = new V3TBSCertificateGenerator();
            Date date = new Date(1000L);
            Date date2 = new Date(2000L);
            v3TBSCertificateGenerator.setSerialNumber(new ASN1Integer(2L));
            v3TBSCertificateGenerator.setStartDate(new Time(date));
            v3TBSCertificateGenerator.setEndDate(new Time(date2));
            v3TBSCertificateGenerator.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
            v3TBSCertificateGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, DERNull.INSTANCE));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new ASN1Integer(3L));
            v3TBSCertificateGenerator.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
            try {
                v3TBSCertificateGenerator.generateTBSCertificate();
                this.fail("null subject not caught!");
            }
            catch (IllegalStateException illegalStateException) {
                if (illegalStateException.getMessage().equals("not all mandatory fields set in V3 TBScertificate generator")) break block4;
                this.fail("unexpected exception", illegalStateException);
            }
        }
        Extensions extensions = new Extensions(new Extension(Extension.subjectAlternativeName, true, (ASN1OctetString)new DEROctetString(new GeneralNames(new GeneralName(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"))))));
        v3TBSCertificateGenerator.setExtensions(extensions);
        TBSCertificate tBSCertificate = v3TBSCertificateGenerator.generateTBSCertificate();
        byte[] byArray = tBSCertificate.getEncoded();
        if (!Arrays.areEqual(byArray, this.v3CertNullSubject)) {
            this.fail("failed v3 null sub cert generation");
        }
        if (!Arrays.areEqual(byArray = (aSN1Primitive = ASN1Primitive.fromByteArray(this.v3CertNullSubject)).getEncoded(), this.v3CertNullSubject)) {
            this.fail("failed v3 null sub cert read back test");
        }
    }

    public void testAllowedDuplicateExtensions() throws Exception {
        GeneralName generalName = new GeneralName(2, "bc1.local");
        GeneralName generalName2 = new GeneralName(2, "bc2.local");
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, new DERSequence(generalName));
        extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, new DERSequence(generalName2));
        extensionsGenerator.addExtension(Extension.issuerAlternativeName, false, new DERSequence(generalName));
        extensionsGenerator.addExtension(Extension.issuerAlternativeName, false, new DERSequence(generalName2));
        extensionsGenerator.addExtension(Extension.subjectDirectoryAttributes, false, new DERSequence(generalName));
        extensionsGenerator.addExtension(Extension.subjectDirectoryAttributes, false, new DERSequence(generalName2));
        extensionsGenerator.addExtension(Extension.certificateIssuer, false, new DERSequence(generalName));
        extensionsGenerator.addExtension(Extension.certificateIssuer, false, new DERSequence(generalName2));
        extensionsGenerator.addExtension(Extension.auditIdentity, false, new DERSequence(generalName));
        try {
            extensionsGenerator.addExtension(Extension.auditIdentity, false, new DERSequence(generalName2));
            this.fail("Expected exception, not a white listed duplicate.");
        }
        catch (Exception exception) {}
    }

    public void testDuplicateExtensions() throws IOException {
        GeneralName generalName = new GeneralName(2, "bc1.local");
        GeneralName generalName2 = new GeneralName(2, "bc2.local");
        ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
        extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, new DERSequence(generalName));
        extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, new DERSequence(generalName2));
        Extensions extensions = Extensions.getInstance(ASN1Sequence.getInstance(extensionsGenerator.generate().getEncoded()));
        Extension extension = extensions.getExtension(Extension.subjectAlternativeName);
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(extension.getParsedValue());
        if (!GeneralName.getInstance(aSN1Sequence.getObjectAt(0)).equals(generalName)) {
            this.fail("expected name 1");
        }
        if (!GeneralName.getInstance(aSN1Sequence.getObjectAt(1)).equals(generalName2)) {
            this.fail("expected name 2");
        }
        ExtensionsGenerator extensionsGenerator2 = new ExtensionsGenerator();
        extensionsGenerator2.addExtension(extensions);
        extensions = Extensions.getInstance(ASN1Sequence.getInstance(extensionsGenerator2.generate().getEncoded()));
        extension = extensions.getExtension(Extension.subjectAlternativeName);
        aSN1Sequence = ASN1Sequence.getInstance(extension.getParsedValue());
        if (!GeneralName.getInstance(aSN1Sequence.getObjectAt(0)).equals(generalName)) {
            this.fail("expected name 1");
        }
        if (!GeneralName.getInstance(aSN1Sequence.getObjectAt(1)).equals(generalName2)) {
            this.fail("expected name 2");
        }
    }
}

