/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.util.test.SimpleTest;

public class LocaleTest
extends SimpleTest {
    private void doTestLocale(Locale locale) throws Exception {
        long l = 1538063166000L;
        String string = "180927154606GMT+00:00";
        String string2 = "20180927154606Z";
        Locale.setDefault(locale);
        this.isTrue("a", l == new DERUTCTime(string).getAdjustedDate().getTime());
        this.isTrue("b", l == new DERGeneralizedTime(string2).getDate().getTime());
        this.isTrue("c", l == new DERUTCTime(new Date(l)).getAdjustedDate().getTime());
        this.isTrue("d", l == new DERGeneralizedTime(new Date(l)).getDate().getTime());
        Date date = new Date();
        this.isTrue("e", date.getTime() - date.getTime() % 1000L == new DERUTCTime(date).getAdjustedDate().getTime());
        this.isTrue("f", date.getTime() - date.getTime() % 1000L == new DERGeneralizedTime(date).getDate().getTime());
    }

    public String getName() {
        return "LocaleTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new LocaleTest());
    }

    public void performTest() throws Exception {
        Locale locale = Locale.getDefault();
        Locale[] localeArray = DateFormat.getAvailableLocales();
        int n = 0;
        while (n != localeArray.length) {
            if (!localeArray[n].getCountry().equals("TH") && !localeArray[n].getCountry().equals("JP")) {
                this.doTestLocale(localeArray[n]);
            }
            ++n;
        }
        Locale.setDefault(locale);
    }
}

