/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.test.ASN1UnitTest;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x509.sigi.NameOrPseudonym;
import org.bouncycastle.asn1.x509.sigi.PersonalData;
import org.bouncycastle.util.test.SimpleTest;

public class PersonalDataUnitTest
extends ASN1UnitTest {
    private void checkConstruction(PersonalData personalData, NameOrPseudonym nameOrPseudonym, BigInteger bigInteger, ASN1GeneralizedTime aSN1GeneralizedTime, DirectoryString directoryString, String string, DirectoryString directoryString2) throws IOException {
        this.checkValues(personalData, nameOrPseudonym, bigInteger, aSN1GeneralizedTime, directoryString, string, directoryString2);
        personalData = PersonalData.getInstance(personalData);
        this.checkValues(personalData, nameOrPseudonym, bigInteger, aSN1GeneralizedTime, directoryString, string, directoryString2);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(personalData.toASN1Primitive().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        personalData = PersonalData.getInstance(aSN1Sequence);
        this.checkValues(personalData, nameOrPseudonym, bigInteger, aSN1GeneralizedTime, directoryString, string, directoryString2);
    }

    private void checkValues(PersonalData personalData, NameOrPseudonym nameOrPseudonym, BigInteger bigInteger, ASN1GeneralizedTime aSN1GeneralizedTime, DirectoryString directoryString, String string, DirectoryString directoryString2) {
        this.checkMandatoryField("nameOrPseudonym", nameOrPseudonym, personalData.getNameOrPseudonym());
        this.checkOptionalField("nameDistinguisher", bigInteger, personalData.getNameDistinguisher());
        this.checkOptionalField("dateOfBirth", aSN1GeneralizedTime, personalData.getDateOfBirth());
        this.checkOptionalField("placeOfBirth", directoryString, personalData.getPlaceOfBirth());
        this.checkOptionalField("gender", string, personalData.getGender());
        this.checkOptionalField("postalAddress", directoryString2, personalData.getPostalAddress());
    }

    public String getName() {
        return "PersonalData";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new PersonalDataUnitTest());
    }

    public void performTest() throws Exception {
        NameOrPseudonym nameOrPseudonym = new NameOrPseudonym("pseudonym");
        BigInteger bigInteger = BigInteger.valueOf(10L);
        ASN1GeneralizedTime aSN1GeneralizedTime = new ASN1GeneralizedTime("20070315173729Z");
        DirectoryString directoryString = new DirectoryString("placeOfBirth");
        String string = "M";
        DirectoryString directoryString2 = new DirectoryString("address");
        PersonalData personalData = new PersonalData(nameOrPseudonym, bigInteger, aSN1GeneralizedTime, directoryString, string, directoryString2);
        this.checkConstruction(personalData, nameOrPseudonym, bigInteger, aSN1GeneralizedTime, directoryString, string, directoryString2);
        personalData = new PersonalData(nameOrPseudonym, null, aSN1GeneralizedTime, directoryString, string, directoryString2);
        this.checkConstruction(personalData, nameOrPseudonym, null, aSN1GeneralizedTime, directoryString, string, directoryString2);
        personalData = new PersonalData(nameOrPseudonym, bigInteger, null, directoryString, string, directoryString2);
        this.checkConstruction(personalData, nameOrPseudonym, bigInteger, null, directoryString, string, directoryString2);
        personalData = new PersonalData(nameOrPseudonym, bigInteger, aSN1GeneralizedTime, null, string, directoryString2);
        this.checkConstruction(personalData, nameOrPseudonym, bigInteger, aSN1GeneralizedTime, null, string, directoryString2);
        personalData = new PersonalData(nameOrPseudonym, bigInteger, aSN1GeneralizedTime, directoryString, null, directoryString2);
        this.checkConstruction(personalData, nameOrPseudonym, bigInteger, aSN1GeneralizedTime, directoryString, null, directoryString2);
        personalData = new PersonalData(nameOrPseudonym, bigInteger, aSN1GeneralizedTime, directoryString, string, null);
        this.checkConstruction(personalData, nameOrPseudonym, bigInteger, aSN1GeneralizedTime, directoryString, string, null);
        personalData = PersonalData.getInstance(null);
        if (personalData != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            PersonalData.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

