/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class X509NameTest
extends SimpleTest {
    String[] subjects = new String[]{"C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Webserver Team,CN=www2.connect4.com.au,E=webmaster@connect4.com.au", "C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Certificate Authority,CN=Connect 4 CA,E=webmaster@connect4.com.au", "C=AU,ST=QLD,CN=SSLeay/rsa test cert", "C=US,O=National Aeronautics and Space Administration,SERIALNUMBER=16+CN=Steve Schoch", "E=cooke@issl.atl.hp.com,C=US,OU=Hewlett Packard Company (ISSL),CN=Paul A. Cooke", "O=Sun Microsystems Inc,CN=store.sun.com", "unstructuredAddress=192.168.1.33,unstructuredName=pixfirewall.ciscopix.com,CN=pixfirewall.ciscopix.com", "CN=*.canal-plus.com,OU=Provided by TBS INTERNET https://www.tbs-certificats.com/,OU=\\ CANAL \\+,O=CANAL\\+DISTRIBUTION,L=issy les moulineaux,ST=Hauts de Seine,C=FR", "O=Bouncy Castle,CN=www.bouncycastle.org\\ ", "O=Bouncy Castle,CN=c:\\\\fred\\\\bob"};

    private boolean compareVectors(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            return false;
        }
        int n = 0;
        while (n != vector.size()) {
            if (!vector.elementAt(n).equals(vector2.elementAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void compositeTest() throws IOException {
        byte[] byArray;
        byte[] byArray2 = Hex.decode("305e310b300906035504061302415531283026060355040a0c1f546865204c6567696f6e206f662074686520426f756e637920436173746c653125301006035504070c094d656c626f75726e653011060355040b0c0a4173636f742056616c65");
        X509Name x509Name = X509Name.getInstance(ASN1Primitive.fromByteArray(byArray2));
        if (!x509Name.toString().equals("C=AU,O=The Legion of the Bouncy Castle,L=Melbourne+OU=Ascot Vale")) {
            this.fail("Failed composite to string test got: " + x509Name.toString());
        }
        if (!x509Name.toString(true, X509Name.DefaultSymbols).equals("L=Melbourne+OU=Ascot Vale,O=The Legion of the Bouncy Castle,C=AU")) {
            this.fail("Failed composite to string test got: " + x509Name.toString(true, X509Name.DefaultSymbols));
        }
        if (!(x509Name = new X509Name(true, "L=Melbourne+OU=Ascot Vale,O=The Legion of the Bouncy Castle,C=AU")).toString().equals("C=AU,O=The Legion of the Bouncy Castle,L=Melbourne+OU=Ascot Vale")) {
            this.fail("Failed composite to string reversal test got: " + x509Name.toString());
        }
        if (!Arrays.areEqual(byArray2, byArray = (x509Name = new X509Name("C=AU, O=The Legion of the Bouncy Castle, L=Melbourne + OU=Ascot Vale")).getEncoded())) {
            this.fail("Failed composite string to encoding test");
        }
        x509Name = new X509Name("C=CH,O=,OU=dummy,CN=mail@dummy.com");
        x509Name = X509Name.getInstance(ASN1Primitive.fromByteArray(x509Name.getEncoded()));
    }

    private ASN1Encodable createEntryValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        Hashtable<ASN1ObjectIdentifier, String> hashtable = new Hashtable<ASN1ObjectIdentifier, String>();
        hashtable.put(aSN1ObjectIdentifier, string);
        Vector<ASN1ObjectIdentifier> vector = new Vector<ASN1ObjectIdentifier>();
        vector.addElement(aSN1ObjectIdentifier);
        X509Name x509Name = new X509Name(vector, hashtable);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)x509Name.toASN1Primitive();
        ASN1Set aSN1Set = (ASN1Set)aSN1Sequence.getObjectAt(0);
        aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(0);
        return aSN1Sequence.getObjectAt(1);
    }

    private ASN1Encodable createEntryValueFromString(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        Hashtable<ASN1ObjectIdentifier, String> hashtable = new Hashtable<ASN1ObjectIdentifier, String>();
        hashtable.put(aSN1ObjectIdentifier, string);
        Vector<ASN1ObjectIdentifier> vector = new Vector<ASN1ObjectIdentifier>();
        vector.addElement(aSN1ObjectIdentifier);
        X509Name x509Name = new X509Name(new X509Name(vector, hashtable).toString());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)x509Name.toASN1Primitive();
        ASN1Set aSN1Set = (ASN1Set)aSN1Sequence.getObjectAt(0);
        aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(0);
        return aSN1Sequence.getObjectAt(1);
    }

    private void equalityTest(X509Name x509Name, X509Name x509Name2) {
        if (!x509Name.equals(x509Name2)) {
            this.fail("equality test failed for " + x509Name + " : " + x509Name2);
        }
        if (x509Name.hashCode() != x509Name2.hashCode()) {
            this.fail("hashCodeTest test failed for " + x509Name + " : " + x509Name2);
        }
        if (!x509Name.equals(x509Name2, true)) {
            this.fail("equality test failed for " + x509Name + " : " + x509Name2);
        }
    }

    private static X509Name fromBytes(byte[] byArray) throws IOException {
        return X509Name.getInstance(ASN1Primitive.fromByteArray(byArray));
    }

    public String getName() {
        return "X509Name";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new X509NameTest());
    }

    public void performTest() throws Exception {
        Vector vector;
        X509Name x509Name;
        X509Name x509Name2;
        Vector vector2;
        Vector vector3;
        X509Name x509Name3;
        this.testEncodingPrintableString(X509Name.C, "AU");
        this.testEncodingPrintableString(X509Name.SERIALNUMBER, "123456");
        this.testEncodingPrintableString(X509Name.DN_QUALIFIER, "123456");
        this.testEncodingIA5String(X509Name.EmailAddress, "test@test.com");
        this.testEncodingIA5String(X509Name.DC, "test");
        this.testEncodingGeneralizedTime(X509Name.DATE_OF_BIRTH, "#180F32303032303132323132323232305A");
        this.testEncodingGeneralizedTime(X509Name.DATE_OF_BIRTH, "20020122122220Z");
        this.testEncodingUTF8String(X509Name.CN, "M\u00c3\u00b6rsky");
        Hashtable<ASN1ObjectIdentifier, String> hashtable = new Hashtable<ASN1ObjectIdentifier, String>();
        hashtable.put(X509Name.C, "AU");
        hashtable.put(X509Name.O, "The Legion of the Bouncy Castle");
        hashtable.put(X509Name.L, "Melbourne");
        hashtable.put(X509Name.ST, "Victoria");
        hashtable.put(X509Name.E, "feedback-crypto@bouncycastle.org");
        Vector<ASN1ObjectIdentifier> vector4 = new Vector<ASN1ObjectIdentifier>();
        vector4.addElement(X509Name.C);
        vector4.addElement(X509Name.O);
        vector4.addElement(X509Name.L);
        vector4.addElement(X509Name.ST);
        vector4.addElement(X509Name.E);
        X509Name x509Name4 = new X509Name(vector4, hashtable);
        if (!x509Name4.equals(x509Name4)) {
            this.fail("Failed same object test");
        }
        if (!x509Name4.equals(x509Name4, true)) {
            this.fail("Failed same object test - in Order");
        }
        if (!x509Name4.equals(x509Name3 = new X509Name(vector4, hashtable))) {
            this.fail("Failed same name test");
        }
        if (!x509Name4.equals(x509Name3, true)) {
            this.fail("Failed same name test - in Order");
        }
        if (x509Name4.hashCode() != x509Name3.hashCode()) {
            this.fail("Failed same name test - in Order");
        }
        Vector<ASN1ObjectIdentifier> vector5 = new Vector<ASN1ObjectIdentifier>();
        vector5.addElement(X509Name.C);
        vector5.addElement(X509Name.O);
        vector5.addElement(X509Name.L);
        vector5.addElement(X509Name.ST);
        vector5.addElement(X509Name.E);
        Vector<ASN1ObjectIdentifier> vector6 = new Vector<ASN1ObjectIdentifier>();
        vector6.addElement(X509Name.E);
        vector6.addElement(X509Name.ST);
        vector6.addElement(X509Name.L);
        vector6.addElement(X509Name.O);
        vector6.addElement(X509Name.C);
        x509Name4 = new X509Name(vector5, hashtable);
        x509Name3 = new X509Name(vector6, hashtable);
        if (!x509Name4.equals(x509Name3)) {
            this.fail("Failed reverse name test");
        }
        if (x509Name4.hashCode() != x509Name3.hashCode()) {
            this.fail("Failed reverse name test hashCode");
        }
        if (x509Name4.equals(x509Name3, true)) {
            this.fail("Failed reverse name test - in Order");
        }
        if (!x509Name4.equals(x509Name3, false)) {
            this.fail("Failed reverse name test - in Order false");
        }
        if (!this.compareVectors(vector3 = x509Name4.getOIDs(), vector5)) {
            this.fail("oid comparison test");
        }
        Vector<String> vector7 = new Vector<String>();
        vector7.addElement("AU");
        vector7.addElement("The Legion of the Bouncy Castle");
        vector7.addElement("Melbourne");
        vector7.addElement("Victoria");
        vector7.addElement("feedback-crypto@bouncycastle.org");
        x509Name4 = new X509Name(vector5, vector7);
        Vector vector8 = x509Name4.getValues();
        if (!this.compareVectors(vector8, vector7)) {
            this.fail("value comparison test");
        }
        vector6 = new Vector();
        vector6.addElement(X509Name.ST);
        vector6.addElement(X509Name.ST);
        vector6.addElement(X509Name.L);
        vector6.addElement(X509Name.O);
        vector6.addElement(X509Name.C);
        x509Name4 = new X509Name(vector5, hashtable);
        x509Name3 = new X509Name(vector6, hashtable);
        if (x509Name4.equals(x509Name3)) {
            this.fail("Failed different name test");
        }
        vector6 = new Vector();
        vector6.addElement(X509Name.ST);
        vector6.addElement(X509Name.L);
        vector6.addElement(X509Name.O);
        vector6.addElement(X509Name.C);
        x509Name4 = new X509Name(vector5, hashtable);
        x509Name3 = new X509Name(vector6, hashtable);
        if (x509Name4.equals(x509Name3)) {
            this.fail("Failed subset name test");
        }
        this.compositeTest();
        Vector vector9 = x509Name4.getValues(X509Name.O);
        if (vector9.size() != 1 || !vector9.elementAt(0).equals("The Legion of the Bouncy Castle")) {
            this.fail("O test failed");
        }
        if ((vector2 = x509Name4.getValues(X509Name.L)).size() != 1 || !vector2.elementAt(0).equals("Melbourne")) {
            this.fail("L test failed");
        }
        int n = 0;
        while (n != this.subjects.length) {
            x509Name2 = new X509Name(this.subjects[n]);
            if (!(x509Name2 = X509Name.getInstance(ASN1Primitive.fromByteArray(x509Name2.getEncoded()))).toString().equals(this.subjects[n])) {
                this.fail("failed regeneration test " + n + " got " + x509Name2.toString());
            }
            ++n;
        }
        x509Name2 = new X509Name("SERIALNUMBER=BBB + CN=AA");
        if (!X509NameTest.fromBytes(x509Name2.getEncoded()).toString().equals("CN=AA+SERIALNUMBER=BBB")) {
            this.fail("failed sort test 1");
        }
        if (!X509NameTest.fromBytes((x509Name2 = new X509Name("CN=AA + SERIALNUMBER=BBB")).getEncoded()).toString().equals("CN=AA+SERIALNUMBER=BBB")) {
            this.fail("failed sort test 2");
        }
        if (!X509NameTest.fromBytes((x509Name2 = new X509Name("SERIALNUMBER=B + CN=AA")).getEncoded()).toString().equals("SERIALNUMBER=B+CN=AA")) {
            this.fail("failed sort test 3");
        }
        if (!X509NameTest.fromBytes((x509Name2 = new X509Name("CN=AA + SERIALNUMBER=B")).getEncoded()).toString().equals("SERIALNUMBER=B+CN=AA")) {
            this.fail("failed sort test 4");
        }
        this.equalityTest(new X509Name("CN=The     Legion"), new X509Name("CN=The Legion"));
        this.equalityTest(new X509Name("CN=   The Legion"), new X509Name("CN=The Legion"));
        this.equalityTest(new X509Name("CN=The Legion   "), new X509Name("CN=The Legion"));
        this.equalityTest(new X509Name("CN=  The     Legion "), new X509Name("CN=The Legion"));
        this.equalityTest(new X509Name("CN=  the     legion "), new X509Name("CN=The Legion"));
        X509Name x509Name5 = new X509Name("SERIALNUMBER=8,O=ABC,CN=ABC Class 3 CA,C=LT");
        X509Name x509Name6 = new X509Name("2.5.4.5=8,O=ABC,CN=ABC Class 3 CA,C=LT");
        X509Name x509Name7 = new X509Name("2.5.4.5=#130138,O=ABC,CN=ABC Class 3 CA,C=LT");
        this.equalityTest(x509Name5, x509Name6);
        this.equalityTest(x509Name6, x509Name7);
        this.equalityTest(x509Name7, x509Name5);
        x509Name5 = new X509Name(true, "2.5.4.5=#130138,CN=SSC Class 3 CA,O=UAB Skaitmeninio sertifikavimo centras,C=LT");
        x509Name6 = new X509Name(true, "SERIALNUMBER=#130138,CN=SSC Class 3 CA,O=UAB Skaitmeninio sertifikavimo centras,C=LT");
        x509Name7 = X509Name.getInstance(ASN1Primitive.fromByteArray(Hex.decode("3063310b3009060355040613024c54312f302d060355040a132655414220536b6169746d656e696e696f20736572746966696b6176696d6f2063656e74726173311730150603550403130e53534320436c6173732033204341310a30080603550405130138")));
        this.equalityTest(x509Name5, x509Name6);
        this.equalityTest(x509Name6, x509Name7);
        this.equalityTest(x509Name7, x509Name5);
        x509Name5 = new X509Name("SERIALNUMBER=8,O=XX,CN=ABC Class 3 CA,C=LT");
        x509Name6 = new X509Name("2.5.4.5=8,O=,CN=ABC Class 3 CA,C=LT");
        if (x509Name5.equals(x509Name6)) {
            this.fail("empty inequality check failed");
        }
        x509Name5 = new X509Name("SERIALNUMBER=8,O=,CN=ABC Class 3 CA,C=LT");
        x509Name6 = new X509Name("2.5.4.5=8,O=,CN=ABC Class 3 CA,C=LT");
        this.equalityTest(x509Name5, x509Name6);
        x509Name4 = new X509Name("CN=The Legion");
        if (x509Name4.equals(new DERSequence())) {
            this.fail("inequality test with sequence");
        }
        if (x509Name4.equals(new DERSequence(new DERSet()))) {
            this.fail("inequality test with sequence and set");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1ObjectIdentifier("1.1"));
        aSN1EncodableVector.add(new ASN1ObjectIdentifier("1.1"));
        if (x509Name4.equals(new DERSequence(new DERSet(new DERSet(aSN1EncodableVector))))) {
            this.fail("inequality test with sequence and bad set");
        }
        if (x509Name4.equals(new DERSequence(new DERSet(new DERSet(aSN1EncodableVector))), true)) {
            this.fail("inequality test with sequence and bad set");
        }
        if (x509Name4.equals(new DERSequence(new DERSet(new DERSequence())))) {
            this.fail("inequality test with sequence and short sequence");
        }
        if (x509Name4.equals(new DERSequence(new DERSet(new DERSequence())), true)) {
            this.fail("inequality test with sequence and short sequence");
        }
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1ObjectIdentifier("1.1"));
        aSN1EncodableVector.add(new DERSequence());
        if (x509Name4.equals(new DERSequence(new DERSet(new DERSequence(aSN1EncodableVector))))) {
            this.fail("inequality test with sequence and bad sequence");
        }
        if (x509Name4.equals(null)) {
            this.fail("inequality test with null");
        }
        if (x509Name4.equals(null, true)) {
            this.fail("inequality test with null");
        }
        x509Name2 = new X509Name("CN=AA + CN=AA + CN=AA");
        DERUTF8String dERUTF8String = new DERUTF8String("The Legion of the Bouncy Castle");
        byte[] byArray = dERUTF8String.getEncoded();
        byte[] byArray2 = Hex.encode(byArray);
        String string = "#" + new String(byArray2);
        ASN1UTF8String aSN1UTF8String = (ASN1UTF8String)new X509DefaultEntryConverter().getConvertedValue(X509Name.L, string);
        if (!aSN1UTF8String.equals(dERUTF8String)) {
            this.fail("failed X509DefaultEntryConverter test");
        }
        if (!(aSN1UTF8String = (ASN1UTF8String)new X509DefaultEntryConverter().getConvertedValue(X509Name.L, "\\" + string)).equals(new DERUTF8String(string))) {
            this.fail("failed X509DefaultEntryConverter test got " + aSN1UTF8String + " expected: " + string);
        }
        if (!(x509Name = new X509Name("CN=\\#nothex#string")).toString().equals("CN=\\#nothex#string")) {
            this.fail("# string not properly escaped.");
        }
        if ((vector = x509Name.getValues(X509Name.CN)).size() != 1 || !vector.elementAt(0).equals("#nothex#string")) {
            this.fail("escaped # not reduced properly");
        }
        if ((vector = (x509Name = new X509Name("CN=\"a+b\"")).getValues(X509Name.CN)).size() != 1 || !vector.elementAt(0).equals("a+b")) {
            this.fail("escaped + not reduced properly");
        }
        if ((vector = (x509Name = new X509Name("CN=a\\+b")).getValues(X509Name.CN)).size() != 1 || !vector.elementAt(0).equals("a+b")) {
            this.fail("escaped + not reduced properly");
        }
        if (!x509Name.toString().equals("CN=a\\+b")) {
            this.fail("+ in string not properly escaped.");
        }
        if ((vector = (x509Name = new X509Name("CN=a\\=b")).getValues(X509Name.CN)).size() != 1 || !vector.elementAt(0).equals("a=b")) {
            this.fail("escaped = not reduced properly");
        }
        if (!x509Name.toString().equals("CN=a\\=b")) {
            this.fail("= in string not properly escaped.");
        }
        if ((vector = (x509Name = new X509Name("TELEPHONENUMBER=\"+61999999999\"")).getValues(X509Name.TELEPHONE_NUMBER)).size() != 1 || !vector.elementAt(0).equals("+61999999999")) {
            this.fail("telephonenumber escaped + not reduced properly");
        }
        if ((vector = (x509Name = new X509Name("TELEPHONENUMBER=\\+61999999999")).getValues(X509Name.TELEPHONE_NUMBER)).size() != 1 || !vector.elementAt(0).equals("+61999999999")) {
            this.fail("telephonenumber escaped + not reduced properly");
        }
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addMultiValuedRDN(new ASN1ObjectIdentifier[]{BCStyle.CN, BCStyle.SN}, new String[]{"Thomas", "CVR:12341233-UID:1111"});
        x500NameBuilder.addRDN(BCStyle.O, "Test");
        x500NameBuilder.addRDN(BCStyle.C, "DK");
        X500Name x500Name = x500NameBuilder.build();
        ASN1Primitive aSN1Primitive = x500Name.toASN1Primitive();
        X509Name x509Name8 = X509Name.getInstance(aSN1Primitive);
    }

    private void testEncodingGeneralizedTime(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        ASN1Encodable aSN1Encodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(aSN1Encodable instanceof ASN1GeneralizedTime)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not GeneralizedTime");
        }
        if (!((aSN1Encodable = this.createEntryValueFromString(aSN1ObjectIdentifier, string)) instanceof ASN1GeneralizedTime)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not GeneralizedTime");
        }
    }

    private void testEncodingIA5String(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        ASN1Encodable aSN1Encodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(aSN1Encodable instanceof ASN1IA5String)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not IA5String");
        }
    }

    private void testEncodingPrintableString(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        ASN1Encodable aSN1Encodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(aSN1Encodable instanceof ASN1PrintableString)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not printable string");
        }
    }

    private void testEncodingUTF8String(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) throws IOException {
        ASN1Encodable aSN1Encodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(aSN1Encodable instanceof ASN1UTF8String)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not UTF8String");
        }
        if (!string.equals(ASN1UTF8String.getInstance(aSN1Encodable.toASN1Primitive().getEncoded()).getString())) {
            this.fail("decoding not correct");
        }
    }
}

