/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class BlockCipherVectorTest
extends SimpleTest {
    int id;
    BlockCipher engine;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public BlockCipherVectorTest(int n, BlockCipher blockCipher, CipherParameters cipherParameters, String string, String string2) {
        this.id = n;
        this.engine = blockCipher;
        this.param = cipherParameters;
        this.input = Hex.decode(string);
        this.output = Hex.decode(string2);
    }

    public String getName() {
        return String.valueOf(this.engine.getAlgorithmName()) + " Vector Test " + this.id;
    }

    public void performTest() throws Exception {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(this.engine);
        bufferedBlockCipher.init(true, this.param);
        byte[] byArray = new byte[this.input.length];
        int n = bufferedBlockCipher.processBytes(this.input, 0, this.input.length, byArray, 0);
        bufferedBlockCipher.doFinal(byArray, n);
        if (!this.areEqual(byArray, this.output)) {
            this.fail("failed - expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(byArray)));
        }
        bufferedBlockCipher.init(false, this.param);
        int n2 = bufferedBlockCipher.processBytes(this.output, 0, this.output.length, byArray, 0);
        bufferedBlockCipher.doFinal(byArray, n2);
        if (!this.areEqual(this.input, byArray)) {
            System.out.println(" got " + new String(Hex.encode(byArray)));
            this.fail("failed reversal - expected " + new String(Hex.encode(this.input)));
        }
    }
}

