/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.engines.CAST6Engine;
import org.bouncycastle.crypto.engines.CamelliaEngine;
import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.Grain128Engine;
import org.bouncycastle.crypto.engines.Grainv1Engine;
import org.bouncycastle.crypto.engines.HC128Engine;
import org.bouncycastle.crypto.engines.HC256Engine;
import org.bouncycastle.crypto.engines.NoekeonEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.engines.RC6Engine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.engines.SerpentEngine;
import org.bouncycastle.crypto.engines.TEAEngine;
import org.bouncycastle.crypto.engines.ThreefishEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.engines.XSalsa20Engine;
import org.bouncycastle.crypto.engines.XTEAEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.io.InvalidCipherTextIOException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.modes.EAXBlockCipher;
import org.bouncycastle.crypto.modes.NISTCTSBlockCipher;
import org.bouncycastle.crypto.modes.OCBBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.test.SimpleTest;

public class CipherStreamTest
extends SimpleTest {
    private int streamSize;

    private boolean areEqual(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2;
        while (n3 != byArray2.length) {
            if (byArray[n + n3 - n2] != byArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private InputStream createCipherInputStream(byte[] byArray, Object object) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (object instanceof BufferedBlockCipher) {
            return new CipherInputStream((InputStream)byteArrayInputStream, (BufferedBlockCipher)object);
        }
        if (object instanceof AEADBlockCipher) {
            return new CipherInputStream((InputStream)byteArrayInputStream, (AEADBlockCipher)object);
        }
        return new CipherInputStream((InputStream)byteArrayInputStream, (StreamCipher)object);
    }

    private OutputStream createCipherOutputStream(OutputStream outputStream, Object object) {
        if (object instanceof BufferedBlockCipher) {
            return new CipherOutputStream(outputStream, (BufferedBlockCipher)object);
        }
        if (object instanceof AEADBlockCipher) {
            return new CipherOutputStream(outputStream, (AEADBlockCipher)object);
        }
        return new CipherOutputStream(outputStream, (StreamCipher)object);
    }

    protected void fail(String string, boolean bl, boolean bl2) {
        if (bl2 || !bl) {
            super.fail(string);
        } else {
            System.err.println("Broken JCE Streams: " + string);
        }
    }

    private int getBlockSize(Object object) {
        if (object instanceof BlockCipher) {
            return ((BlockCipher)object).getBlockSize();
        }
        if (object instanceof BufferedBlockCipher) {
            return ((BufferedBlockCipher)object).getBlockSize();
        }
        if (object instanceof AEADBlockCipher) {
            return ((AEADBlockCipher)object).getUnderlyingCipher().getBlockSize();
        }
        if (object instanceof StreamCipher) {
            return 1;
        }
        return 0;
    }

    public String getName() {
        return "CipherStreamTest";
    }

    private String getName(Object object) {
        if (object instanceof BufferedBlockCipher) {
            return ((BufferedBlockCipher)object).getUnderlyingCipher().getAlgorithmName();
        }
        if (object instanceof AEADBlockCipher) {
            return ((AEADBlockCipher)object).getUnderlyingCipher().getAlgorithmName();
        }
        if (object instanceof StreamCipher) {
            return ((StreamCipher)object).getAlgorithmName();
        }
        return null;
    }

    private void init(Object object, boolean bl, CipherParameters cipherParameters) {
        if (object instanceof BufferedBlockCipher) {
            ((BufferedBlockCipher)object).init(bl, cipherParameters);
        } else if (object instanceof AEADBlockCipher) {
            ((AEADBlockCipher)object).init(bl, cipherParameters);
        } else if (object instanceof StreamCipher) {
            ((StreamCipher)object).init(bl, cipherParameters);
        }
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new CipherStreamTest());
    }

    public void performTest() throws Exception {
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 7;
        nArray[3] = 8;
        nArray[4] = 9;
        nArray[5] = 15;
        nArray[6] = 16;
        nArray[7] = 17;
        nArray[8] = 1023;
        nArray[9] = 1024;
        nArray[10] = 1025;
        nArray[11] = 2047;
        nArray[12] = 2048;
        nArray[13] = 2049;
        nArray[14] = 4095;
        nArray[15] = 4096;
        nArray[16] = 4097;
        int[] nArray2 = nArray;
        int n = 0;
        while (n < nArray2.length) {
            this.streamSize = nArray2[n];
            this.performTests();
            ++n;
        }
    }

    private void performTests() throws Exception {
        this.testModes(new BlowfishEngine(), new BlowfishEngine(), 16);
        this.testModes(new DESEngine(), new DESEngine(), 8);
        this.testModes(new DESedeEngine(), new DESedeEngine(), 24);
        this.testModes(new TEAEngine(), new TEAEngine(), 16);
        this.testModes(new CAST5Engine(), new CAST5Engine(), 16);
        this.testModes(new RC2Engine(), new RC2Engine(), 16);
        this.testModes(new XTEAEngine(), new XTEAEngine(), 16);
        this.testModes(new AESEngine(), new AESEngine(), 16);
        this.testModes(new NoekeonEngine(), new NoekeonEngine(), 16);
        this.testModes(new TwofishEngine(), new TwofishEngine(), 16);
        this.testModes(new CAST6Engine(), new CAST6Engine(), 16);
        this.testModes(new SEEDEngine(), new SEEDEngine(), 16);
        this.testModes(new SerpentEngine(), new SerpentEngine(), 16);
        this.testModes(new RC6Engine(), new RC6Engine(), 16);
        this.testModes(new CamelliaEngine(), new CamelliaEngine(), 16);
        this.testModes(new ThreefishEngine(512), new ThreefishEngine(512), 64);
        this.testMode(new RC4Engine(), new KeyParameter(new byte[16]));
        this.testMode(new Salsa20Engine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
        this.testMode(new XSalsa20Engine(), new ParametersWithIV(new KeyParameter(new byte[32]), new byte[24]));
        this.testMode(new ChaChaEngine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
        this.testMode(new Grainv1Engine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
        this.testMode(new Grain128Engine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[12]));
        this.testMode(new HC128Engine(), new KeyParameter(new byte[16]));
        this.testMode(new HC256Engine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        this.testSkipping(new Salsa20Engine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
        this.testSkipping(new SICBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
    }

    private void testMode(Object object, CipherParameters cipherParameters) throws Exception {
        this.testWriteRead(object, cipherParameters, false);
        this.testWriteRead(object, cipherParameters, true);
        this.testReadWrite(object, cipherParameters, false);
        this.testReadWrite(object, cipherParameters, true);
        if (!(object instanceof CTSBlockCipher) && !(object instanceof NISTCTSBlockCipher)) {
            this.testWriteReadEmpty(object, cipherParameters, false);
            this.testWriteReadEmpty(object, cipherParameters, true);
        }
        if (object instanceof AEADBlockCipher) {
            this.testTamperedRead((AEADBlockCipher)object, cipherParameters);
            this.testTruncatedRead((AEADBlockCipher)object, cipherParameters);
            this.testTamperedWrite((AEADBlockCipher)object, cipherParameters);
        }
    }

    private void testModes(BlockCipher blockCipher, BlockCipher blockCipher2, int n) throws Exception {
        KeyParameter keyParameter = new KeyParameter(new byte[n]);
        int n2 = this.getBlockSize(blockCipher);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, new byte[n2]);
        if (n2 > 1) {
            this.testMode(new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding()), keyParameter);
            this.testMode(new PaddedBufferedBlockCipher(new CBCBlockCipher(blockCipher), new PKCS7Padding()), parametersWithIV);
            this.testMode(new BufferedBlockCipher(new OFBBlockCipher(blockCipher, n2)), parametersWithIV);
            this.testMode(new BufferedBlockCipher(new CFBBlockCipher(blockCipher, n2)), parametersWithIV);
            this.testMode(new BufferedBlockCipher(new SICBlockCipher(blockCipher)), parametersWithIV);
        }
        if (n2 <= 16 && this.streamSize >= n2) {
            this.testMode(new CTSBlockCipher(blockCipher), keyParameter);
        }
        if (n2 <= 16 && this.streamSize >= n2) {
            this.testMode(new NISTCTSBlockCipher(1, blockCipher), keyParameter);
            this.testMode(new NISTCTSBlockCipher(2, blockCipher), keyParameter);
            this.testMode(new NISTCTSBlockCipher(3, blockCipher), keyParameter);
        }
        if (n2 == 8 || n2 == 16) {
            this.testMode(new EAXBlockCipher(blockCipher), parametersWithIV);
        }
        if (n2 == 16) {
            this.testMode(new CCMBlockCipher(blockCipher), new ParametersWithIV(keyParameter, new byte[7]));
            this.testMode(new OCBBlockCipher(blockCipher, blockCipher2), new ParametersWithIV(keyParameter, new byte[15]));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testReadWrite(Object var1_1, CipherParameters var2_2, boolean var3_3) throws Exception {
        var4_4 = "ABCDEFGHIJKLMNOPQRSTU";
        var5_5 = new ByteArrayOutputStream();
        try {
            block8: {
                block7: {
                    this.init(var1_1, true, var2_2);
                    var6_6 = this.createCipherInputStream(var4_4.getBytes(), var1_1);
                    var7_8 = new ByteArrayOutputStream();
                    if (!var3_3) ** GOTO lbl14
                    var8_9 = new byte[this.getBlockSize(var1_1) + 1];
                    while ((var9_11 = var6_6.read((byte[])var8_9)) >= 0) {
                        var7_8.write((byte[])var8_9, 0, var9_11);
                    }
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        var7_8.write(var8_10);
lbl14:
                        // 2 sources

                        ** while ((var8_10 = var6_6.read()) >= 0)
                    }
                }
                var6_6.close();
                this.init(var1_1, false, var2_2);
                var8_9 = new ByteArrayInputStream(var7_8.toByteArray());
                var9_12 = this.createCipherOutputStream(var5_5, var1_1);
                if (!var3_3) ** GOTO lbl27
                var10_13 = new byte[this.getBlockSize(var1_1) + 1];
                while ((var11_15 = var8_9.read(var10_13)) >= 0) {
                    var9_12.write(var10_13, 0, var11_15);
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    var9_12.write(var10_14);
lbl27:
                    // 2 sources

                    ** while ((var10_14 = var8_9.read()) >= 0)
                }
            }
            var9_12.flush();
            var9_12.close();
        }
        catch (Exception var6_7) {
            this.fail("Unexpected exception " + this.getName(var1_1), var6_7);
        }
        var6_6 = new String(var5_5.toByteArray());
        if (!var6_6.equals(var4_4)) {
            this.fail("Failed read/write - decrypted data doesn't match: " + this.getName(var1_1), var4_4, var6_6);
        }
    }

    private void testSkipping(StreamCipher streamCipher, CipherParameters cipherParameters) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.init(streamCipher, true, cipherParameters);
        OutputStream outputStream = this.createCipherOutputStream(byteArrayOutputStream, streamCipher);
        byte[] byArray = new byte[5000];
        new SecureRandom().nextBytes(byArray);
        outputStream.write(byArray);
        outputStream.close();
        this.init(streamCipher, false, cipherParameters);
        InputStream inputStream = this.createCipherInputStream(byteArrayOutputStream.toByteArray(), streamCipher);
        long l = inputStream.skip(50L);
        if (l != 50L) {
            this.fail("wrong number of bytes skipped: " + l);
        }
        byte[] byArray2 = new byte[50];
        inputStream.read(byArray2);
        if (!this.areEqual(byArray, 50, byArray2, 0)) {
            this.fail("initial skip mismatch");
        }
        if ((l = inputStream.skip(3000L)) != 3000L) {
            this.fail("wrong number of bytes skipped: " + l);
        }
        inputStream.read(byArray2);
        if (!this.areEqual(byArray, 3100, byArray2, 0)) {
            this.fail("second skip mismatch");
        }
        streamCipher.reset();
        inputStream = this.createCipherInputStream(byteArrayOutputStream.toByteArray(), streamCipher);
        if (!inputStream.markSupported()) {
            this.fail("marking not supported");
        }
        inputStream.mark(100);
        inputStream.read(byArray2);
        if (!this.areEqual(byArray, 0, byArray2, 0)) {
            this.fail("initial mark read failed");
        }
        inputStream.reset();
        inputStream.read(byArray2);
        if (!this.areEqual(byArray, 0, byArray2, 0)) {
            this.fail(String.valueOf(streamCipher.getAlgorithmName()) + " initial reset read failed");
        }
        inputStream.reset();
        inputStream.read(byArray2);
        inputStream.mark(100);
        inputStream.read(byArray2);
        if (!this.areEqual(byArray, 50, byArray2, 0)) {
            this.fail("second mark read failed");
        }
        inputStream.reset();
        inputStream.read(byArray2);
        if (!this.areEqual(byArray, 50, byArray2, 0)) {
            this.fail(String.valueOf(streamCipher.getAlgorithmName()) + " second reset read failed");
        }
        inputStream.mark(3000);
        l = inputStream.skip(2050L);
        if (l != 2050L) {
            this.fail("wrong number of bytes skipped: " + l);
        }
        inputStream.reset();
        inputStream.read(byArray2);
        if (!this.areEqual(byArray, 100, byArray2, 0)) {
            this.fail(String.valueOf(streamCipher.getAlgorithmName()) + " third reset read failed");
        }
        inputStream.read(new byte[2150]);
        inputStream.reset();
        inputStream.read(byArray2);
        if (!this.areEqual(byArray, 100, byArray2, 0)) {
            this.fail(String.valueOf(streamCipher.getAlgorithmName()) + " fourth reset read failed");
        }
        inputStream.close();
    }

    private void testTamperedRead(AEADBlockCipher aEADBlockCipher, CipherParameters cipherParameters) throws Exception {
        aEADBlockCipher.init(true, cipherParameters);
        byte[] byArray = new byte[aEADBlockCipher.getOutputSize(this.streamSize)];
        aEADBlockCipher.doFinal(byArray, aEADBlockCipher.processBytes(new byte[this.streamSize], 0, this.streamSize, byArray, 0));
        byArray[0] = (byte)(byArray[0] + 1);
        aEADBlockCipher.init(false, cipherParameters);
        InputStream inputStream = this.createCipherInputStream(byArray, aEADBlockCipher);
        try {
            while (inputStream.read() >= 0) {
            }
            this.fail("Expected invalid ciphertext after tamper and read : " + aEADBlockCipher.getAlgorithmName());
        }
        catch (InvalidCipherTextIOException invalidCipherTextIOException) {}
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            this.fail("Unexpected exception after tamper and read : " + aEADBlockCipher.getAlgorithmName());
        }
    }

    private void testTamperedWrite(AEADBlockCipher aEADBlockCipher, CipherParameters cipherParameters) throws Exception {
        aEADBlockCipher.init(true, cipherParameters);
        byte[] byArray = new byte[aEADBlockCipher.getOutputSize(this.streamSize)];
        aEADBlockCipher.doFinal(byArray, aEADBlockCipher.processBytes(new byte[this.streamSize], 0, this.streamSize, byArray, 0));
        byArray[0] = (byte)(byArray[0] + 1);
        aEADBlockCipher.init(false, cipherParameters);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = this.createCipherOutputStream(byteArrayOutputStream, aEADBlockCipher);
        int n = 0;
        while (n < byArray.length) {
            outputStream.write(byArray[n]);
            ++n;
        }
        try {
            outputStream.close();
            this.fail("Expected invalid ciphertext after tamper and write : " + aEADBlockCipher.getAlgorithmName());
        }
        catch (InvalidCipherTextIOException invalidCipherTextIOException) {}
    }

    private void testTruncatedRead(AEADBlockCipher aEADBlockCipher, CipherParameters cipherParameters) throws Exception {
        InputStream inputStream;
        block6: {
            int n;
            aEADBlockCipher.init(true, cipherParameters);
            byte[] byArray = new byte[aEADBlockCipher.getOutputSize(this.streamSize)];
            aEADBlockCipher.doFinal(byArray, aEADBlockCipher.processBytes(new byte[this.streamSize], 0, this.streamSize, byArray, 0));
            byte[] byArray2 = new byte[byArray.length - this.streamSize - 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            aEADBlockCipher.init(false, cipherParameters);
            inputStream = this.createCipherInputStream(byArray2, aEADBlockCipher);
            do {
                n = 0;
                try {
                    n = inputStream.read();
                }
                catch (InvalidCipherTextIOException invalidCipherTextIOException) {
                    break block6;
                }
                catch (Exception exception) {
                    this.fail("Unexpected exception  on truncated read : " + aEADBlockCipher.getAlgorithmName());
                    break block6;
                }
            } while (n >= 0);
            this.fail("Expected invalid ciphertext after truncate and read : " + aEADBlockCipher.getAlgorithmName());
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            this.fail("Unexpected exception after truncate and read : " + aEADBlockCipher.getAlgorithmName());
        }
    }

    private void testWriteRead(Object object, CipherParameters cipherParameters, boolean bl) throws Exception {
        byte[] byArray = new byte[this.streamSize];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(n % 255);
            ++n;
        }
        this.testWriteRead(object, cipherParameters, bl, byArray);
    }

    /*
     * Unable to fully structure code
     */
    private void testWriteRead(Object var1_1, CipherParameters var2_2, boolean var3_3, byte[] var4_4) {
        var5_5 = new ByteArrayOutputStream();
        try {
            block9: {
                this.init(var1_1, true, var2_2);
                var6_6 = this.createCipherOutputStream(var5_5, var1_1);
                if (var3_3) {
                    var7_8 = Math.max(1, var4_4.length / 8);
                    var8_10 = 0;
                    while (var8_10 < var4_4.length) {
                        var6_6.write(var4_4, var8_10, Math.min(var7_8, var4_4.length - var8_10));
                        var8_10 += var7_8;
                    }
                } else {
                    var7_8 = 0;
                    while (var7_8 < var4_4.length) {
                        var6_6.write(var4_4[var7_8]);
                        ++var7_8;
                    }
                }
                var6_6.close();
                var7_9 = var5_5.toByteArray();
                var5_5.reset();
                this.init(var1_1, false, var2_2);
                var8_11 = this.createCipherInputStream(var7_9, var1_1);
                if (!var3_3) ** GOTO lbl30
                var9_12 = new byte[this.getBlockSize(var1_1) + 1];
                while ((var10_14 = var8_11.read(var9_12)) >= 0) {
                    var5_5.write(var9_12, 0, var10_14);
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    var5_5.write(var9_13);
lbl30:
                    // 2 sources

                    ** while ((var9_13 = var8_11.read()) >= 0)
                }
            }
            var8_11.close();
        }
        catch (Exception var6_7) {
            this.fail("Unexpected exception " + this.getName(var1_1), var6_7);
        }
        var6_6 = var5_5.toByteArray();
        if (!Arrays.areEqual(var4_4, (byte[])var6_6)) {
            this.fail("Failed - decrypted data doesn't match: " + this.getName(var1_1));
        }
    }

    private void testWriteReadEmpty(Object object, CipherParameters cipherParameters, boolean bl) throws Exception {
        byte[] byArray = new byte[]{};
        this.testWriteRead(object, cipherParameters, bl, byArray);
    }
}

