/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.agreement.DHStandardGroups;
import org.bouncycastle.crypto.engines.CramerShoupCiphertext;
import org.bouncycastle.crypto.engines.CramerShoupCoreEngine;
import org.bouncycastle.crypto.generators.CramerShoupKeyPairGenerator;
import org.bouncycastle.crypto.generators.CramerShoupParametersGenerator;
import org.bouncycastle.crypto.params.CramerShoupKeyGenerationParameters;
import org.bouncycastle.crypto.params.CramerShoupParameters;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.test.SimpleTest;

public class CramerShoupTest
extends SimpleTest {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final SecureRandom RND = new SecureRandom();
    private AsymmetricCipherKeyPair keyPair;

    private BigInteger decrypt(CramerShoupCiphertext cramerShoupCiphertext) {
        return this.decrypt(cramerShoupCiphertext, null);
    }

    private BigInteger decrypt(CramerShoupCiphertext cramerShoupCiphertext, String string) {
        CramerShoupCoreEngine cramerShoupCoreEngine = new CramerShoupCoreEngine();
        if (string != null) {
            cramerShoupCoreEngine.init(false, this.keyPair.getPrivate(), string);
        } else {
            cramerShoupCoreEngine.init(false, this.keyPair.getPrivate());
        }
        try {
            BigInteger bigInteger = cramerShoupCoreEngine.decryptBlock(cramerShoupCiphertext);
            return bigInteger;
        }
        catch (CramerShoupCoreEngine.CramerShoupCiphertextException cramerShoupCiphertextException) {
            cramerShoupCiphertextException.printStackTrace();
            return null;
        }
    }

    private BigInteger encDecEncodingTest(BigInteger bigInteger) {
        CramerShoupCiphertext cramerShoupCiphertext = this.encrypt(bigInteger);
        byte[] byArray = cramerShoupCiphertext.toByteArray();
        CramerShoupCiphertext cramerShoupCiphertext2 = new CramerShoupCiphertext(byArray);
        return this.decrypt(cramerShoupCiphertext2);
    }

    private BigInteger encDecTest(BigInteger bigInteger) {
        CramerShoupCiphertext cramerShoupCiphertext = this.encrypt(bigInteger);
        return this.decrypt(cramerShoupCiphertext);
    }

    private CramerShoupCiphertext encrypt(BigInteger bigInteger) {
        return this.encrypt(bigInteger, null);
    }

    private CramerShoupCiphertext encrypt(BigInteger bigInteger, String string) {
        CramerShoupKeyPairGenerator cramerShoupKeyPairGenerator = new CramerShoupKeyPairGenerator();
        CramerShoupParametersGenerator cramerShoupParametersGenerator = new CramerShoupParametersGenerator();
        cramerShoupParametersGenerator.init(2048, 1, RND);
        CramerShoupParameters cramerShoupParameters = cramerShoupParametersGenerator.generateParameters(DHStandardGroups.rfc3526_2048);
        CramerShoupKeyGenerationParameters cramerShoupKeyGenerationParameters = new CramerShoupKeyGenerationParameters(RND, cramerShoupParameters);
        cramerShoupKeyPairGenerator.init(cramerShoupKeyGenerationParameters);
        this.keyPair = cramerShoupKeyPairGenerator.generateKeyPair();
        CramerShoupCoreEngine cramerShoupCoreEngine = new CramerShoupCoreEngine();
        if (string != null) {
            cramerShoupCoreEngine.init(true, this.keyPair.getPublic(), string);
        } else {
            cramerShoupCoreEngine.init(true, this.keyPair.getPublic());
        }
        CramerShoupCiphertext cramerShoupCiphertext = cramerShoupCoreEngine.encryptBlock(bigInteger);
        return cramerShoupCiphertext;
    }

    public String getName() {
        return "CramerShoup";
    }

    private BigInteger labelledEncDecEncodingTest(BigInteger bigInteger, String string) {
        byte[] byArray = this.encrypt(bigInteger, string).toByteArray();
        return this.decrypt(new CramerShoupCiphertext(byArray), string);
    }

    private BigInteger labelledEncDecTest(BigInteger bigInteger, String string) {
        CramerShoupCiphertext cramerShoupCiphertext = this.encrypt(bigInteger, string);
        return this.decrypt(cramerShoupCiphertext, string);
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new CramerShoupTest());
    }

    public void performTest() throws Exception {
        BigInteger bigInteger = DHStandardGroups.rfc3526_2048.getP().subtract(ONE);
        int n = 0;
        while (n < 10) {
            BigInteger bigInteger2 = BigIntegers.createRandomInRange(ONE, bigInteger, RND);
            BigInteger bigInteger3 = this.encDecTest(bigInteger2);
            BigInteger bigInteger4 = this.labelledEncDecTest(bigInteger2, "myRandomLabel");
            BigInteger bigInteger5 = this.encDecEncodingTest(bigInteger2);
            BigInteger bigInteger6 = this.labelledEncDecEncodingTest(bigInteger2, "myOtherCoolLabel");
            if (!(bigInteger2.equals(bigInteger3) && bigInteger2.equals(bigInteger4) && bigInteger2.equals(bigInteger5) && bigInteger2.equals(bigInteger6))) {
                this.fail("decrypted message != original message");
            }
            ++n;
        }
    }
}

