/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.EncodableDigest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public abstract class DigestTest
extends SimpleTest {
    private Digest digest;
    private String[] input;
    private String[] results;

    DigestTest(Digest digest, String[] stringArray, String[] stringArray2) {
        this.digest = digest;
        this.input = stringArray;
        this.results = stringArray2;
    }

    protected abstract Digest cloneDigest(Digest var1);

    protected Digest cloneDigest(byte[] byArray) {
        throw new IllegalStateException("Unsupported");
    }

    public String getName() {
        return this.digest.getAlgorithmName();
    }

    protected void millionATest(String string) {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        int n = 0;
        while (n < 1000000) {
            this.digest.update((byte)97);
            ++n;
        }
        this.digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray, Hex.decode(string))) {
            this.fail("Million a's failed", string, new String(Hex.encode(byArray)));
        }
    }

    private void offsetTest(Digest digest, int n, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray2.length + 11];
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray3, 11);
        if (!this.areEqual(Arrays.copyOfRange(byArray3, 11, byArray3.length), byArray2)) {
            this.fail("Offset " + n + " failed got " + new String(Hex.encode(byArray3)));
        }
    }

    public void performTest() {
        byte[] byArray;
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        int n = 0;
        while (n < this.input.length - 1) {
            byArray = this.toByteArray(this.input[n]);
            this.vectorTest(this.digest, n, byArray2, byArray, Hex.decode(this.results[n]));
            ++n;
        }
        this.offsetTest(this.digest, 0, this.toByteArray(this.input[0]), Hex.decode(this.results[0]));
        byArray = this.toByteArray(this.input[this.input.length - 1]);
        byte[] byArray3 = Hex.decode(this.results[this.input.length - 1]);
        this.vectorTest(this.digest, this.input.length - 1, byArray2, byArray, Hex.decode(this.results[this.input.length - 1]));
        this.testClone(byArray2, byArray, byArray3);
        this.testMemo(byArray2, byArray, byArray3);
        if (this.digest instanceof EncodableDigest) {
            this.testEncodedState(byArray2, byArray, byArray3);
        }
    }

    protected void sixtyFourKTest(String string) {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        int n = 0;
        while (n < 65536) {
            this.digest.update((byte)(n & 0xFF));
            ++n;
        }
        this.digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray, Hex.decode(string))) {
            this.fail("64k test failed", string, new String(Hex.encode(byArray)));
        }
    }

    private void testClone(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.digest.update(byArray2, 0, byArray2.length / 2);
        Digest digest = this.cloneDigest(this.digest);
        this.digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        this.digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("failing clone vector test", this.results[this.results.length - 1], new String(Hex.encode(byArray)));
        }
        digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("failing second clone vector test", this.results[this.results.length - 1], new String(Hex.encode(byArray)));
        }
    }

    private void testEncodedState(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.digest.update(byArray2, 0, byArray2.length / 2);
        Digest digest = this.cloneDigest(((EncodableDigest)((Object)this.digest)).getEncodedState());
        Digest digest2 = this.cloneDigest(((EncodableDigest)((Object)digest)).getEncodedState());
        this.digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        this.digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("failing state vector test", byArray3, new String(Hex.encode(byArray)));
        }
        digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("failing state copy1 vector test", byArray3, new String(Hex.encode(byArray)));
        }
        digest2.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        digest2.doFinal(byArray, 0);
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("failing state copy2 vector test", byArray3, new String(Hex.encode(byArray)));
        }
    }

    private void testMemo(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Memoable memoable = (Memoable)((Object)this.digest);
        this.digest.update(byArray2, 0, byArray2.length / 2);
        Memoable memoable2 = memoable.copy();
        Memoable memoable3 = memoable2.copy();
        this.digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        this.digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("failing memo vector test", this.results[this.results.length - 1], new String(Hex.encode(byArray)));
        }
        memoable.reset(memoable2);
        this.digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        this.digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("failing memo reset vector test", this.results[this.results.length - 1], new String(Hex.encode(byArray)));
        }
        Digest digest = (Digest)((Object)memoable3);
        digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("failing memo copy vector test", this.results[this.results.length - 1], new String(Hex.encode(byArray)));
        }
    }

    protected byte[] toByteArray(String string) {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        while (n != byArray.length) {
            byArray[n] = (byte)string.charAt(n);
            ++n;
        }
        return byArray;
    }

    private void vectorTest(Digest digest, int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        digest.update(byArray2, 0, byArray2.length);
        digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray, byArray3)) {
            this.fail("Vector " + n + " failed got " + new String(Hex.encode(byArray)));
        }
    }
}

