/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.Haraka256Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Haraka256DigestTest
extends SimpleTest {
    private boolean contains(String string, String string2) {
        return string.indexOf(string2) >= 0;
    }

    public String getName() {
        return "Haraka 256";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new Haraka256DigestTest());
    }

    public void performTest() throws Exception {
        this.testKnownVector();
        this.testInputTooLong();
        this.testInputTooShort();
        this.testOutput();
        this.testMonty();
    }

    public void testInputTooLong() {
        try {
            Haraka256Digest haraka256Digest = new Haraka256Digest();
            byte[] byArray = new byte[33];
            haraka256Digest.update(byArray, 0, byArray.length);
            haraka256Digest.doFinal(null, 0);
            this.fail("fail on input not 32 bytes.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("long message", this.contains(illegalArgumentException.getMessage(), "total input cannot be more than 32 bytes"));
        }
    }

    public void testInputTooShort() {
        try {
            Haraka256Digest haraka256Digest = new Haraka256Digest();
            byte[] byArray = new byte[31];
            haraka256Digest.update(byArray, 0, byArray.length);
            haraka256Digest.doFinal(null, 0);
            this.fail("fail on input not 32 bytes.");
        }
        catch (IllegalStateException illegalStateException) {
            this.isTrue("message", this.contains(illegalStateException.getMessage(), "input must be exactly 32 bytes"));
        }
    }

    public void testKnownVector() {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)n;
            ++n;
        }
        byte[] byArray2 = Hex.decode("8027ccb87949774b78d0545fb72bf70c695c2a0923cbd47bba1159efbf2b2c1c");
        Haraka256Digest haraka256Digest = new Haraka256Digest();
        haraka256Digest.update(byArray, 0, byArray.length);
        byte[] byArray3 = new byte[haraka256Digest.getDigestSize()];
        haraka256Digest.doFinal(byArray3, 0);
        this.isTrue("Did not match vector", this.areEqual(byArray2, byArray3));
    }

    void testMonty() {
        int n = 0;
        String[][] stringArrayArray = new String[][]{{"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F", "e78599d7163ab58f1c90f0171c6fc4e852eb4b8cc29a4af63194fd9977c1de84"}, {"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "c4cebda63c00c4cd312f36ea92afd4b0f6048507c5b367326ef9d8fdd2d5c09a"}};
        int n2 = 0;
        while (n2 != stringArrayArray.length) {
            String[] stringArray = stringArrayArray[n2];
            byte[] byArray = Hex.decode(stringArray[1]);
            Haraka256Digest haraka256Digest = new Haraka256Digest();
            byte[] byArray2 = Hex.decode(stringArray[0]);
            int n3 = 0;
            while (n3 < 1000) {
                haraka256Digest.update(byArray2, 0, byArray2.length);
                haraka256Digest.doFinal(byArray2, 0);
                ++n3;
            }
            this.isTrue("Monte Carlo test: " + n, this.areEqual(byArray, byArray2));
            byArray2[0] = (byte)(byArray2[0] ^ 1);
            this.isTrue("Monte Carlo test: " + n, this.areEqual(byArray, byArray2) ^ true);
            ++n;
            ++n2;
        }
    }

    public void testOutput() {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        try {
            object = new Haraka256Digest();
            byArray2 = new byte[32];
            ((Haraka256Digest)object).update(byArray2, 0, byArray2.length);
            byArray = new byte[31];
            ((Haraka256Digest)object).doFinal(byArray, 0);
            this.fail("Output too short for digest result.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("message 1", this.contains(illegalArgumentException.getMessage(), "output too short to receive digest"));
        }
        try {
            object = new Haraka256Digest();
            byArray2 = new byte[32];
            ((Haraka256Digest)object).update(byArray2, 0, byArray2.length);
            byArray = new byte[48];
            ((Haraka256Digest)object).doFinal(byArray, 17);
            this.fail("Output too short for digest result.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("message 2", this.contains(illegalArgumentException.getMessage(), "output too short to receive digest"));
        }
        object = new byte[32];
        int n = 0;
        while (n < ((Object)object).length) {
            object[n] = (byte)n;
            ++n;
        }
        byArray = Hex.decode("000000008027ccb87949774b78d0545fb72bf70c695c2a0923cbd47bba1159efbf2b2c1c");
        Haraka256Digest haraka256Digest = new Haraka256Digest();
        haraka256Digest.update((byte[])object, 0, ((Object)object).length);
        byte[] byArray3 = new byte[haraka256Digest.getDigestSize() + 4];
        haraka256Digest.doFinal(byArray3, 4);
        this.isTrue(this.areEqual(byArray, byArray3));
    }
}

