/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.Haraka512Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Haraka512DigestTest
extends SimpleTest {
    private boolean contains(String string, String string2) {
        return string.indexOf(string2) >= 0;
    }

    public String getName() {
        return "Haraka 512";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new Haraka512DigestTest());
    }

    public void performTest() throws Exception {
        this.testKnownVector();
        this.testInputTooLong();
        this.testInputTooShort();
        this.testOutput();
        this.testMonty();
    }

    public void testInputTooLong() {
        try {
            Haraka512Digest haraka512Digest = new Haraka512Digest();
            byte[] byArray = new byte[65];
            haraka512Digest.update(byArray, 0, byArray.length);
            haraka512Digest.doFinal(null, 0);
            this.fail("fail on input not 64 bytes.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("message", this.contains(illegalArgumentException.getMessage(), "total input cannot be more than 64 bytes"));
        }
    }

    public void testInputTooShort() {
        try {
            Haraka512Digest haraka512Digest = new Haraka512Digest();
            byte[] byArray = new byte[63];
            haraka512Digest.update(byArray, 0, byArray.length);
            haraka512Digest.doFinal(null, 0);
            this.fail("fail on input not 64 bytes.");
        }
        catch (IllegalStateException illegalStateException) {
            this.isTrue("message", this.contains(illegalStateException.getMessage(), "input must be exactly 64 bytes"));
        }
    }

    public void testKnownVector() {
        byte[] byArray = new byte[64];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)n;
            ++n;
        }
        byte[] byArray2 = Hex.decode("be7f723b4e80a99813b292287f306f625a6d57331cae5f34dd9277b0945be2aa");
        Haraka512Digest haraka512Digest = new Haraka512Digest();
        haraka512Digest.update(byArray, 0, byArray.length);
        byte[] byArray3 = new byte[haraka512Digest.getDigestSize()];
        haraka512Digest.doFinal(byArray3, 0);
        this.isTrue("Did not match vector", this.areEqual(byArray2, byArray3));
    }

    void testMonty() {
        int n = 0;
        String[][] stringArrayArray = new String[][]{{"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F", "ABE210FE673F3B28E70E5100C476D82F61A7E2BDB3D8423FB0A15E5DE3D3A4DE"}, {"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "5F5ECB52C61F5036C96BE555D2E18C520AB3ED093954700C283A322D14DBFE02"}};
        int n2 = 0;
        while (n2 != stringArrayArray.length) {
            String[] stringArray = stringArrayArray[n2];
            byte[] byArray = Hex.decode(stringArray[1]);
            byte[] byArray2 = Hex.decode(stringArray[0]);
            Haraka512Digest haraka512Digest = new Haraka512Digest();
            byte[] byArray3 = new byte[haraka512Digest.getDigestSize()];
            int n3 = 0;
            while (n3 < 1000) {
                haraka512Digest.update(byArray2, 0, byArray2.length);
                haraka512Digest.doFinal(byArray3, 0);
                if ((n3 & 1) == 1) {
                    System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                } else {
                    System.arraycopy(byArray3, 0, byArray2, byArray3.length, byArray3.length);
                }
                ++n3;
            }
            this.isTrue("Monte Carlo test: " + n, this.areEqual(byArray, byArray3));
            byArray3[0] = (byte)(byArray3[0] ^ 1);
            this.isTrue("Monte Carlo test: " + n, this.areEqual(byArray, byArray3) ^ true);
            ++n;
            ++n2;
        }
    }

    public void testOutput() {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        try {
            object = new Haraka512Digest();
            byArray2 = new byte[64];
            ((Haraka512Digest)object).update(byArray2, 0, byArray2.length);
            byArray = new byte[31];
            ((Haraka512Digest)object).doFinal(byArray, 0);
            this.fail("Output too short for digest result.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("message", this.contains(illegalArgumentException.getMessage(), "output too short to receive digest"));
        }
        try {
            object = new Haraka512Digest();
            byArray2 = new byte[64];
            ((Haraka512Digest)object).update(byArray2, 0, byArray2.length);
            byArray = new byte[48];
            ((Haraka512Digest)object).doFinal(byArray, 17);
            this.fail("Output too short for digest result.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("message", this.contains(illegalArgumentException.getMessage(), "output too short to receive digest"));
        }
        object = new byte[64];
        int n = 0;
        while (n < ((Object)object).length) {
            object[n] = (byte)n;
            ++n;
        }
        byArray = Hex.decode("00000000be7f723b4e80a99813b292287f306f625a6d57331cae5f34dd9277b0945be2aa");
        Haraka512Digest haraka512Digest = new Haraka512Digest();
        haraka512Digest.update((byte[])object, 0, ((Object)object).length);
        byte[] byArray3 = new byte[haraka512Digest.getDigestSize() + 4];
        haraka512Digest.doFinal(byArray3, 4);
        this.isTrue(this.areEqual(byArray, byArray3));
    }
}

