/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.macs.ISO9797Alg3Mac;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ISO9797Alg3MacTest
extends SimpleTest {
    static byte[] keyBytes = Hex.decode("7CA110454A1A6E570131D9619DC1376E");
    static byte[] input1 = "Hello World !!!!".getBytes();
    static byte[] output1 = Hex.decode("F09B856213BAB83B");

    public String getName() {
        return "ISO9797Alg3Mac";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ISO9797Alg3MacTest());
    }

    public void performTest() {
        KeyParameter keyParameter = new KeyParameter(keyBytes);
        DESEngine dESEngine = new DESEngine();
        ISO9797Alg3Mac iSO9797Alg3Mac = new ISO9797Alg3Mac(dESEngine);
        iSO9797Alg3Mac.init(keyParameter);
        iSO9797Alg3Mac.update(input1, 0, input1.length);
        byte[] byArray = new byte[8];
        iSO9797Alg3Mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output1)) {
            this.fail("Failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(byArray)));
        }
        iSO9797Alg3Mac.reset();
        iSO9797Alg3Mac.init(keyParameter);
        int n = 0;
        while (n != input1.length / 2) {
            iSO9797Alg3Mac.update(input1[n]);
            ++n;
        }
        iSO9797Alg3Mac.update(input1, input1.length / 2, input1.length - input1.length / 2);
        iSO9797Alg3Mac.doFinal(byArray, 0);
        if (!this.areEqual(byArray, output1)) {
            this.fail("Reset failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(byArray)));
        }
        this.testMacWithIv();
    }

    private void testMacWithIv() {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[]{5, 6, 7, 8, 1, 2, 3, 4};
        KeyParameter keyParameter = new KeyParameter(byArray2);
        ParametersWithIV parametersWithIV = new ParametersWithIV(new KeyParameter(byArray2), byArray3);
        ISO9797Alg3Mac iSO9797Alg3Mac = new ISO9797Alg3Mac((BlockCipher)new DESEngine(), new ISO7816d4Padding());
        iSO9797Alg3Mac.init(keyParameter);
        iSO9797Alg3Mac.update(byArray, 0, byArray.length);
        byte[] byArray5 = new byte[iSO9797Alg3Mac.getMacSize()];
        iSO9797Alg3Mac.doFinal(byArray5, 0);
        ISO9797Alg3Mac iSO9797Alg3Mac2 = new ISO9797Alg3Mac((BlockCipher)new DESEngine(), new ISO7816d4Padding());
        iSO9797Alg3Mac2.init(parametersWithIV);
        iSO9797Alg3Mac2.update(byArray, 0, byArray.length);
        byte[] byArray6 = new byte[iSO9797Alg3Mac2.getMacSize()];
        iSO9797Alg3Mac2.doFinal(byArray6, 0);
        if (!Arrays.areEqual(byArray5, byArray6)) {
            this.fail("zero IV test failed");
        }
        ParametersWithIV parametersWithIV2 = new ParametersWithIV(new KeyParameter(byArray2), byArray4);
        iSO9797Alg3Mac2 = new ISO9797Alg3Mac((BlockCipher)new DESEngine(), new ISO7816d4Padding());
        iSO9797Alg3Mac2.init(parametersWithIV2);
        iSO9797Alg3Mac2.update(byArray, 0, byArray.length);
        byArray6 = new byte[iSO9797Alg3Mac2.getMacSize()];
        iSO9797Alg3Mac2.doFinal(byArray6, 0);
        if (Arrays.areEqual(byArray5, byArray6)) {
            this.fail("non-zero IV test failed");
        }
    }
}

