/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.util.JournalingSecureRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.test.SimpleTest;

public class JournalingSecureRandomTest
extends SimpleTest {
    public String getName() {
        return "JournalingSecureRandom";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new JournalingSecureRandomTest());
    }

    public void performTest() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        JournalingSecureRandom journalingSecureRandom = new JournalingSecureRandom(secureRandom);
        byte[] byArray = new byte[1024];
        journalingSecureRandom.nextBytes(byArray);
        byte[] byArray2 = journalingSecureRandom.getTranscript();
        byte[] byArray3 = new byte[512];
        JournalingSecureRandom journalingSecureRandom2 = new JournalingSecureRandom(byArray2, secureRandom);
        journalingSecureRandom2.nextBytes(byArray3);
        this.areEqual(Arrays.copyOfRange(byArray, 0, 512), byArray3);
        journalingSecureRandom2.nextBytes(byArray3);
        this.areEqual(Arrays.copyOfRange(byArray, 512, 1024), byArray3);
        journalingSecureRandom2.nextBytes(byArray3);
        this.isTrue(Arrays.areEqual(Arrays.copyOfRange(byArray, 0, 512), byArray3) ^ true);
    }
}

