/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RC2WrapEngine;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RC2Parameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class RC2WrapTest
implements Test {
    public String getName() {
        return "RC2Wrap";
    }

    public static void main(String[] stringArray) {
        RC2WrapTest rC2WrapTest = new RC2WrapTest();
        TestResult testResult = rC2WrapTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        byte[] byArray;
        byte[] byArray2;
        RC2Parameters rC2Parameters;
        byte[] byArray3;
        byte[] byArray4 = Hex.decode("fd04fd08060707fb0003fefffd02fe05");
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(new ParametersWithIV(new RC2Parameters(byArray4, 40), byArray3 = Hex.decode("c7d90059b29e97f7")), new RFCRandom());
        TestResult testResult = this.wrapTest(1, parametersWithRandom, rC2Parameters = new RC2Parameters(byArray4, 40), byArray2 = Hex.decode("b70a25fbc9d86a86050ce0d711ead4d9"), byArray = Hex.decode("70e699fb5701f7833330fb71e87c85a420bdc99af05d22af5a0e48d35f3138986cbaafb4b28d4f35"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    private TestResult wrapTest(int n, CipherParameters cipherParameters, CipherParameters cipherParameters2, byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        RC2WrapEngine rC2WrapEngine = new RC2WrapEngine();
        rC2WrapEngine.init(true, cipherParameters);
        try {
            byArray3 = rC2WrapEngine.wrap(byArray, 0, byArray.length);
            if (!Arrays.areEqual(byArray3, byArray2)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed wrap test " + n + " expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray3)));
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed wrap test exception " + exception.toString(), exception);
        }
        rC2WrapEngine.init(false, cipherParameters2);
        try {
            byArray3 = rC2WrapEngine.unwrap(byArray2, 0, byArray2.length);
            if (!Arrays.areEqual(byArray3, byArray)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed unwrap test " + n + " expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray3)));
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed unwrap test exception " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    private class RFCRandom
    extends SecureRandom {
        RFCRandom() {
        }

        public void nextBytes(byte[] byArray) {
            System.arraycopy(Hex.decode("4845cce7fd1250"), 0, byArray, 0, byArray.length);
        }
    }
}

