/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.kems.RSAKeyEncapsulation;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.util.test.SimpleTest;

public class RSAKeyEncapsulationTest
extends SimpleTest {
    public String getName() {
        return "RSAKeyEncapsulation";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new RSAKeyEncapsulationTest());
    }

    public void performTest() throws Exception {
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        rSAKeyPairGenerator.init(new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), 1024, 5));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = rSAKeyPairGenerator.generateKeyPair();
        KDF2BytesGenerator kDF2BytesGenerator = new KDF2BytesGenerator(new SHA1Digest());
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[128];
        RSAKeyEncapsulation rSAKeyEncapsulation = new RSAKeyEncapsulation(kDF2BytesGenerator, secureRandom);
        rSAKeyEncapsulation.init(asymmetricCipherKeyPair.getPublic());
        KeyParameter keyParameter = (KeyParameter)rSAKeyEncapsulation.encrypt(byArray, 128);
        rSAKeyEncapsulation.init(asymmetricCipherKeyPair.getPrivate());
        KeyParameter keyParameter2 = (KeyParameter)rSAKeyEncapsulation.decrypt(byArray, 128);
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed test");
        }
    }
}

