/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class RSATest
extends SimpleTest {
    static BigInteger mod = new BigInteger("b259d2d6e627a768c94be36164c2d9fc79d97aab9253140e5bf17751197731d6f7540d2509e7b9ffee0a70a6e26d56e92d2edd7f85aba85600b69089f35f6bdbf3c298e05842535d9f064e6b0391cb7d306e0a2d20c4dfb4e7b49a9640bdea26c10ad69c3f05007ce2513cee44cfe01998e62b6c3637d3fc0391079b26ee36d5", 16);
    static BigInteger pubExp = new BigInteger("11", 16);
    static BigInteger privExp = new BigInteger("92e08f83cc9920746989ca5034dcb384a094fb9c5a6288fcc4304424ab8f56388f72652d8fafc65a4b9020896f2cde297080f2a540e7b7ce5af0b3446e1258d1dd7f245cf54124b4c6e17da21b90a0ebd22605e6f45c9f136d7a13eaac1c0f7487de8bd6d924972408ebb58af71e76fd7b012a8d0e165f3ae2e5077a8648e619", 16);
    static BigInteger p = new BigInteger("f75e80839b9b9379f1cf1128f321639757dba514642c206bbbd99f9a4846208b3e93fbbe5e0527cc59b1d4b929d9555853004c7c8b30ee6a213c3d1bb7415d03", 16);
    static BigInteger q = new BigInteger("b892d9ebdbfc37e397256dd8a5d3123534d1f03726284743ddc6be3a709edb696fc40c7d902ed804c6eee730eee3d5b20bf6bd8d87a296813c87d3b3cc9d7947", 16);
    static BigInteger pExp = new BigInteger("1d1a2d3ca8e52068b3094d501c9a842fec37f54db16e9a67070a8b3f53cc03d4257ad252a1a640eadd603724d7bf3737914b544ae332eedf4f34436cac25ceb5", 16);
    static BigInteger qExp = new BigInteger("6c929e4e81672fef49d9c825163fec97c4b7ba7acb26c0824638ac22605d7201c94625770984f78a56e6e25904fe7db407099cad9b14588841b94f5ab498dded", 16);
    static BigInteger crtCoef = new BigInteger("dae7651ee69ad1d081ec5e7188ae126f6004ff39556bde90e0b870962fa7b926d070686d8244fe5a9aa709a95686a104614834b0ada4b10f53197a5cb4c97339", 16);
    static String input = "4e6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e";
    static String edgeInput = "ff6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e";
    static byte[] oversizedSig = Hex.decode("01ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff004e6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e");
    static byte[] dudBlock = Hex.decode("000fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff004e6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e");
    static byte[] truncatedDataBlock = Hex.decode("0001ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff004e6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e");
    static byte[] incorrectPadding = Hex.decode("0001ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff4e6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e");
    static byte[] missingDataBlock = Hex.decode("0001ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");

    private void checkForPKCS1Exception(RSAKeyParameters rSAKeyParameters, RSAKeyParameters rSAKeyParameters2, byte[] byArray, String string) {
        block4: {
            AsymmetricBlockCipher asymmetricBlockCipher = new RSAEngine();
            asymmetricBlockCipher.init(true, rSAKeyParameters2);
            byte[] byArray2 = null;
            try {
                byArray2 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                this.fail("RSA: failed - exception " + exception.toString(), exception);
            }
            asymmetricBlockCipher = new PKCS1Encoding(asymmetricBlockCipher);
            asymmetricBlockCipher.init(false, rSAKeyParameters);
            try {
                byArray2 = asymmetricBlockCipher.processBlock(byArray2, 0, byArray2.length);
                this.fail("incorrect block not recognised");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if (invalidCipherTextException.getMessage().equals(string)) break block4;
                this.fail("RSA: failed - exception " + invalidCipherTextException.toString(), invalidCipherTextException);
            }
        }
    }

    public String getName() {
        return "RSA";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new RSATest());
    }

    public void performTest() {
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, mod, pubExp);
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(mod, pubExp, privExp, p, q, pExp, qExp, crtCoef);
        byte[] byArray = Hex.decode(edgeInput);
        AsymmetricBlockCipher asymmetricBlockCipher = new RSAEngine();
        asymmetricBlockCipher.init(true, rSAKeyParameters);
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("RSA: failed - exception " + exception.toString(), exception);
        }
        asymmetricBlockCipher.init(false, rSAPrivateCrtKeyParameters);
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        if (!edgeInput.equals(new String(Hex.encode(byArray)))) {
            this.fail("failed RAW edge Test");
        }
        byArray = Hex.decode(input);
        asymmetricBlockCipher.init(true, rSAKeyParameters);
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        asymmetricBlockCipher.init(false, rSAPrivateCrtKeyParameters);
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        if (!input.equals(new String(Hex.encode(byArray)))) {
            this.fail("failed RAW Test");
        }
        asymmetricBlockCipher = new PKCS1Encoding(asymmetricBlockCipher);
        asymmetricBlockCipher.init(true, rSAKeyParameters);
        if (asymmetricBlockCipher.getOutputBlockSize() != ((PKCS1Encoding)asymmetricBlockCipher).getUnderlyingCipher().getOutputBlockSize()) {
            this.fail("PKCS1 output block size incorrect");
        }
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        asymmetricBlockCipher.init(false, rSAPrivateCrtKeyParameters);
        byte[] byArray2 = null;
        try {
            byArray2 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        if (!input.equals(Hex.toHexString(byArray2))) {
            this.fail("failed PKCS1 public/private Test");
        }
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine(), input.length() / 2);
        pKCS1Encoding.init(false, new ParametersWithRandom(rSAPrivateCrtKeyParameters, new SecureRandom()));
        try {
            byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        if (!input.equals(Hex.toHexString(byArray2))) {
            this.fail("failed PKCS1 public/private fixed Test");
        }
        pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine(), input.length());
        pKCS1Encoding.init(false, new ParametersWithRandom(rSAPrivateCrtKeyParameters, new SecureRandom()));
        try {
            byArray = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        if (input.equals(Hex.toHexString(byArray))) {
            this.fail("failed to recognise incorrect plaint text length");
        }
        byArray = byArray2;
        asymmetricBlockCipher = new PKCS1Encoding(((PKCS1Encoding)asymmetricBlockCipher).getUnderlyingCipher());
        asymmetricBlockCipher.init(true, rSAPrivateCrtKeyParameters);
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        asymmetricBlockCipher.init(false, rSAKeyParameters);
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        if (!input.equals(Hex.toHexString(byArray))) {
            this.fail("failed PKCS1 private/public Test");
        }
        this.zeroBlockTest(rSAKeyParameters, rSAPrivateCrtKeyParameters);
        this.zeroBlockTest(rSAPrivateCrtKeyParameters, rSAKeyParameters);
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        RSAKeyGenerationParameters rSAKeyGenerationParameters = new RSAKeyGenerationParameters(BigInteger.valueOf(17L), new SecureRandom(), 768, 25);
        rSAKeyPairGenerator.init(rSAKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = rSAKeyPairGenerator.generateKeyPair();
        asymmetricBlockCipher = new RSAEngine();
        if (((RSAKeyParameters)asymmetricCipherKeyPair.getPublic()).getModulus().bitLength() < 768) {
            this.fail("failed key generation (768) length test");
        }
        asymmetricBlockCipher.init(true, asymmetricCipherKeyPair.getPublic());
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        asymmetricBlockCipher.init(false, asymmetricCipherKeyPair.getPrivate());
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        if (!input.equals(new String(Hex.encode(byArray)))) {
            this.fail("failed key generation (768) Test");
        }
        rSAKeyGenerationParameters = new RSAKeyGenerationParameters(BigInteger.valueOf(17L), new SecureRandom(), 1024, 25);
        rSAKeyPairGenerator.init(rSAKeyGenerationParameters);
        asymmetricCipherKeyPair = rSAKeyPairGenerator.generateKeyPair();
        asymmetricBlockCipher.init(true, asymmetricCipherKeyPair.getPublic());
        if (((RSAKeyParameters)asymmetricCipherKeyPair.getPublic()).getModulus().bitLength() < 1024) {
            this.fail("failed key generation (1024) length test");
        }
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        asymmetricBlockCipher.init(false, asymmetricCipherKeyPair.getPrivate());
        try {
            byArray = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        if (!input.equals(new String(Hex.encode(byArray)))) {
            this.fail("failed key generation (1024) test");
        }
        rSAKeyGenerationParameters = new RSAKeyGenerationParameters(BigInteger.valueOf(17L), new SecureRandom(), 128, 25);
        rSAKeyPairGenerator.init(rSAKeyGenerationParameters);
        int n = 0;
        while (n < 100) {
            asymmetricCipherKeyPair = rSAKeyPairGenerator.generateKeyPair();
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters2 = (RSAPrivateCrtKeyParameters)asymmetricCipherKeyPair.getPrivate();
            BigInteger bigInteger = rSAPrivateCrtKeyParameters2.getP().subtract(rSAPrivateCrtKeyParameters2.getQ()).abs();
            if (bigInteger.bitLength() < 42) {
                this.fail("P and Q too close in RSA key pair");
            }
            ++n;
        }
        this.testOAEP(rSAKeyParameters, rSAPrivateCrtKeyParameters);
        this.testStrictPKCS1Length(rSAKeyParameters, rSAPrivateCrtKeyParameters);
        this.testDudPKCS1Block(rSAKeyParameters, rSAPrivateCrtKeyParameters);
        this.testMissingDataPKCS1Block(rSAKeyParameters, rSAPrivateCrtKeyParameters);
        this.testTruncatedPKCS1Block(rSAKeyParameters, rSAPrivateCrtKeyParameters);
        this.testWrongPaddingPKCS1Block(rSAKeyParameters, rSAPrivateCrtKeyParameters);
        this.test_CVE_2017_15361();
        this.testUnsafeModulusAndWrongExp();
        try {
            new RSAEngine().processBlock(new byte[]{1}, 0, 1);
            this.fail("failed initialisation check");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private void testDudPKCS1Block(RSAKeyParameters rSAKeyParameters, RSAKeyParameters rSAKeyParameters2) {
        this.checkForPKCS1Exception(rSAKeyParameters, rSAKeyParameters2, dudBlock, "block incorrect");
    }

    private void testMissingDataPKCS1Block(RSAKeyParameters rSAKeyParameters, RSAKeyParameters rSAKeyParameters2) {
        this.checkForPKCS1Exception(rSAKeyParameters, rSAKeyParameters2, missingDataBlock, "block incorrect");
    }

    private void testOAEP(RSAKeyParameters rSAKeyParameters, RSAKeyParameters rSAKeyParameters2) {
        OAEPEncoding oAEPEncoding = new OAEPEncoding(new RSAEngine());
        byte[] byArray = Hex.decode(input);
        oAEPEncoding.init(true, rSAKeyParameters);
        try {
            byArray = oAEPEncoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        oAEPEncoding.init(false, rSAKeyParameters2);
        try {
            byArray = oAEPEncoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        if (!input.equals(new String(Hex.encode(byArray)))) {
            this.fail("failed OAEP Test");
        }
        byte[] byArray2 = new byte[87];
        RSAEngine rSAEngine = new RSAEngine();
        OAEPEncoding oAEPEncoding2 = new OAEPEncoding(rSAEngine, new SHA1Digest(), new SHA1Digest(), byArray2);
        oAEPEncoding2.init(true, new ParametersWithRandom(rSAKeyParameters, new SecureRandom()));
        try {
            oAEPEncoding2.processBlock(byArray2, 0, byArray2.length);
            this.fail("no exception thrown");
        }
        catch (DataLengthException dataLengthException) {
            this.isTrue("message mismatch", "input data too long".equals(dataLengthException.getMessage()));
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            this.fail("failed - exception " + invalidCipherTextException.toString(), invalidCipherTextException);
        }
    }

    private void testStrictPKCS1Length(RSAKeyParameters rSAKeyParameters, RSAKeyParameters rSAKeyParameters2) {
        byte[] byArray;
        byte[] byArray2;
        AsymmetricBlockCipher asymmetricBlockCipher;
        block8: {
            asymmetricBlockCipher = new RSAEngine();
            asymmetricBlockCipher.init(true, rSAKeyParameters2);
            byArray2 = null;
            byArray = null;
            try {
                byArray = byArray2 = asymmetricBlockCipher.processBlock(oversizedSig, 0, oversizedSig.length);
            }
            catch (Exception exception) {
                this.fail("RSA: failed - exception " + exception.toString(), exception);
            }
            asymmetricBlockCipher = new PKCS1Encoding(asymmetricBlockCipher);
            asymmetricBlockCipher.init(false, rSAKeyParameters);
            try {
                byArray2 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
                this.fail("oversized signature block not recognised");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if (invalidCipherTextException.getMessage().equals("block incorrect size")) break block8;
                this.fail("RSA: failed - exception " + invalidCipherTextException.toString(), invalidCipherTextException);
            }
        }
        asymmetricBlockCipher = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine(), Hex.decode("feedbeeffeedbeeffeedbeef"));
        asymmetricBlockCipher.init(false, new ParametersWithRandom(rSAKeyParameters2, new SecureRandom()));
        try {
            byArray2 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
            this.isTrue("not fallback", Arrays.areEqual(Hex.decode("feedbeeffeedbeeffeedbeef"), byArray2));
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            this.fail("RSA: failed - exception " + invalidCipherTextException.toString(), invalidCipherTextException);
        }
        ((Hashtable)System.getProperties()).put("org.bouncycastle.pkcs1.not_strict", "true");
        asymmetricBlockCipher = new PKCS1Encoding(new RSAEngine());
        asymmetricBlockCipher.init(false, rSAKeyParameters);
        try {
            byArray2 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            this.fail("RSA: failed - exception " + invalidCipherTextException.toString(), invalidCipherTextException);
        }
        ((Hashtable)System.getProperties()).remove("org.bouncycastle.pkcs1.not_strict");
    }

    private void testTruncatedPKCS1Block(RSAKeyParameters rSAKeyParameters, RSAKeyParameters rSAKeyParameters2) {
        this.checkForPKCS1Exception(rSAKeyParameters, rSAKeyParameters2, truncatedDataBlock, "block incorrect");
    }

    private void testUnsafeModulusAndWrongExp() {
        try {
            try {
                new RSAKeyParameters(false, mod, pubExp.multiply(BigInteger.valueOf(2L)));
                this.fail("no exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.isTrue("RSA publicExponent is even".equals(illegalArgumentException.getMessage()));
            }
            try {
                new RSAKeyParameters(false, mod.multiply(BigInteger.valueOf(2L)), pubExp);
                this.fail("no exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.isTrue("RSA modulus is even".equals(illegalArgumentException.getMessage()));
            }
            try {
                new RSAKeyParameters(false, mod.multiply(BigInteger.valueOf(3L)), pubExp);
                this.fail("no exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.isTrue("RSA modulus has a small prime factor".equals(illegalArgumentException.getMessage()));
            }
            ((Hashtable)System.getProperties()).put("org.bouncycastle.rsa.allow_unsafe_mod", "true");
            new RSAKeyParameters(false, mod.multiply(BigInteger.valueOf(3L)), pubExp);
        }
        finally {
            Object var2_5 = null;
            ((Hashtable)System.getProperties()).remove("org.bouncycastle.rsa.allow_unsafe_mod");
        }
    }

    private void testWrongPaddingPKCS1Block(RSAKeyParameters rSAKeyParameters, RSAKeyParameters rSAKeyParameters2) {
        this.checkForPKCS1Exception(rSAKeyParameters, rSAKeyParameters2, incorrectPadding, "block incorrect");
    }

    private void test_CVE_2017_15361() {
        SecureRandom secureRandom = new SecureRandom();
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        BigInteger bigInteger = BigInteger.valueOf(17L);
        int n = 512;
        while (n <= 2048) {
            rSAKeyPairGenerator.init(new RSAKeyGenerationParameters(bigInteger, secureRandom, n, 100));
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)rSAKeyPairGenerator.generateKeyPair().getPublic();
            if (BrokenKey_CVE_2017_15361.isAffected(rSAKeyParameters)) {
                this.fail("failed CVE-2017-15361 vulnerability test for generated RSA key");
            }
            n += 32;
        }
    }

    private void zeroBlockTest(CipherParameters cipherParameters, CipherParameters cipherParameters2) {
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(new RSAEngine());
        pKCS1Encoding.init(true, cipherParameters);
        if (pKCS1Encoding.getOutputBlockSize() != pKCS1Encoding.getUnderlyingCipher().getOutputBlockSize()) {
            this.fail("PKCS1 output block size incorrect");
        }
        byte[] byArray = new byte[]{};
        byte[] byArray2 = null;
        try {
            byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        pKCS1Encoding.init(false, cipherParameters2);
        try {
            byArray2 = pKCS1Encoding.processBlock(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            this.fail("failed - exception " + exception.toString(), exception);
        }
        if (!Arrays.areEqual(byArray, byArray2)) {
            this.fail("failed PKCS1 zero Test");
        }
    }

    static class BrokenKey_CVE_2017_15361 {
        private static final int[] prims = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167};
        private static final BigInteger[] primes = new BigInteger[prims.length];
        private static final BigInteger[] markers;

        static {
            int n = 0;
            while (n < prims.length) {
                BrokenKey_CVE_2017_15361.primes[n] = BigInteger.valueOf(prims[n]);
                ++n;
            }
            markers = new BigInteger[]{new BigInteger("6"), new BigInteger("30"), new BigInteger("126"), new BigInteger("1026"), new BigInteger("5658"), new BigInteger("107286"), new BigInteger("199410"), new BigInteger("8388606"), new BigInteger("536870910"), new BigInteger("2147483646"), new BigInteger("67109890"), new BigInteger("2199023255550"), new BigInteger("8796093022206"), new BigInteger("140737488355326"), new BigInteger("5310023542746834"), new BigInteger("576460752303423486"), new BigInteger("1455791217086302986"), new BigInteger("147573952589676412926"), new BigInteger("20052041432995567486"), new BigInteger("6041388139249378920330"), new BigInteger("207530445072488465666"), new BigInteger("9671406556917033397649406"), new BigInteger("618970019642690137449562110"), new BigInteger("79228162521181866724264247298"), new BigInteger("2535301200456458802993406410750"), new BigInteger("1760368345969468176824550810518"), new BigInteger("50079290986288516948354744811034"), new BigInteger("473022961816146413042658758988474"), new BigInteger("10384593717069655257060992658440190"), new BigInteger("144390480366845522447407333004847678774"), new BigInteger("2722258935367507707706996859454145691646"), new BigInteger("174224571863520493293247799005065324265470"), new BigInteger("696898287454081973172991196020261297061886"), new BigInteger("713623846352979940529142984724747568191373310"), new BigInteger("1800793591454480341970779146165214289059119882"), new BigInteger("126304807362733370595828809000324029340048915994"), new BigInteger("11692013098647223345629478661730264157247460343806"), new BigInteger("187072209578355573530071658587684226515959365500926")};
        }

        BrokenKey_CVE_2017_15361() {
        }

        public static boolean isAffected(RSAKeyParameters rSAKeyParameters) {
            BigInteger bigInteger = rSAKeyParameters.getModulus();
            int n = 0;
            while (n < primes.length) {
                int n2 = bigInteger.remainder(primes[n]).intValue();
                if (!markers[n].testBit(n2)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

