/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SHA3DigestTest
extends SimpleTest {
    SHA3DigestTest() {
    }

    private MySHA3Digest createDigest(String string) throws Exception {
        if (string.startsWith("SHA3-")) {
            int n = this.parseDecimal(string.substring("SHA3-".length()));
            return new MySHA3Digest(n);
        }
        throw new IllegalArgumentException("Unknown algorithm: " + string);
    }

    private byte[] decodeBinary(String string) {
        String string2;
        int n = string.length();
        int n2 = n / 8;
        int n3 = (n + 7) / 8;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n2) {
            string2 = this.reverse(string.substring(n4 * 8, (n4 + 1) * 8));
            byArray[n4] = (byte)this.parseBinary(string2);
            ++n4;
        }
        if (n3 > n2) {
            string2 = this.reverse(string.substring(n2 * 8));
            byArray[n2] = (byte)this.parseBinary(string2);
        }
        return byArray;
    }

    public String getName() {
        return "SHA-3";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new SHA3DigestTest());
    }

    private int parseBinary(String string) {
        return Integer.parseInt(string, 2);
    }

    private int parseDecimal(String string) {
        return Integer.parseInt(string);
    }

    public void performTest() throws Exception {
        this.testVectors();
    }

    private String readBlock(BufferedReader bufferedReader) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readBlockLine(bufferedReader)) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String readBlockLine(BufferedReader bufferedReader) throws IOException {
        String string = this.readLine(bufferedReader);
        if (string == null || string.length() == 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 != cArray.length) {
            if (cArray[n2] != ' ') {
                cArray[n++] = cArray[n2];
            }
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        return string == null ? null : this.stripFromChar(string, '#').trim();
    }

    private TestVector readTestVector(BufferedReader bufferedReader, String string) throws IOException {
        String[] stringArray = this.splitAround(string, TestVector.SAMPLE_OF);
        String string2 = stringArray[0];
        int n = this.parseDecimal(this.stripFromChar(stringArray[1], '-'));
        this.skipUntil(bufferedReader, TestVector.MSG_HEADER);
        String string3 = this.readBlock(bufferedReader);
        if (string3.length() != n) {
            throw new IllegalStateException("Test vector length mismatch");
        }
        byte[] byArray = this.decodeBinary(string3);
        this.skipUntil(bufferedReader, TestVector.HASH_HEADER);
        byte[] byArray2 = Hex.decode(this.readBlock(bufferedReader));
        class Org_bouncycastle_crypto_test_SHA3DigestTest$1 {
            /* synthetic */ Org_bouncycastle_crypto_test_SHA3DigestTest$1() {
            }
        }
        return new TestVector(null, string2, n, byArray, byArray2);
    }

    private String requireLine(BufferedReader bufferedReader) throws IOException {
        String string = this.readLine(bufferedReader);
        if (string == null) {
            throw new EOFException();
        }
        return string;
    }

    private String reverse(String string) {
        return new StringBuffer(string).reverse().toString();
    }

    private void runTestVector(TestVector testVector) throws Exception {
        int n = testVector.getBits();
        int n2 = n % 8;
        MySHA3Digest mySHA3Digest = this.createDigest(testVector.getAlgorithm());
        byte[] byArray = new byte[mySHA3Digest.getDigestSize()];
        byte[] byArray2 = testVector.getMessage();
        if (n2 == 0) {
            mySHA3Digest.update(byArray2, 0, byArray2.length);
            mySHA3Digest.doFinal(byArray, 0);
        } else {
            mySHA3Digest.update(byArray2, 0, byArray2.length - 1);
            mySHA3Digest.myDoFinal(byArray, 0, byArray2[byArray2.length - 1], n2);
        }
        if (!Arrays.areEqual(testVector.getHash(), byArray)) {
            this.fail(String.valueOf(testVector.getAlgorithm()) + " " + testVector.getBits() + "-bit test vector hash mismatch");
        }
    }

    private void skipUntil(BufferedReader bufferedReader, String string) throws IOException {
        String string2;
        while ((string2 = this.requireLine(bufferedReader)).length() == 0) {
        }
        if (!string2.equals(string)) {
            throw new IOException("Expected: " + string);
        }
    }

    private String[] splitAround(String string, String string2) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = string;
        while ((n = string3.indexOf(string2)) > 0) {
            arrayList.add(string3.substring(0, n));
            string3 = string3.substring(n + string2.length());
        }
        arrayList.add(string3);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String stripFromChar(String string, char c) {
        int n = string.indexOf(c);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public void testVectors() throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("SHA3TestVectors.txt")));
        while ((string = this.readLine(bufferedReader)) != null) {
            if (string.length() == 0) continue;
            TestVector testVector = this.readTestVector(bufferedReader, string);
            this.runTestVector(testVector);
        }
        bufferedReader.close();
    }

    static class MySHA3Digest
    extends SHA3Digest {
        MySHA3Digest(int n) {
            super(n);
        }

        int myDoFinal(byte[] byArray, int n, byte by, int n2) {
            return this.doFinal(byArray, n, by, n2);
        }
    }

    private static class TestVector {
        private static String SAMPLE_OF = " sample of ";
        private static String MSG_HEADER = "Msg as bit string";
        private static String HASH_HEADER = "Hash val is";
        private String algorithm;
        private int bits;
        private byte[] message;
        private byte[] hash;

        private TestVector(String string, int n, byte[] byArray, byte[] byArray2) {
            this.algorithm = string;
            this.bits = n;
            this.message = byArray;
            this.hash = byArray2;
        }

        /* synthetic */ TestVector(1 var1_1, String string, int n, byte[] byArray, byte[] byArray2) {
            this(string, n, byArray, byArray2);
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public int getBits() {
            return this.bits;
        }

        public byte[] getHash() {
            return this.hash;
        }

        public byte[] getMessage() {
            return this.message;
        }
    }
}

