/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SM4Test
extends CipherTest {
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, new SM4Engine(), new KeyParameter(Hex.decode("0123456789abcdeffedcba9876543210")), "0123456789abcdeffedcba9876543210", "681edf34d206965e86b3e94f536e4246")};

    SM4Test() {
        super(tests, new SM4Engine(), new KeyParameter(new byte[16]));
    }

    private void ccmTest() throws Exception {
        byte[] byArray = Hex.decode("00001234567800000000ABCD");
        byte[] byArray2 = Hex.decode("0123456789ABCDEFFEDCBA9876543210");
        byte[] byArray3 = Hex.decode("AAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBCCCCCCCCCCCCCCCCDDDDDDDDDDDDDDDDEEEEEEEEEEEEEEEEFFFFFFFFFFFFFFFFEEEEEEEEEEEEEEEEAAAAAAAAAAAAAAAA");
        byte[] byArray4 = Hex.decode("FEEDFACEDEADBEEFFEEDFACEDEADBEEFABADDAD2");
        byte[] byArray5 = Hex.decode("48AF93501FA62ADBCD414CCE6034D895DDA1BF8F132F042098661572E7483094FD12E518CE062C98ACEE28D95DF4416BED31A2F04476C18BB40C84A74B97DC5B");
        byte[] byArray6 = Hex.decode("fe26a58f94552a8d533b5b6b261c9cd8");
        CCMBlockCipher cCMBlockCipher = new CCMBlockCipher(new SM4Engine());
        CCMBlockCipher cCMBlockCipher2 = new CCMBlockCipher(new SM4Engine());
        this.checkTestCase(cCMBlockCipher, cCMBlockCipher2, "2", byArray2, byArray, byArray4, byArray3, byArray5, byArray6);
    }

    private void checkTestCase(AEADBlockCipher aEADBlockCipher, AEADBlockCipher aEADBlockCipher2, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws InvalidCipherTextException {
        aEADBlockCipher.init(true, new AEADParameters(new KeyParameter(byArray), byArray6.length * 8, byArray2));
        aEADBlockCipher2.init(false, new AEADParameters(new KeyParameter(byArray), byArray6.length * 8, byArray2));
        byte[] byArray7 = new byte[aEADBlockCipher.getOutputSize(byArray4.length)];
        if (byArray3 != null) {
            aEADBlockCipher.processAADBytes(byArray3, 0, byArray3.length);
        }
        int n = aEADBlockCipher.processBytes(byArray4, 0, byArray4.length, byArray7, 0);
        if (byArray7.length != (n += aEADBlockCipher.doFinal(byArray7, n))) {
            this.fail("encryption reported incorrect length: " + string);
        }
        byte[] byArray8 = aEADBlockCipher.getMac();
        byte[] byArray9 = new byte[byArray4.length];
        System.arraycopy(byArray7, 0, byArray9, 0, byArray9.length);
        byte[] byArray10 = new byte[byArray7.length - byArray4.length];
        System.arraycopy(byArray7, byArray4.length, byArray10, 0, byArray10.length);
        if (!this.areEqual(byArray5, byArray9)) {
            this.fail("incorrect encrypt in: " + string);
        }
        if (!this.areEqual(byArray6, byArray8)) {
            this.fail("getMac() returned wrong mac in: " + string);
        }
        if (aEADBlockCipher instanceof GCMBlockCipher && !this.areEqual(byArray6, byArray10)) {
            this.fail("stream contained wrong mac in: " + string);
        }
        byte[] byArray11 = new byte[aEADBlockCipher2.getOutputSize(byArray7.length)];
        if (byArray3 != null) {
            aEADBlockCipher2.processAADBytes(byArray3, 0, byArray3.length);
        }
        n = aEADBlockCipher2.processBytes(byArray7, 0, byArray7.length, byArray11, 0);
        n += aEADBlockCipher2.doFinal(byArray11, n);
        byArray8 = aEADBlockCipher2.getMac();
        byArray9 = new byte[byArray5.length];
        System.arraycopy(byArray11, 0, byArray9, 0, byArray9.length);
        if (!this.areEqual(byArray4, byArray9)) {
            this.fail("incorrect decrypt in: " + string);
        }
    }

    private void gcmTest() throws Exception {
        byte[] byArray = Hex.decode("00001234567800000000ABCD");
        byte[] byArray2 = Hex.decode("0123456789ABCDEFFEDCBA9876543210");
        byte[] byArray3 = Hex.decode("AAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBCCCCCCCCCCCCCCCCDDDDDDDDDDDDDDDDEEEEEEEEEEEEEEEEFFFFFFFFFFFFFFFFEEEEEEEEEEEEEEEEAAAAAAAAAAAAAAAA");
        byte[] byArray4 = Hex.decode("FEEDFACEDEADBEEFFEEDFACEDEADBEEFABADDAD2");
        byte[] byArray5 = Hex.decode("17F399F08C67D5EE19D0DC9969C4BB7D5FD46FD3756489069157B282BB200735D82710CA5C22F0CCFA7CBF93D496AC15A56834CBCF98C397B4024A2691233B8D");
        byte[] byArray6 = Hex.decode("83DE3541E4C2B58177E065A9BF7B62EC");
        GCMBlockCipher gCMBlockCipher = new GCMBlockCipher(new SM4Engine());
        GCMBlockCipher gCMBlockCipher2 = new GCMBlockCipher(new SM4Engine());
        this.checkTestCase(gCMBlockCipher, gCMBlockCipher2, "1", byArray2, byArray, byArray4, byArray3, byArray5, byArray6);
    }

    public String getName() {
        return "SM4";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new SM4Test());
    }

    public void performTest() throws Exception {
        super.performTest();
        this.test1000000();
        this.gcmTest();
        this.ccmTest();
    }

    private void test1000000() {
        byte[] byArray = Hex.decode("0123456789abcdeffedcba9876543210");
        byte[] byArray2 = Hex.decode("0123456789abcdeffedcba9876543210");
        byte[] byArray3 = Hex.decode("595298c7c6fd271f0402f804c33d3f66");
        byte[] byArray4 = new byte[16];
        SM4Engine sM4Engine = new SM4Engine();
        sM4Engine.init(true, new KeyParameter(byArray2));
        System.arraycopy(byArray, 0, byArray4, 0, byArray4.length);
        int n = 0;
        while (n != 1000000) {
            sM4Engine.processBlock(byArray4, 0, byArray4, 0);
            ++n;
        }
        if (!this.areEqual(byArray3, byArray4)) {
            this.fail("1000000 encryption test failed");
        }
        sM4Engine.init(false, new KeyParameter(byArray2));
        int n2 = 0;
        while (n2 != 1000000) {
            sM4Engine.processBlock(byArray4, 0, byArray4, 0);
            ++n2;
        }
        if (!this.areEqual(byArray, byArray4)) {
            this.fail("1000000 decryption test failed");
        }
    }
}

