/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.cert.TrustAnchor;
import org.bouncycastle.x509.X509AttributeCertificate;

class PrincipalUtils {
    PrincipalUtils() {
    }

    static X500Name getCA(TrustAnchor trustAnchor) {
        return new X500Name(trustAnchor.getCAName());
    }

    static X500Name getEncodedIssuerPrincipal(Object object) {
        if (object instanceof X509Certificate) {
            return PrincipalUtils.getIssuerPrincipal((X509Certificate)object);
        }
        return X500Name.getInstance(((X509Principal)((X509AttributeCertificate)object).getIssuer().getPrincipals()[0]).getEncoded());
    }

    static X500Name getIssuerPrincipal(X509CRL x509CRL) {
        try {
            TBSCertList tBSCertList = TBSCertList.getInstance(x509CRL.getTBSCertList());
            return X500Name.getInstance(tBSCertList.getIssuer());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
    }

    static X500Name getIssuerPrincipal(X509Certificate x509Certificate) {
        try {
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(x509Certificate.getTBSCertificate());
            return X500Name.getInstance(tBSCertificateStructure.getIssuer());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
    }

    static X500Name getSubjectPrincipal(X509Certificate x509Certificate) {
        try {
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(x509Certificate.getTBSCertificate());
            return X500Name.getInstance(tBSCertificateStructure.getSubject());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
    }
}

