/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss;

import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import org.bouncycastle.pqc.crypto.gmss.GMSSKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSRootCalc;
import org.bouncycastle.pqc.crypto.gmss.Treehash;
import org.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import org.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSVerify;
import org.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;

public class GMSSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private GMSSRandom gmssRandom;
    private Digest messDigestTree;
    private byte[][] currentSeeds;
    private byte[][] nextNextSeeds;
    private byte[][] currentRootSigs;
    private GMSSDigestProvider digestProvider;
    private int mdLength;
    private int numLayer;
    private boolean initialized = false;
    private GMSSParameters gmssPS;
    private int[] heightOfTrees;
    private int[] otsIndex;
    private int[] K;
    private GMSSKeyGenerationParameters gmssParams;
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.3";

    public GMSSKeyPairGenerator(GMSSDigestProvider gMSSDigestProvider) {
        this.digestProvider = gMSSDigestProvider;
        this.messDigestTree = gMSSDigestProvider.get();
        this.mdLength = this.messDigestTree.getDigestSize();
        this.gmssRandom = new GMSSRandom(this.messDigestTree);
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        byte[][][] byArray = new byte[this.numLayer][][];
        byte[][][] byArray2 = new byte[this.numLayer - 1][][];
        Treehash[][] treehashArray = new Treehash[this.numLayer][];
        Treehash[][] treehashArray2 = new Treehash[this.numLayer - 1][];
        Vector[] vectorArray = new Vector[this.numLayer];
        Vector[] vectorArray2 = new Vector[this.numLayer - 1];
        Vector[][] vectorArray3 = new Vector[this.numLayer][];
        Vector[][] vectorArray4 = new Vector[this.numLayer - 1][];
        int n = 0;
        while (n < this.numLayer) {
            byArray[n] = new byte[this.heightOfTrees[n]][this.mdLength];
            treehashArray[n] = new Treehash[this.heightOfTrees[n] - this.K[n]];
            if (n > 0) {
                byArray2[n - 1] = new byte[this.heightOfTrees[n]][this.mdLength];
                treehashArray2[n - 1] = new Treehash[this.heightOfTrees[n] - this.K[n]];
            }
            vectorArray[n] = new Vector();
            if (n > 0) {
                vectorArray2[n - 1] = new Vector();
            }
            ++n;
        }
        byte[][] byArray3 = new byte[this.numLayer][this.mdLength];
        byte[][] byArray4 = new byte[this.numLayer - 1][this.mdLength];
        byte[][] byArray5 = new byte[this.numLayer][this.mdLength];
        int n2 = 0;
        while (n2 < this.numLayer) {
            System.arraycopy(this.currentSeeds[n2], 0, byArray5[n2], 0, this.mdLength);
            ++n2;
        }
        this.currentRootSigs = new byte[this.numLayer - 1][this.mdLength];
        int n3 = this.numLayer - 1;
        while (n3 >= 0) {
            GMSSRootCalc gMSSRootCalc = n3 == this.numLayer - 1 ? this.generateCurrentAuthpathAndRoot(null, vectorArray[n3], byArray5[n3], n3) : this.generateCurrentAuthpathAndRoot(byArray3[n3 + 1], vectorArray[n3], byArray5[n3], n3);
            int n4 = 0;
            while (n4 < this.heightOfTrees[n3]) {
                System.arraycopy(gMSSRootCalc.getAuthPath()[n4], 0, byArray[n3][n4], 0, this.mdLength);
                ++n4;
            }
            vectorArray3[n3] = gMSSRootCalc.getRetain();
            treehashArray[n3] = gMSSRootCalc.getTreehash();
            System.arraycopy(gMSSRootCalc.getRoot(), 0, byArray3[n3], 0, this.mdLength);
            --n3;
        }
        int n5 = this.numLayer - 2;
        while (n5 >= 0) {
            GMSSRootCalc gMSSRootCalc = this.generateNextAuthpathAndRoot(vectorArray2[n5], byArray5[n5 + 1], n5 + 1);
            int n6 = 0;
            while (n6 < this.heightOfTrees[n5 + 1]) {
                System.arraycopy(gMSSRootCalc.getAuthPath()[n6], 0, byArray2[n5][n6], 0, this.mdLength);
                ++n6;
            }
            vectorArray4[n5] = gMSSRootCalc.getRetain();
            treehashArray2[n5] = gMSSRootCalc.getTreehash();
            System.arraycopy(gMSSRootCalc.getRoot(), 0, byArray4[n5], 0, this.mdLength);
            System.arraycopy(byArray5[n5 + 1], 0, this.nextNextSeeds[n5], 0, this.mdLength);
            --n5;
        }
        GMSSPublicKeyParameters gMSSPublicKeyParameters = new GMSSPublicKeyParameters(byArray3[0], this.gmssPS);
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = new GMSSPrivateKeyParameters(this.currentSeeds, this.nextNextSeeds, byArray, byArray2, treehashArray, treehashArray2, vectorArray, vectorArray2, vectorArray3, vectorArray4, byArray4, this.currentRootSigs, this.gmssPS, this.digestProvider);
        return new AsymmetricCipherKeyPair(gMSSPublicKeyParameters, gMSSPrivateKeyParameters);
    }

    private GMSSRootCalc generateCurrentAuthpathAndRoot(byte[] byArray, Vector vector, byte[] byArray2, int n) {
        WinternitzOTSignature winternitzOTSignature;
        byte[] byArray3 = new byte[this.mdLength];
        byte[] byArray4 = new byte[this.mdLength];
        byArray4 = this.gmssRandom.nextSeed(byArray2);
        GMSSRootCalc gMSSRootCalc = new GMSSRootCalc(this.heightOfTrees[n], this.K[n], this.digestProvider);
        gMSSRootCalc.initialize(vector);
        if (n == this.numLayer - 1) {
            winternitzOTSignature = new WinternitzOTSignature(byArray4, this.digestProvider.get(), this.otsIndex[n]);
            byArray3 = winternitzOTSignature.getPublicKey();
        } else {
            winternitzOTSignature = new WinternitzOTSignature(byArray4, this.digestProvider.get(), this.otsIndex[n]);
            this.currentRootSigs[n] = winternitzOTSignature.getSignature(byArray);
            WinternitzOTSVerify winternitzOTSVerify = new WinternitzOTSVerify(this.digestProvider.get(), this.otsIndex[n]);
            byArray3 = winternitzOTSVerify.Verify(byArray, this.currentRootSigs[n]);
        }
        gMSSRootCalc.update(byArray3);
        int n2 = 3;
        int n3 = 0;
        int n4 = 1;
        while (n4 < 1 << this.heightOfTrees[n]) {
            if (n4 == n2 && n3 < this.heightOfTrees[n] - this.K[n]) {
                gMSSRootCalc.initializeTreehashSeed(byArray2, n3);
                n2 *= 2;
                ++n3;
            }
            byArray4 = this.gmssRandom.nextSeed(byArray2);
            winternitzOTSignature = new WinternitzOTSignature(byArray4, this.digestProvider.get(), this.otsIndex[n]);
            gMSSRootCalc.update(winternitzOTSignature.getPublicKey());
            ++n4;
        }
        if (gMSSRootCalc.wasFinished()) {
            return gMSSRootCalc;
        }
        System.err.println("Baum noch nicht fertig konstruiert!!!");
        return null;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }

    private GMSSRootCalc generateNextAuthpathAndRoot(Vector vector, byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.numLayer];
        GMSSRootCalc gMSSRootCalc = new GMSSRootCalc(this.heightOfTrees[n], this.K[n], this.digestProvider);
        gMSSRootCalc.initialize(vector);
        int n2 = 3;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 1 << this.heightOfTrees[n]) {
            if (n4 == n2 && n3 < this.heightOfTrees[n] - this.K[n]) {
                gMSSRootCalc.initializeTreehashSeed(byArray, n3);
                n2 *= 2;
                ++n3;
            }
            byArray2 = this.gmssRandom.nextSeed(byArray);
            WinternitzOTSignature winternitzOTSignature = new WinternitzOTSignature(byArray2, this.digestProvider.get(), this.otsIndex[n]);
            gMSSRootCalc.update(winternitzOTSignature.getPublicKey());
            ++n4;
        }
        if (gMSSRootCalc.wasFinished()) {
            return gMSSRootCalc;
        }
        System.err.println("N\u00ef\u00bf\u0153chster Baum noch nicht fertig konstruiert!!!");
        return null;
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        GMSSKeyGenerationParameters gMSSKeyGenerationParameters;
        if (n <= 10) {
            int[] nArray = new int[]{10};
            int[] nArray2 = new int[]{3};
            int[] nArray3 = new int[]{2};
            gMSSKeyGenerationParameters = new GMSSKeyGenerationParameters(secureRandom, new GMSSParameters(nArray.length, nArray, nArray2, nArray3));
        } else if (n <= 20) {
            int[] nArray = new int[]{10, 10};
            int[] nArray4 = new int[]{5, 4};
            int[] nArray5 = new int[]{2, 2};
            gMSSKeyGenerationParameters = new GMSSKeyGenerationParameters(secureRandom, new GMSSParameters(nArray.length, nArray, nArray4, nArray5));
        } else {
            int[] nArray = new int[]{10, 10, 10, 10};
            int[] nArray6 = new int[]{9, 9, 9, 3};
            int[] nArray7 = new int[]{2, 2, 2, 2};
            gMSSKeyGenerationParameters = new GMSSKeyGenerationParameters(secureRandom, new GMSSParameters(nArray.length, nArray, nArray6, nArray7));
        }
        this.initialize(gMSSKeyGenerationParameters);
    }

    public void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.gmssParams = (GMSSKeyGenerationParameters)keyGenerationParameters;
        this.gmssPS = new GMSSParameters(this.gmssParams.getParameters().getNumOfLayers(), this.gmssParams.getParameters().getHeightOfTrees(), this.gmssParams.getParameters().getWinternitzParameter(), this.gmssParams.getParameters().getK());
        this.numLayer = this.gmssPS.getNumOfLayers();
        this.heightOfTrees = this.gmssPS.getHeightOfTrees();
        this.otsIndex = this.gmssPS.getWinternitzParameter();
        this.K = this.gmssPS.getK();
        this.currentSeeds = new byte[this.numLayer][this.mdLength];
        this.nextNextSeeds = new byte[this.numLayer - 1][this.mdLength];
        SecureRandom secureRandom = keyGenerationParameters.getRandom();
        int n = 0;
        while (n < this.numLayer) {
            secureRandom.nextBytes(this.currentSeeds[n]);
            this.gmssRandom.nextSeed(this.currentSeeds[n]);
            ++n;
        }
        this.initialized = true;
    }

    private void initializeDefault() {
        int[] nArray = new int[]{10, 10, 10, 10};
        int[] nArray2 = new int[]{3, 3, 3, 3};
        int[] nArray3 = new int[]{2, 2, 2, 2};
        GMSSKeyGenerationParameters gMSSKeyGenerationParameters = new GMSSKeyGenerationParameters(null, new GMSSParameters(nArray.length, nArray, nArray2, nArray3));
        this.initialize(gMSSKeyGenerationParameters);
    }
}

