/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.newhope;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.newhope.ChaCha20;
import org.bouncycastle.pqc.crypto.newhope.NTT;
import org.bouncycastle.pqc.crypto.newhope.Precomp;
import org.bouncycastle.pqc.crypto.newhope.Reduce;
import org.bouncycastle.util.Pack;

class Poly {
    Poly() {
    }

    static void add(short[] sArray, short[] sArray2, short[] sArray3) {
        int n = 0;
        while (n < 1024) {
            sArray3[n] = Reduce.barrett((short)(sArray[n] + sArray2[n]));
            ++n;
        }
    }

    static void fromBytes(short[] sArray, byte[] byArray) {
        int n = 0;
        while (n < 256) {
            int n2 = 7 * n;
            int n3 = byArray[n2] & 0xFF;
            int n4 = byArray[n2 + 1] & 0xFF;
            int n5 = byArray[n2 + 2] & 0xFF;
            int n6 = byArray[n2 + 3] & 0xFF;
            int n7 = byArray[n2 + 4] & 0xFF;
            int n8 = byArray[n2 + 5] & 0xFF;
            int n9 = byArray[n2 + 6] & 0xFF;
            int n10 = 4 * n;
            sArray[n10] = (short)(n3 | (n4 & 0x3F) << 8);
            sArray[n10 + 1] = (short)(n4 >>> 6 | n5 << 2 | (n6 & 0xF) << 10);
            sArray[n10 + 2] = (short)(n6 >>> 4 | n7 << 4 | (n8 & 3) << 12);
            sArray[n10 + 3] = (short)(n8 >>> 2 | n9 << 6);
            ++n;
        }
    }

    static void fromNTT(short[] sArray) {
        NTT.bitReverse(sArray);
        NTT.core(sArray, Precomp.OMEGAS_INV_MONTGOMERY);
        NTT.mulCoefficients(sArray, Precomp.PSIS_INV_MONTGOMERY);
    }

    static void getNoise(short[] sArray, byte[] byArray, byte by) {
        byte[] byArray2 = new byte[8];
        byArray2[0] = by;
        byte[] byArray3 = new byte[4096];
        ChaCha20.process(byArray, byArray2, byArray3, 0, byArray3.length);
        int n = 0;
        while (n < 1024) {
            int n2 = Pack.bigEndianToInt(byArray3, n * 4);
            int n3 = 0;
            int n4 = 0;
            while (n4 < 8) {
                n3 += n2 >> n4 & 0x1010101;
                ++n4;
            }
            int n5 = (n3 >>> 24) + n3 & 0xFF;
            int n6 = (n3 >>> 16) + (n3 >>> 8) & 0xFF;
            sArray[n] = (short)(n5 + 12289 - n6);
            ++n;
        }
    }

    private static short normalize(short s) {
        int n = Reduce.barrett(s);
        int n2 = n - 12289;
        int n3 = n2 >> 31;
        n = n2 ^ (n ^ n2) & n3;
        return (short)n;
    }

    static void pointWise(short[] sArray, short[] sArray2, short[] sArray3) {
        int n = 0;
        while (n < 1024) {
            int n2 = sArray[n] & 0xFFFF;
            int n3 = sArray2[n] & 0xFFFF;
            short s = Reduce.montgomery(3186 * n3);
            sArray3[n] = Reduce.montgomery(n2 * (s & 0xFFFF));
            ++n;
        }
    }

    static void toBytes(byte[] byArray, short[] sArray) {
        int n = 0;
        while (n < 256) {
            int n2 = 4 * n;
            short s = Poly.normalize(sArray[n2]);
            short s2 = Poly.normalize(sArray[n2 + 1]);
            short s3 = Poly.normalize(sArray[n2 + 2]);
            short s4 = Poly.normalize(sArray[n2 + 3]);
            int n3 = 7 * n;
            byArray[n3] = (byte)s;
            byArray[n3 + 1] = (byte)(s >> 8 | s2 << 6);
            byArray[n3 + 2] = (byte)(s2 >> 2);
            byArray[n3 + 3] = (byte)(s2 >> 10 | s3 << 4);
            byArray[n3 + 4] = (byte)(s3 >> 4);
            byArray[n3 + 5] = (byte)(s3 >> 12 | s4 << 2);
            byArray[n3 + 6] = (byte)(s4 >> 6);
            ++n;
        }
    }

    static void toNTT(short[] sArray) {
        NTT.mulCoefficients(sArray, Precomp.PSIS_BITREV_MONTGOMERY);
        NTT.core(sArray, Precomp.OMEGAS_MONTGOMERY);
    }

    static void uniform(short[] sArray, byte[] byArray) {
        SHAKEDigest sHAKEDigest = new SHAKEDigest(128);
        sHAKEDigest.update(byArray, 0, byArray.length);
        int n = 0;
        block0: while (true) {
            byte[] byArray2 = new byte[256];
            sHAKEDigest.doOutput(byArray2, 0, byArray2.length);
            int n2 = 0;
            while (true) {
                if (n2 >= byArray2.length) continue block0;
                int n3 = byArray2[n2] & 0xFF | (byArray2[n2 + 1] & 0xFF) << 8;
                if (n3 < 61445) {
                    sArray[n++] = (short)n3;
                    if (n == 1024) {
                        return;
                    }
                }
                n2 += 2;
            }
            break;
        }
    }
}

