/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.DigestingMessageSigner;
import org.bouncycastle.pqc.crypto.DigestingStateAwareMessageSigner;
import org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import org.bouncycastle.pqc.crypto.gmss.GMSSKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSKeyPairGenerator;
import org.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSSigner;
import org.bouncycastle.pqc.crypto.gmss.GMSSStateAwareSigner;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;

public class GMSSSignerTest
extends SimpleTest {
    public String getName() {
        return "GMSS";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new GMSSSignerTest());
    }

    public void performTest() throws Exception {
        GMSSParameters gMSSParameters = new GMSSParameters(3, new int[]{15, 15, 10}, new int[]{5, 5, 4}, new int[]{3, 3, 2});
        GMSSDigestProvider gMSSDigestProvider = new GMSSDigestProvider(){

            public Digest get() {
                return new SHA224Digest();
            }
        };
        GMSSKeyPairGenerator gMSSKeyPairGenerator = new GMSSKeyPairGenerator(gMSSDigestProvider);
        GMSSKeyGenerationParameters gMSSKeyGenerationParameters = new GMSSKeyGenerationParameters(null, gMSSParameters);
        gMSSKeyPairGenerator.init(gMSSKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = gMSSKeyPairGenerator.generateKeyPair();
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = (GMSSPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(gMSSPrivateKeyParameters, null);
        DigestingMessageSigner digestingMessageSigner = new DigestingMessageSigner(new GMSSSigner(gMSSDigestProvider), new SHA224Digest());
        digestingMessageSigner.init(true, parametersWithRandom);
        byte[] byArray = BigIntegers.asUnsignedByteArray(new BigInteger("968236873715988614170569073515315707566766479517"));
        digestingMessageSigner.update(byArray, 0, byArray.length);
        byte[] byArray2 = digestingMessageSigner.generateSignature();
        digestingMessageSigner.init(false, asymmetricCipherKeyPair.getPublic());
        digestingMessageSigner.update(byArray, 0, byArray.length);
        if (!digestingMessageSigner.verifySignature(byArray2)) {
            this.fail("verification fails");
        }
        if (!((GMSSPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).isUsed()) {
            this.fail("private key not marked as used");
        }
        this.stateAwareTest(gMSSPrivateKeyParameters.nextKey(), asymmetricCipherKeyPair.getPublic());
    }

    private void stateAwareTest(GMSSPrivateKeyParameters gMSSPrivateKeyParameters, AsymmetricKeyParameter asymmetricKeyParameter) {
        DigestingStateAwareMessageSigner digestingStateAwareMessageSigner = new DigestingStateAwareMessageSigner(new GMSSStateAwareSigner(new SHA224Digest()), (Digest)new SHA224Digest());
        digestingStateAwareMessageSigner.init(true, new ParametersWithRandom(gMSSPrivateKeyParameters, CryptoServicesRegistrar.getSecureRandom()));
        byte[] byArray = Strings.toByteArray("Message One");
        digestingStateAwareMessageSigner.update(byArray, 0, byArray.length);
        byte[] byArray2 = digestingStateAwareMessageSigner.generateSignature();
        this.isTrue(gMSSPrivateKeyParameters.isUsed());
        byte[] byArray3 = Strings.toByteArray("Message Two");
        digestingStateAwareMessageSigner.update(byArray3, 0, byArray3.length);
        byte[] byArray4 = digestingStateAwareMessageSigner.generateSignature();
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters2 = (GMSSPrivateKeyParameters)digestingStateAwareMessageSigner.getUpdatedPrivateKey();
        this.isTrue(!gMSSPrivateKeyParameters2.isUsed());
        try {
            digestingStateAwareMessageSigner.generateSignature();
        }
        catch (IllegalStateException illegalStateException) {
            this.isEquals("signing key no longer usable", illegalStateException.getMessage());
        }
        digestingStateAwareMessageSigner.init(false, asymmetricKeyParameter);
        digestingStateAwareMessageSigner.update(byArray3, 0, byArray3.length);
        if (!digestingStateAwareMessageSigner.verifySignature(byArray4)) {
            this.fail("verification two fails");
        }
        digestingStateAwareMessageSigner.update(byArray, 0, byArray.length);
        if (!digestingStateAwareMessageSigner.verifySignature(byArray2)) {
            this.fail("verification one fails");
        }
    }
}

