/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyPairGenerator;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceFujisakiCipher;
import org.bouncycastle.util.test.SimpleTest;

public class McElieceFujisakiCipherTest
extends SimpleTest {
    SecureRandom keyRandom = new SecureRandom();

    public String getName() {
        return "McElieceFujisaki";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new McElieceFujisakiCipherTest());
    }

    public void performTest() throws InvalidCipherTextException {
        int n = 1;
        int n2 = 10;
        Random random = new Random();
        int n3 = 0;
        while (n3 < n) {
            McElieceCCA2Parameters mcElieceCCA2Parameters = new McElieceCCA2Parameters();
            McElieceCCA2KeyPairGenerator mcElieceCCA2KeyPairGenerator = new McElieceCCA2KeyPairGenerator();
            McElieceCCA2KeyGenerationParameters mcElieceCCA2KeyGenerationParameters = new McElieceCCA2KeyGenerationParameters(this.keyRandom, mcElieceCCA2Parameters);
            mcElieceCCA2KeyPairGenerator.init(mcElieceCCA2KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = mcElieceCCA2KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPublic(), this.keyRandom);
            SHA256Digest sHA256Digest = new SHA256Digest();
            McElieceFujisakiCipher mcElieceFujisakiCipher = new McElieceFujisakiCipher();
            int n4 = 1;
            while (n4 <= n2) {
                System.out.println("############### test: " + n4);
                mcElieceFujisakiCipher.init(true, parametersWithRandom);
                int n5 = (random.nextInt() & 0x1F) + 1;
                byte[] byArray = new byte[n5];
                random.nextBytes(byArray);
                sHA256Digest.update(byArray, 0, byArray.length);
                byte[] byArray2 = new byte[sHA256Digest.getDigestSize()];
                sHA256Digest.doFinal(byArray2, 0);
                byte[] byArray3 = mcElieceFujisakiCipher.messageEncrypt(byArray2);
                mcElieceFujisakiCipher.init(false, asymmetricCipherKeyPair.getPrivate());
                byte[] byArray4 = mcElieceFujisakiCipher.messageDecrypt(byArray3);
                boolean bl = true;
                int n6 = 0;
                while (n6 < byArray2.length) {
                    bl = bl && byArray2[n6] == byArray4[n6];
                    ++n6;
                }
                if (!bl) {
                    this.fail("en/decryption fails");
                } else {
                    System.out.println("test okay");
                    System.out.println();
                }
                ++n4;
            }
            ++n3;
        }
    }
}

