/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.DigestingMessageSigner;
import org.bouncycastle.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowKeyPairGenerator;
import org.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import org.bouncycastle.pqc.crypto.rainbow.RainbowSigner;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.test.SimpleTest;

public class RainbowSignerTest
extends SimpleTest {
    public String getName() {
        return "Rainbow";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new RainbowSignerTest());
    }

    public void performTest() {
        RainbowParameters rainbowParameters = new RainbowParameters();
        RainbowKeyPairGenerator rainbowKeyPairGenerator = new RainbowKeyPairGenerator();
        RainbowKeyGenerationParameters rainbowKeyGenerationParameters = new RainbowKeyGenerationParameters(new SecureRandom(), rainbowParameters);
        rainbowKeyPairGenerator.init(rainbowKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = rainbowKeyPairGenerator.generateKeyPair();
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), new SecureRandom());
        DigestingMessageSigner digestingMessageSigner = new DigestingMessageSigner(new RainbowSigner(), new SHA224Digest());
        digestingMessageSigner.init(true, parametersWithRandom);
        byte[] byArray = BigIntegers.asUnsignedByteArray(new BigInteger("968236873715988614170569073515315707566766479517"));
        digestingMessageSigner.update(byArray, 0, byArray.length);
        byte[] byArray2 = digestingMessageSigner.generateSignature();
        digestingMessageSigner.init(false, asymmetricCipherKeyPair.getPublic());
        digestingMessageSigner.update(byArray, 0, byArray.length);
        if (!digestingMessageSigner.verifySignature(byArray2)) {
            this.fail("verification fails");
        }
    }
}

