/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import org.bouncycastle.math.raw.Bits;
import org.bouncycastle.util.Integers;

public class Longs {
    public static final int BYTES = 8;
    public static final int SIZE = 64;
    private static final byte[] DEBRUIJN_TZ;

    static {
        byte[] byArray = new byte[64];
        byArray[0] = 63;
        byArray[2] = 1;
        byArray[3] = 52;
        byArray[4] = 2;
        byArray[5] = 6;
        byArray[6] = 53;
        byArray[7] = 26;
        byArray[8] = 3;
        byArray[9] = 37;
        byArray[10] = 40;
        byArray[11] = 7;
        byArray[12] = 33;
        byArray[13] = 54;
        byArray[14] = 47;
        byArray[15] = 27;
        byArray[16] = 61;
        byArray[17] = 4;
        byArray[18] = 38;
        byArray[19] = 45;
        byArray[20] = 43;
        byArray[21] = 41;
        byArray[22] = 21;
        byArray[23] = 8;
        byArray[24] = 23;
        byArray[25] = 34;
        byArray[26] = 58;
        byArray[27] = 55;
        byArray[28] = 48;
        byArray[29] = 17;
        byArray[30] = 28;
        byArray[31] = 10;
        byArray[32] = 62;
        byArray[33] = 51;
        byArray[34] = 5;
        byArray[35] = 25;
        byArray[36] = 36;
        byArray[37] = 39;
        byArray[38] = 32;
        byArray[39] = 46;
        byArray[40] = 60;
        byArray[41] = 44;
        byArray[42] = 42;
        byArray[43] = 20;
        byArray[44] = 22;
        byArray[45] = 57;
        byArray[46] = 16;
        byArray[47] = 9;
        byArray[48] = 50;
        byArray[49] = 24;
        byArray[50] = 35;
        byArray[51] = 31;
        byArray[52] = 59;
        byArray[53] = 19;
        byArray[54] = 56;
        byArray[55] = 15;
        byArray[56] = 49;
        byArray[57] = 30;
        byArray[58] = 18;
        byArray[59] = 14;
        byArray[60] = 29;
        byArray[61] = 13;
        byArray[62] = 12;
        byArray[63] = 11;
        DEBRUIJN_TZ = byArray;
    }

    public static int numberOfLeadingZeros(long l) {
        int n = (int)(l >>> 32);
        int n2 = 0;
        if (n == 0) {
            n2 = 32;
            n = (int)l;
        }
        return n2 + Integers.numberOfLeadingZeros(n);
    }

    public static int numberOfTrailingZeros(long l) {
        byte by = DEBRUIJN_TZ[(int)((l & -l) * 315175865370177754L >>> 58)];
        long l2 = (l & 0xFFFFFFFFL | l >>> 32) - 1L >> 63;
        return by - (int)l2;
    }

    public static long reverse(long l) {
        l = Bits.bitPermuteStepSimple(l, 0x5555555555555555L, 1);
        l = Bits.bitPermuteStepSimple(l, 0x3333333333333333L, 2);
        l = Bits.bitPermuteStepSimple(l, 0xF0F0F0F0F0F0F0FL, 4);
        return Longs.reverseBytes(l);
    }

    public static long reverseBytes(long l) {
        return Longs.rotateLeft(l & 0xFF000000FF000000L, 8) | Longs.rotateLeft(l & 0xFF000000FF0000L, 24) | Longs.rotateLeft(l & 0xFF000000FF00L, 40) | Longs.rotateLeft(l & 0xFF000000FFL, 56);
    }

    public static long rotateLeft(long l, int n) {
        return l << n ^ l >>> -n;
    }

    public static long rotateRight(long l, int n) {
        return l >>> n ^ l << -n;
    }

    public static Long valueOf(long l) {
        return new Long(l);
    }
}

