/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEROctetString;

public class BEROctetString
extends ASN1OctetString {
    private static final int DEFAULT_SEGMENT_LIMIT = 1000;
    private final int segmentLimit;
    private final ASN1OctetString[] elements;

    static byte[] flattenOctetStrings(ASN1OctetString[] aSN1OctetStringArray) {
        int n = aSN1OctetStringArray.length;
        switch (n) {
            case 0: {
                return ASN1OctetString.EMPTY_OCTETS;
            }
            case 1: {
                return aSN1OctetStringArray[0].string;
            }
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += aSN1OctetStringArray[n3].string.length;
            ++n3;
        }
        byte[] byArray = new byte[n2];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            byte[] byArray2 = aSN1OctetStringArray[n4].string;
            System.arraycopy(byArray2, 0, byArray, n5, byArray2.length);
            n5 += byArray2.length;
            ++n4;
        }
        return byArray;
    }

    public BEROctetString(byte[] byArray) {
        this(byArray, 1000);
    }

    public BEROctetString(ASN1OctetString[] aSN1OctetStringArray) {
        this(aSN1OctetStringArray, 1000);
    }

    public BEROctetString(byte[] byArray, int n) {
        this(byArray, null, n);
    }

    public BEROctetString(ASN1OctetString[] aSN1OctetStringArray, int n) {
        this(BEROctetString.flattenOctetStrings(aSN1OctetStringArray), aSN1OctetStringArray, n);
    }

    private BEROctetString(byte[] byArray, ASN1OctetString[] aSN1OctetStringArray, int n) {
        super(byArray);
        this.elements = aSN1OctetStringArray;
        this.segmentLimit = n;
    }

    public Enumeration getObjects() {
        if (this.elements == null) {
            return new Enumeration(){
                int pos = 0;

                public boolean hasMoreElements() {
                    return this.pos < BEROctetString.this.string.length;
                }

                public Object nextElement() {
                    if (this.pos < BEROctetString.this.string.length) {
                        int n = Math.min(BEROctetString.this.string.length - this.pos, BEROctetString.this.segmentLimit);
                        byte[] byArray = new byte[n];
                        System.arraycopy(BEROctetString.this.string, this.pos, byArray, 0, n);
                        this.pos += n;
                        return new DEROctetString(byArray);
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        return new Enumeration(){
            int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < BEROctetString.this.elements.length;
            }

            public Object nextElement() {
                if (this.counter < BEROctetString.this.elements.length) {
                    return BEROctetString.this.elements[this.counter++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    boolean encodeConstructed() {
        return null != this.elements || this.string.length > this.segmentLimit;
    }

    int encodedLength(boolean bl) throws IOException {
        int n;
        if (!this.encodeConstructed()) {
            return DEROctetString.encodedLength(bl, this.string.length);
        }
        int n2 = n = bl ? 4 : 3;
        if (null != this.elements) {
            int n3 = 0;
            while (n3 < this.elements.length) {
                n += this.elements[n3].encodedLength(true);
                ++n3;
            }
        } else {
            int n4 = this.string.length / this.segmentLimit;
            n += n4 * DEROctetString.encodedLength(true, this.segmentLimit);
            int n5 = this.string.length - n4 * this.segmentLimit;
            if (n5 > 0) {
                n += DEROctetString.encodedLength(true, n5);
            }
        }
        return n;
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        if (!this.encodeConstructed()) {
            DEROctetString.encode(aSN1OutputStream, bl, this.string, 0, this.string.length);
            return;
        }
        aSN1OutputStream.writeIdentifier(bl, 36);
        aSN1OutputStream.write(128);
        if (null != this.elements) {
            aSN1OutputStream.writePrimitives(this.elements);
        } else {
            int n = 0;
            while (n < this.string.length) {
                int n2 = Math.min(this.string.length - n, this.segmentLimit);
                DEROctetString.encode(aSN1OutputStream, true, this.string, n, n2);
                n += n2;
            }
        }
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }
}

