/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class DateUtil {
    private static Long ZERO = DateUtil.longValueOf(0L);
    private static final Map localeCache = new HashMap();
    static Locale EN_Locale = DateUtil.forEN();

    DateUtil() {
    }

    private static Locale forEN() {
        if ("en".equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            return Locale.getDefault();
        }
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = 0;
        while (n != localeArray.length) {
            if ("en".equalsIgnoreCase(localeArray[n].getLanguage())) {
                return localeArray[n];
            }
            ++n;
        }
        return Locale.getDefault();
    }

    static Date epochAdjust(Date date) throws ParseException {
        Locale locale = Locale.getDefault();
        if (locale == null) {
            return date;
        }
        Map map = localeCache;
        synchronized (map) {
            Cloneable cloneable;
            Long l = (Long)localeCache.get(locale);
            if (l == null) {
                cloneable = new SimpleDateFormat("yyyyMMddHHmmssz");
                long l2 = ((DateFormat)cloneable).parse("19700101000000GMT+00:00").getTime();
                l = l2 == 0L ? ZERO : DateUtil.longValueOf(l2);
                localeCache.put(locale, l);
            }
            if (l != ZERO) {
                cloneable = new Date(date.getTime() - l);
                return cloneable;
            }
            cloneable = date;
            return cloneable;
        }
    }

    private static Long longValueOf(long l) {
        return new Long(l);
    }
}

