/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.util.DigestFactory;

public class PKCS5S2ParametersGenerator
extends PBEParametersGenerator {
    private Mac hMac;
    private byte[] state;

    public PKCS5S2ParametersGenerator() {
        this(DigestFactory.createSHA1());
    }

    public PKCS5S2ParametersGenerator(Digest digest) {
        this.hMac = new HMac(digest);
        this.state = new byte[this.hMac.getMacSize()];
    }

    private void F(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) {
        if (n == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        if (byArray != null) {
            this.hMac.update(byArray, 0, byArray.length);
        }
        this.hMac.update(byArray2, 0, byArray2.length);
        this.hMac.doFinal(this.state, 0);
        System.arraycopy(this.state, 0, byArray3, n2, this.state.length);
        int n3 = 1;
        while (n3 < n) {
            this.hMac.update(this.state, 0, this.state.length);
            this.hMac.doFinal(this.state, 0);
            int n4 = 0;
            while (n4 != this.state.length) {
                int n5 = n2 + n4;
                byArray3[n5] = (byte)(byArray3[n5] ^ this.state[n4]);
                ++n4;
            }
            ++n3;
        }
    }

    private byte[] generateDerivedKey(int n) {
        int n2 = this.hMac.getMacSize();
        int n3 = (n + n2 - 1) / n2;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[n3 * n2];
        int n4 = 0;
        KeyParameter keyParameter = new KeyParameter(this.password);
        this.hMac.init(keyParameter);
        int n5 = 1;
        while (n5 <= n3) {
            int n6;
            int n7 = 3;
            do {
                n6 = n7--;
            } while ((byArray[n6] = (byte)(byArray[n6] + 1)) == 0);
            this.F(this.salt, this.iterationCount, byArray, byArray2, n4);
            n4 += n2;
            ++n5;
        }
        return byArray2;
    }

    public CipherParameters generateDerivedParameters(int n) {
        byte[] byArray = this.generateDerivedKey(n /= 8);
        return new KeyParameter(byArray, 0, n);
    }

    public CipherParameters generateDerivedParameters(int n, int n2) {
        byte[] byArray = this.generateDerivedKey((n /= 8) + (n2 /= 8));
        return new ParametersWithIV(new KeyParameter(byArray, 0, n), byArray, n, n2);
    }

    public CipherParameters generateDerivedMacParameters(int n) {
        return this.generateDerivedParameters(n);
    }
}

