/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.dsa;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.util.OpenSSHPrivateKeyUtil;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import org.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    static /* synthetic */ Class class$java$security$spec$DSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$DSAPrivateKeySpec;
    static /* synthetic */ Class class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec;
    static /* synthetic */ Class class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec;

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(class$java$security$spec$DSAPublicKeySpec == null ? (class$java$security$spec$DSAPublicKeySpec = KeyFactorySpi.class$("java.security.spec.DSAPublicKeySpec")) : class$java$security$spec$DSAPublicKeySpec) && key instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
            return new DSAPublicKeySpec(dSAPublicKey.getY(), dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ(), dSAPublicKey.getParams().getG());
        }
        if (clazz.isAssignableFrom(class$java$security$spec$DSAPrivateKeySpec == null ? (class$java$security$spec$DSAPrivateKeySpec = KeyFactorySpi.class$("java.security.spec.DSAPrivateKeySpec")) : class$java$security$spec$DSAPrivateKeySpec) && key instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key;
            return new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAPrivateKey.getParams().getP(), dSAPrivateKey.getParams().getQ(), dSAPrivateKey.getParams().getG());
        }
        if (clazz.isAssignableFrom(class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec == null ? (class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec = KeyFactorySpi.class$("org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec")) : class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec) && key instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
            try {
                return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new DSAPublicKeyParameters(dSAPublicKey.getY(), new DSAParameters(dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ(), dSAPublicKey.getParams().getG()))));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec == null ? (class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec = KeyFactorySpi.class$("org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec")) : class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec) && key instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key;
            try {
                return new OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new DSAPrivateKeyParameters(dSAPrivateKey.getX(), new DSAParameters(dSAPrivateKey.getParams().getP(), dSAPrivateKey.getParams().getQ(), dSAPrivateKey.getParams().getG()))));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to produce encoding: " + iOException.getMessage());
            }
        }
        return super.engineGetKeySpec(key, clazz);
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof DSAPublicKey) {
            return new BCDSAPublicKey((DSAPublicKey)key);
        }
        if (key instanceof DSAPrivateKey) {
            return new BCDSAPrivateKey((DSAPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (DSAUtil.isDsaOid(aSN1ObjectIdentifier)) {
            return new BCDSAPrivateKey(privateKeyInfo);
        }
        throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognised");
    }

    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (DSAUtil.isDsaOid(aSN1ObjectIdentifier)) {
            return new BCDSAPublicKey(subjectPublicKeyInfo);
        }
        throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognised");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPrivateKeySpec) {
            return new BCDSAPrivateKey((DSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob(((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
                return this.engineGeneratePrivate(new DSAPrivateKeySpec(((DSAPrivateKeyParameters)asymmetricKeyParameter).getX(), ((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getP(), ((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getQ(), ((DSAPrivateKeyParameters)asymmetricKeyParameter).getParameters().getG()));
            }
            throw new IllegalArgumentException("openssh private key is not dsa privare key");
        }
        return super.engineGeneratePrivate(keySpec);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPublicKeySpec) {
            try {
                return new BCDSAPublicKey((DSAPublicKeySpec)keySpec);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("invalid KeySpec: " + exception.getMessage()){

                    public Throwable getCause() {
                        return exception;
                    }
                };
            }
        }
        if (keySpec instanceof OpenSSHPublicKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPublicKeyUtil.parsePublicKey(((OpenSSHPublicKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
                return this.engineGeneratePublic(new DSAPublicKeySpec(((DSAPublicKeyParameters)asymmetricKeyParameter).getY(), ((DSAPublicKeyParameters)asymmetricKeyParameter).getParameters().getP(), ((DSAPublicKeyParameters)asymmetricKeyParameter).getParameters().getQ(), ((DSAPublicKeyParameters)asymmetricKeyParameter).getParameters().getG()));
            }
            throw new IllegalArgumentException("openssh public key is not dsa public key");
        }
        return super.engineGeneratePublic(keySpec);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

