/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.x509;

import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import org.bouncycastle.jcajce.provider.asymmetric.x509.X509CertificateImpl;
import org.bouncycastle.jcajce.provider.asymmetric.x509.X509CertificateInternal;
import org.bouncycastle.jcajce.provider.asymmetric.x509.X509SignatureUtil;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;

class X509CertificateObject
extends X509CertificateImpl
implements PKCS12BagAttributeCarrier {
    private final Object cacheLock = new Object();
    private X509CertificateInternal internalCertificateValue;
    private X509Principal issuerValue;
    private PublicKey publicKeyValue;
    private X509Principal subjectValue;
    private long[] validityValues;
    private volatile boolean hashValueSet;
    private volatile int hashValue;
    private PKCS12BagAttributeCarrier attrCarrier = new PKCS12BagAttributeCarrierImpl();

    X509CertificateObject(JcaJceHelper jcaJceHelper, Certificate certificate) throws CertificateParsingException {
        super(jcaJceHelper, certificate, X509CertificateObject.createBasicConstraints(certificate), X509CertificateObject.createKeyUsage(certificate), X509CertificateObject.createSigAlgName(certificate), X509CertificateObject.createSigAlgParams(certificate));
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        long[] lArray;
        long l = date.getTime();
        if (l > (lArray = this.getValidityValues())[1]) {
            throw new CertificateExpiredException("certificate expired on " + this.c.getEndDate().getTime());
        }
        if (l < lArray[0]) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.c.getStartDate().getTime());
        }
    }

    public PublicKey getPublicKey() {
        Object object = this.cacheLock;
        synchronized (object) {
            if (null != this.publicKeyValue) {
                PublicKey publicKey = this.publicKeyValue;
                return publicKey;
            }
        }
        PublicKey publicKey = super.getPublicKey();
        if (null == publicKey) {
            return null;
        }
        Object object2 = this.cacheLock;
        synchronized (object2) {
            if (null == this.publicKeyValue) {
                this.publicKeyValue = publicKey;
            }
            PublicKey publicKey2 = this.publicKeyValue;
            return publicKey2;
        }
    }

    public long[] getValidityValues() {
        Object object = this.cacheLock;
        synchronized (object) {
            if (null != this.validityValues) {
                long[] lArray = this.validityValues;
                return lArray;
            }
        }
        long[] lArray = new long[]{super.getNotBefore().getTime(), super.getNotAfter().getTime()};
        Object object2 = this.cacheLock;
        synchronized (object2) {
            if (null == this.validityValues) {
                this.validityValues = lArray;
            }
            long[] lArray2 = this.validityValues;
            return lArray2;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof X509CertificateObject) {
            ASN1BitString aSN1BitString;
            X509CertificateObject x509CertificateObject = (X509CertificateObject)object;
            if (this.hashValueSet && x509CertificateObject.hashValueSet ? this.hashValue != x509CertificateObject.hashValue : (null == this.internalCertificateValue || null == x509CertificateObject.internalCertificateValue) && null != (aSN1BitString = this.c.getSignature()) && !aSN1BitString.equals(x509CertificateObject.c.getSignature())) {
                return false;
            }
        }
        return this.getInternalCertificate().equals(object);
    }

    public int hashCode() {
        if (!this.hashValueSet) {
            this.hashValue = this.getInternalCertificate().hashCode();
            this.hashValueSet = true;
        }
        return this.hashValue;
    }

    public int originalHashCode() {
        try {
            int n = 0;
            byte[] byArray = this.getInternalCertificate().getEncoded();
            int n2 = 1;
            while (n2 < byArray.length) {
                n += byArray[n2] * n2;
                ++n2;
            }
            return n;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return 0;
        }
    }

    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    private X509CertificateInternal getInternalCertificate() {
        byte[] byArray;
        Object object = this.cacheLock;
        synchronized (object) {
            if (null != this.internalCertificateValue) {
                X509CertificateInternal x509CertificateInternal = this.internalCertificateValue;
                return x509CertificateInternal;
            }
        }
        CertificateEncodingException certificateEncodingException = null;
        try {
            byArray = this.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException2) {
            certificateEncodingException = certificateEncodingException2;
            byArray = null;
        }
        X509CertificateInternal x509CertificateInternal = new X509CertificateInternal(this.bcHelper, this.c, this.basicConstraints, this.keyUsage, this.sigAlgName, this.sigAlgParams, byArray, certificateEncodingException);
        Object object2 = this.cacheLock;
        synchronized (object2) {
            if (null == this.internalCertificateValue) {
                this.internalCertificateValue = x509CertificateInternal;
            }
            X509CertificateInternal x509CertificateInternal2 = this.internalCertificateValue;
            return x509CertificateInternal2;
        }
    }

    private static BasicConstraints createBasicConstraints(Certificate certificate) throws CertificateParsingException {
        try {
            byte[] byArray = X509CertificateImpl.getExtensionOctets(certificate, "2.5.29.19");
            if (null == byArray) {
                return null;
            }
            return BasicConstraints.getInstance(ASN1Primitive.fromByteArray(byArray));
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
        }
    }

    private static boolean[] createKeyUsage(Certificate certificate) throws CertificateParsingException {
        try {
            byte[] byArray = X509CertificateImpl.getExtensionOctets(certificate, "2.5.29.15");
            if (null == byArray) {
                return null;
            }
            ASN1BitString aSN1BitString = ASN1BitString.getInstance(ASN1Primitive.fromByteArray(byArray));
            byte[] byArray2 = aSN1BitString.getBytes();
            int n = byArray2.length * 8 - aSN1BitString.getPadBits();
            boolean[] blArray = new boolean[n < 9 ? 9 : n];
            int n2 = 0;
            while (n2 != n) {
                blArray[n2] = (byArray2[n2 / 8] & 128 >>> n2 % 8) != 0;
                ++n2;
            }
            return blArray;
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
        }
    }

    private static String createSigAlgName(Certificate certificate) throws CertificateParsingException {
        try {
            return X509SignatureUtil.getSignatureName(certificate.getSignatureAlgorithm());
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct SigAlgName: " + exception);
        }
    }

    private static byte[] createSigAlgParams(Certificate certificate) throws CertificateParsingException {
        try {
            ASN1Encodable aSN1Encodable = certificate.getSignatureAlgorithm().getParameters();
            if (null == aSN1Encodable) {
                return null;
            }
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct SigAlgParams: " + exception);
        }
    }
}

