/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.drbg;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.prng.EntropySource;
import org.bouncycastle.crypto.prng.EntropySourceProvider;
import org.bouncycastle.crypto.prng.SP800SecureRandom;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;

public class DRBG {
    private static final String PREFIX = (class$org$bouncycastle$jcajce$provider$drbg$DRBG == null ? (class$org$bouncycastle$jcajce$provider$drbg$DRBG = DRBG.class$("org.bouncycastle.jcajce.provider.drbg.DRBG")) : class$org$bouncycastle$jcajce$provider$drbg$DRBG).getName();
    private static final String[][] initialEntropySourceNames = new String[][]{{"sun.security.provider.Sun", "sun.security.provider.SecureRandom"}, {"org.apache.harmony.security.provider.crypto.CryptoProvider", "org.apache.harmony.security.provider.crypto.SHA1PRNG_SecureRandomImpl"}, {"com.android.org.conscrypt.OpenSSLProvider", "com.android.org.conscrypt.OpenSSLRandom"}, {"org.conscrypt.OpenSSLProvider", "org.conscrypt.OpenSSLRandom"}};
    static /* synthetic */ Class class$org$bouncycastle$jcajce$provider$drbg$DRBG;

    private static final Object[] findSource() {
        int n = 0;
        while (n < initialEntropySourceNames.length) {
            String[] stringArray = initialEntropySourceNames[n];
            try {
                Object[] objectArray = new Object[]{Class.forName(stringArray[0]).newInstance(), Class.forName(stringArray[1]).newInstance()};
                return objectArray;
            }
            catch (Throwable throwable) {
                ++n;
            }
        }
        return null;
    }

    private static SecureRandom createInitialEntropySource() {
        return DRBG.createCoreSecureRandom();
    }

    private static SecureRandom createCoreSecureRandom() {
        if (Security.getProperty("securerandom.source") == null) {
            return new CoreSecureRandom(DRBG.findSource());
        }
        try {
            String string = Security.getProperty("securerandom.source");
            return new URLSeededSecureRandom(new URL(string));
        }
        catch (Exception exception) {
            return new CoreSecureRandom(DRBG.findSource());
        }
    }

    private static EntropySourceProvider createEntropySource() {
        final String string = Properties.getPropertyValue("org.bouncycastle.drbg.entropysource");
        return (EntropySourceProvider)AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$org$bouncycastle$jcajce$provider$drbg$DRBG;

            public Object run() {
                try {
                    Class clazz = ClassUtil.loadClass(class$org$bouncycastle$jcajce$provider$drbg$DRBG == null ? (class$org$bouncycastle$jcajce$provider$drbg$DRBG = 1.class$("org.bouncycastle.jcajce.provider.drbg.DRBG")) : class$org$bouncycastle$jcajce$provider$drbg$DRBG, string);
                    return clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalStateException("entropy source " + string + " not created: " + exception.getMessage());
                }
            }

            static /* synthetic */ Class class$(String string2) {
                try {
                    return Class.forName(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private static SecureRandom createBaseRandom(boolean bl) {
        if (Properties.getPropertyValue("org.bouncycastle.drbg.entropysource") != null) {
            EntropySourceProvider entropySourceProvider = DRBG.createEntropySource();
            EntropySource entropySource = entropySourceProvider.get(128);
            byte[] byArray = bl ? DRBG.generateDefaultPersonalizationString(entropySource.getEntropy()) : DRBG.generateNonceIVPersonalizationString(entropySource.getEntropy());
            return new SP800SecureRandomBuilder(entropySourceProvider).setPersonalizationString(byArray).buildHash(new SHA512Digest(), Arrays.concatenate(entropySource.getEntropy(), entropySource.getEntropy()), bl);
        }
        HybridSecureRandom hybridSecureRandom = new HybridSecureRandom();
        byte[] byArray = bl ? DRBG.generateDefaultPersonalizationString(((SecureRandom)hybridSecureRandom).generateSeed(16)) : DRBG.generateNonceIVPersonalizationString(((SecureRandom)hybridSecureRandom).generateSeed(16));
        return new SP800SecureRandomBuilder(hybridSecureRandom, true).setPersonalizationString(byArray).buildHash(new SHA512Digest(), ((SecureRandom)hybridSecureRandom).generateSeed(32), bl);
    }

    private static byte[] generateDefaultPersonalizationString(byte[] byArray) {
        return Arrays.concatenate(Strings.toByteArray("Default"), byArray, Strings.toByteArray(Thread.currentThread().toString()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private static byte[] generateNonceIVPersonalizationString(byte[] byArray) {
        return Arrays.concatenate(Strings.toByteArray("Nonce"), byArray, Strings.toByteArray(Thread.currentThread().toString()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ SecureRandom access$000(boolean bl) {
        return DRBG.createBaseRandom(bl);
    }

    static /* synthetic */ SecureRandom access$300() {
        return DRBG.createInitialEntropySource();
    }

    private static class AtomicReference {
        private volatile Object value;

        private AtomicReference() {
        }

        public synchronized void set(Object object) {
            this.value = object;
        }

        public synchronized Object getAndSet(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }

    private static class AtomicInteger {
        private volatile int value;

        AtomicInteger(int n) {
            this.value = n;
        }

        public synchronized void set(int n) {
            this.value = n;
        }

        public synchronized int getAndSet(int n) {
            int n2 = this.value;
            this.value = n;
            return n2;
        }

        public synchronized int getAndIncrement() {
            int n = this.value++;
            return n;
        }
    }

    private static class AtomicBoolean {
        private volatile boolean value;

        AtomicBoolean(boolean bl) {
            this.value = bl;
        }

        public synchronized void set(boolean bl) {
            this.value = bl;
        }

        public synchronized boolean getAndSet(boolean bl) {
            boolean bl2 = this.value;
            this.value = bl;
            return bl2;
        }
    }

    private static class HybridSecureRandom
    extends SecureRandom {
        private final AtomicBoolean seedAvailable = new AtomicBoolean(false);
        private final AtomicInteger samples = new AtomicInteger(0);
        private final SecureRandom baseRandom = DRBG.access$300();
        private final SP800SecureRandom drbg = new SP800SecureRandomBuilder(new EntropySourceProvider(this){
            private final /* synthetic */ HybridSecureRandom this$0;
            {
                this.this$0 = hybridSecureRandom;
            }

            public EntropySource get(int n) {
                return this.this$0.new SignallingEntropySource(n);
            }
        }).setPersonalizationString(Strings.toByteArray("Bouncy Castle Hybrid Entropy Source")).buildHMAC(new HMac(new SHA512Digest()), this.baseRandom.generateSeed(32), false);

        HybridSecureRandom() {
            super(null, new HybridRandomProvider());
        }

        public void setSeed(byte[] byArray) {
            if (this.drbg != null) {
                this.drbg.setSeed(byArray);
            }
        }

        public void setSeed(long l) {
            if (this.drbg != null) {
                this.drbg.setSeed(l);
            }
        }

        public byte[] generateSeed(int n) {
            byte[] byArray = new byte[n];
            if (this.samples.getAndIncrement() > 20 && this.seedAvailable.getAndSet(false)) {
                this.samples.set(0);
                this.drbg.reseed((byte[])null);
            }
            this.drbg.nextBytes(byArray);
            return byArray;
        }

        private class SignallingEntropySource
        implements EntropySource {
            private final int byteLength;
            private final AtomicReference entropy = new AtomicReference();
            private final AtomicBoolean scheduled = new AtomicBoolean(false);

            SignallingEntropySource(int n) {
                this.byteLength = (n + 7) / 8;
            }

            public boolean isPredictionResistant() {
                return true;
            }

            public byte[] getEntropy() {
                byte[] byArray = (byte[])this.entropy.getAndSet(null);
                if (byArray == null || byArray.length != this.byteLength) {
                    byArray = HybridSecureRandom.this.baseRandom.generateSeed(this.byteLength);
                } else {
                    this.scheduled.set(false);
                }
                if (!this.scheduled.getAndSet(true)) {
                    Thread thread = new Thread(new EntropyGatherer(this.byteLength));
                    thread.setDaemon(true);
                    thread.start();
                }
                return byArray;
            }

            public int entropySize() {
                return this.byteLength * 8;
            }

            private class EntropyGatherer
            implements Runnable {
                private final int numBytes;

                EntropyGatherer(int n) {
                    this.numBytes = n;
                }

                private void sleep(long l) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }

                public void run() {
                    long l;
                    String string = Properties.getPropertyValue("org.bouncycastle.drbg.gather_pause_secs");
                    if (string != null) {
                        try {
                            l = Long.parseLong(string) * 1000L;
                        }
                        catch (Exception exception) {
                            l = 5000L;
                        }
                    } else {
                        l = 5000L;
                    }
                    byte[] byArray = new byte[this.numBytes];
                    int n = 0;
                    while (n < SignallingEntropySource.this.byteLength / 8) {
                        this.sleep(l);
                        byte[] byArray2 = HybridSecureRandom.this.baseRandom.generateSeed(8);
                        System.arraycopy(byArray2, 0, byArray, n * 8, byArray2.length);
                        ++n;
                    }
                    int n2 = SignallingEntropySource.this.byteLength - SignallingEntropySource.this.byteLength / 8 * 8;
                    if (n2 != 0) {
                        this.sleep(l);
                        byte[] byArray3 = HybridSecureRandom.this.baseRandom.generateSeed(n2);
                        System.arraycopy(byArray3, 0, byArray, byArray.length - byArray3.length, byArray3.length);
                    }
                    SignallingEntropySource.this.entropy.set(byArray);
                    HybridSecureRandom.this.seedAvailable.set(true);
                }
            }
        }
    }

    private static class URLSeededSecureRandom
    extends SecureRandom {
        private final InputStream seedStream;

        URLSeededSecureRandom(URL uRL) {
            super(null, new HybridRandomProvider());
            this.seedStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(this, uRL){
                private final /* synthetic */ URL val$url;
                private final /* synthetic */ URLSeededSecureRandom this$0;
                {
                    this.this$0 = uRLSeededSecureRandom;
                    this.val$url = uRL;
                }

                public Object run() {
                    try {
                        return this.val$url.openStream();
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException("unable to open random source");
                    }
                }
            });
        }

        public void setSeed(byte[] byArray) {
        }

        public void setSeed(long l) {
        }

        public byte[] generateSeed(int n) {
            URLSeededSecureRandom uRLSeededSecureRandom = this;
            synchronized (uRLSeededSecureRandom) {
                int n2;
                byte[] byArray = new byte[n];
                int n3 = 0;
                while (n3 != byArray.length && (n2 = this.privilegedRead(byArray, n3, byArray.length - n3)) > -1) {
                    n3 += n2;
                }
                if (n3 != byArray.length) {
                    throw new InternalError("unable to fully read random source");
                }
                byte[] byArray2 = byArray;
                return byArray2;
            }
        }

        private int privilegedRead(byte[] byArray, int n, int n2) {
            return (Integer)AccessController.doPrivileged(new PrivilegedAction(this, byArray, n, n2){
                private final /* synthetic */ byte[] val$data;
                private final /* synthetic */ int val$off;
                private final /* synthetic */ int val$len;
                private final /* synthetic */ URLSeededSecureRandom this$0;
                {
                    this.this$0 = uRLSeededSecureRandom;
                    this.val$data = byArray;
                    this.val$off = n;
                    this.val$len = n2;
                }

                public Object run() {
                    try {
                        return Integers.valueOf(URLSeededSecureRandom.access$200(this.this$0).read(this.val$data, this.val$off, this.val$len));
                    }
                    catch (IOException iOException) {
                        throw new InternalError("unable to read random source");
                    }
                }
            });
        }

        static /* synthetic */ InputStream access$200(URLSeededSecureRandom uRLSeededSecureRandom) {
            return uRLSeededSecureRandom.seedStream;
        }
    }

    private static class HybridRandomProvider
    extends Provider {
        protected HybridRandomProvider() {
            super("BCHEP", 1.0, "Bouncy Castle Hybrid Entropy Provider");
        }
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("SecureRandom.DEFAULT", PREFIX + "$Default");
            configurableProvider.addAlgorithm("SecureRandom.NONCEANDIV", PREFIX + "$NonceAndIV");
        }
    }

    public static class NonceAndIV
    extends SecureRandomSpi {
        private static final SecureRandom random = DRBG.access$000(false);

        protected void engineSetSeed(byte[] byArray) {
            random.setSeed(byArray);
        }

        protected void engineNextBytes(byte[] byArray) {
            random.nextBytes(byArray);
        }

        protected byte[] engineGenerateSeed(int n) {
            return random.generateSeed(n);
        }
    }

    public static class Default
    extends SecureRandomSpi {
        private static final SecureRandom random = DRBG.access$000(true);

        protected void engineSetSeed(byte[] byArray) {
            random.setSeed(byArray);
        }

        protected void engineNextBytes(byte[] byArray) {
            random.nextBytes(byArray);
        }

        protected byte[] engineGenerateSeed(int n) {
            return random.generateSeed(n);
        }
    }

    private static class CoreSecureRandom
    extends SecureRandom {
        CoreSecureRandom(Object[] objectArray) {
            super((SecureRandomSpi)objectArray[1], (Provider)objectArray[0]);
        }
    }
}

