/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincs;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.sphincs.Permute;
import org.bouncycastle.util.Strings;

class HashFunctions {
    private static final byte[] hashc = Strings.toByteArray("expand 32-byte to 64-byte state!");
    private final Digest dig256;
    private final Digest dig512;
    private final Permute perm = new Permute();

    HashFunctions(Digest digest) {
        this(digest, null);
    }

    HashFunctions(Digest digest, Digest digest2) {
        this.dig256 = digest;
        this.dig512 = digest2;
    }

    int varlen_hash(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.dig256.update(byArray2, 0, n2);
        this.dig256.doFinal(byArray, n);
        return 0;
    }

    Digest getMessageHash() {
        return this.dig512;
    }

    int hash_2n_n(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3 = new byte[64];
        int n3 = 0;
        while (n3 < 32) {
            byArray3[n3] = byArray2[n2 + n3];
            byArray3[n3 + 32] = hashc[n3];
            ++n3;
        }
        this.perm.chacha_permute(byArray3, byArray3);
        n3 = 0;
        while (n3 < 32) {
            byArray3[n3] = (byte)(byArray3[n3] ^ byArray2[n2 + n3 + 32]);
            ++n3;
        }
        this.perm.chacha_permute(byArray3, byArray3);
        n3 = 0;
        while (n3 < 32) {
            byArray[n + n3] = byArray3[n3];
            ++n3;
        }
        return 0;
    }

    int hash_2n_n_mask(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3) {
        byte[] byArray4 = new byte[64];
        int n4 = 0;
        while (n4 < 64) {
            byArray4[n4] = (byte)(byArray2[n2 + n4] ^ byArray3[n3 + n4]);
            ++n4;
        }
        int n5 = this.hash_2n_n(byArray, n, byArray4, 0);
        return n5;
    }

    int hash_n_n(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3 = new byte[64];
        int n3 = 0;
        while (n3 < 32) {
            byArray3[n3] = byArray2[n2 + n3];
            byArray3[n3 + 32] = hashc[n3];
            ++n3;
        }
        this.perm.chacha_permute(byArray3, byArray3);
        n3 = 0;
        while (n3 < 32) {
            byArray[n + n3] = byArray3[n3];
            ++n3;
        }
        return 0;
    }

    int hash_n_n_mask(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3) {
        byte[] byArray4 = new byte[32];
        int n4 = 0;
        while (n4 < 32) {
            byArray4[n4] = (byte)(byArray2[n2 + n4] ^ byArray3[n3 + n4]);
            ++n4;
        }
        return this.hash_n_n(byArray, n, byArray4, 0);
    }
}

