/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.pqc.math.linearalgebra.Matrix;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.Vector;
import org.bouncycastle.util.Arrays;

public class GF2Matrix
extends Matrix {
    private int[][] matrix;
    private int length;

    public GF2Matrix(byte[] byArray) {
        if (byArray.length < 9) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.numRows = LittleEndianConversions.OS2IP(byArray, 0);
        this.numColumns = LittleEndianConversions.OS2IP(byArray, 4);
        int n = (this.numColumns + 7 >>> 3) * this.numRows;
        if (this.numRows <= 0 || n != byArray.length - 8) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.length = this.numColumns + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int n2 = this.numColumns >> 5;
        int n3 = this.numColumns & 0x1F;
        int n4 = 8;
        int n5 = 0;
        while (n5 < this.numRows) {
            int n6 = 0;
            while (n6 < n2) {
                this.matrix[n5][n6] = LittleEndianConversions.OS2IP(byArray, n4);
                ++n6;
                n4 += 4;
            }
            int n7 = 0;
            while (n7 < n3) {
                int[] nArray = this.matrix[n5];
                int n8 = n2;
                nArray[n8] = nArray[n8] ^ (byArray[n4++] & 0xFF) << n7;
                n7 += 8;
            }
            ++n5;
        }
    }

    public GF2Matrix(int n, int[][] nArray) {
        if (nArray[0].length != n + 31 >> 5) {
            throw new ArithmeticException("Int array does not match given number of columns.");
        }
        this.numColumns = n;
        this.numRows = nArray.length;
        this.length = nArray[0].length;
        int n2 = n & 0x1F;
        int n3 = n2 == 0 ? -1 : (1 << n2) - 1;
        int n4 = 0;
        while (n4 < this.numRows) {
            int[] nArray2 = nArray[n4];
            int n5 = this.length - 1;
            nArray2[n5] = nArray2[n5] & n3;
            ++n4;
        }
        this.matrix = nArray;
    }

    public GF2Matrix(int n, char c) {
        this(n, c, new SecureRandom());
    }

    public GF2Matrix(int n, char c, SecureRandom secureRandom) {
        if (n <= 0) {
            throw new ArithmeticException("Size of matrix is non-positive.");
        }
        switch (c) {
            case 'Z': {
                this.assignZeroMatrix(n, n);
                break;
            }
            case 'I': {
                this.assignUnitMatrix(n);
                break;
            }
            case 'L': {
                this.assignRandomLowerTriangularMatrix(n, secureRandom);
                break;
            }
            case 'U': {
                this.assignRandomUpperTriangularMatrix(n, secureRandom);
                break;
            }
            case 'R': {
                this.assignRandomRegularMatrix(n, secureRandom);
                break;
            }
            default: {
                throw new ArithmeticException("Unknown matrix type.");
            }
        }
    }

    public GF2Matrix(GF2Matrix gF2Matrix) {
        this.numColumns = gF2Matrix.getNumColumns();
        this.numRows = gF2Matrix.getNumRows();
        this.length = gF2Matrix.length;
        this.matrix = new int[gF2Matrix.matrix.length][];
        int n = 0;
        while (n < this.matrix.length) {
            this.matrix[n] = IntUtils.clone(gF2Matrix.matrix[n]);
            ++n;
        }
    }

    private GF2Matrix(int n, int n2) {
        if (n2 <= 0 || n <= 0) {
            throw new ArithmeticException("size of matrix is non-positive");
        }
        this.assignZeroMatrix(n, n2);
    }

    private void assignZeroMatrix(int n, int n2) {
        this.numRows = n;
        this.numColumns = n2;
        this.length = n2 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int n3 = 0;
        while (n3 < this.numRows) {
            int n4 = 0;
            while (n4 < this.length) {
                this.matrix[n3][n4] = 0;
                ++n4;
            }
            ++n3;
        }
    }

    private void assignUnitMatrix(int n) {
        int n2;
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int n3 = 0;
        while (n3 < this.numRows) {
            n2 = 0;
            while (n2 < this.length) {
                this.matrix[n3][n2] = 0;
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.numRows) {
            int n4 = n2 & 0x1F;
            this.matrix[n2][n2 >>> 5] = 1 << n4;
            ++n2;
        }
    }

    private void assignRandomLowerTriangularMatrix(int n, SecureRandom secureRandom) {
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = n2 >>> 5;
            int n4 = n2 & 0x1F;
            int n5 = 31 - n4;
            n4 = 1 << n4;
            int n6 = 0;
            while (n6 < n3) {
                this.matrix[n2][n6] = secureRandom.nextInt();
                ++n6;
            }
            this.matrix[n2][n3] = secureRandom.nextInt() >>> n5 | n4;
            int n7 = n3 + 1;
            while (n7 < this.length) {
                this.matrix[n2][n7] = 0;
                ++n7;
            }
            ++n2;
        }
    }

    private void assignRandomUpperTriangularMatrix(int n, SecureRandom secureRandom) {
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int n2 = n & 0x1F;
        int n3 = n2 == 0 ? -1 : (1 << n2) - 1;
        int n4 = 0;
        while (n4 < this.numRows) {
            int n5;
            int n6 = n4 >>> 5;
            int n7 = n5 = n4 & 0x1F;
            n5 = 1 << n5;
            int n8 = 0;
            while (n8 < n6) {
                this.matrix[n4][n8] = 0;
                ++n8;
            }
            this.matrix[n4][n6] = secureRandom.nextInt() << n7 | n5;
            int n9 = n6 + 1;
            while (n9 < this.length) {
                this.matrix[n4][n9] = secureRandom.nextInt();
                ++n9;
            }
            int[] nArray = this.matrix[n4];
            int n10 = this.length - 1;
            nArray[n10] = nArray[n10] & n3;
            ++n4;
        }
    }

    private void assignRandomRegularMatrix(int n, SecureRandom secureRandom) {
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        GF2Matrix gF2Matrix = new GF2Matrix(n, 'L', secureRandom);
        GF2Matrix gF2Matrix2 = new GF2Matrix(n, 'U', secureRandom);
        GF2Matrix gF2Matrix3 = (GF2Matrix)gF2Matrix.rightMultiply(gF2Matrix2);
        Permutation permutation = new Permutation(n, secureRandom);
        int[] nArray = permutation.getVector();
        int n2 = 0;
        while (n2 < n) {
            System.arraycopy(gF2Matrix3.matrix[n2], 0, this.matrix[nArray[n2]], 0, this.length);
            ++n2;
        }
    }

    public static GF2Matrix[] createRandomRegularMatrixAndItsInverse(int n, SecureRandom secureRandom) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        GF2Matrix[] gF2MatrixArray = new GF2Matrix[2];
        int n7 = n + 31 >> 5;
        GF2Matrix gF2Matrix = new GF2Matrix(n, 'L', secureRandom);
        GF2Matrix gF2Matrix2 = new GF2Matrix(n, 'U', secureRandom);
        GF2Matrix gF2Matrix3 = (GF2Matrix)gF2Matrix.rightMultiply(gF2Matrix2);
        Permutation permutation = new Permutation(n, secureRandom);
        int[] nArray = permutation.getVector();
        int[][] nArray2 = new int[n][n7];
        int n8 = 0;
        while (n8 < n) {
            System.arraycopy(gF2Matrix3.matrix[nArray[n8]], 0, nArray2[n8], 0, n7);
            ++n8;
        }
        gF2MatrixArray[0] = new GF2Matrix(n, nArray2);
        GF2Matrix gF2Matrix4 = new GF2Matrix(n, 'I');
        int n9 = 0;
        while (n9 < n) {
            int n10 = n9 & 0x1F;
            n6 = n9 >>> 5;
            n5 = 1 << n10;
            n4 = n9 + 1;
            while (n4 < n) {
                n3 = gF2Matrix.matrix[n4][n6] & n5;
                if (n3 != 0) {
                    n2 = 0;
                    while (n2 <= n6) {
                        int[] nArray3 = gF2Matrix4.matrix[n4];
                        int n11 = n2;
                        nArray3[n11] = nArray3[n11] ^ gF2Matrix4.matrix[n9][n2];
                        ++n2;
                    }
                }
                ++n4;
            }
            ++n9;
        }
        GF2Matrix gF2Matrix5 = new GF2Matrix(n, 'I');
        n6 = n - 1;
        while (n6 >= 0) {
            n5 = n6 & 0x1F;
            n4 = n6 >>> 5;
            n3 = 1 << n5;
            n2 = n6 - 1;
            while (n2 >= 0) {
                int n12 = gF2Matrix2.matrix[n2][n4] & n3;
                if (n12 != 0) {
                    int n13 = n4;
                    while (n13 < n7) {
                        int[] nArray4 = gF2Matrix5.matrix[n2];
                        int n14 = n13;
                        nArray4[n14] = nArray4[n14] ^ gF2Matrix5.matrix[n6][n13];
                        ++n13;
                    }
                }
                --n2;
            }
            --n6;
        }
        gF2MatrixArray[1] = (GF2Matrix)gF2Matrix5.rightMultiply(gF2Matrix4.rightMultiply(permutation));
        return gF2MatrixArray;
    }

    public int[][] getIntArray() {
        return this.matrix;
    }

    public int getLength() {
        return this.length;
    }

    public int[] getRow(int n) {
        return this.matrix[n];
    }

    public byte[] getEncoded() {
        int n = this.numColumns + 7 >>> 3;
        n *= this.numRows;
        byte[] byArray = new byte[n += 8];
        LittleEndianConversions.I2OSP(this.numRows, byArray, 0);
        LittleEndianConversions.I2OSP(this.numColumns, byArray, 4);
        int n2 = this.numColumns >>> 5;
        int n3 = this.numColumns & 0x1F;
        int n4 = 8;
        int n5 = 0;
        while (n5 < this.numRows) {
            int n6 = 0;
            while (n6 < n2) {
                LittleEndianConversions.I2OSP(this.matrix[n5][n6], byArray, n4);
                ++n6;
                n4 += 4;
            }
            int n7 = 0;
            while (n7 < n3) {
                byArray[n4++] = (byte)(this.matrix[n5][n2] >>> n7 & 0xFF);
                n7 += 8;
            }
            ++n5;
        }
        return byArray;
    }

    public double getHammingWeight() {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.numColumns & 0x1F;
        int n2 = n == 0 ? this.length : this.length - 1;
        int n3 = 0;
        while (n3 < this.numRows) {
            int n4;
            int n5;
            int n6;
            int n7 = 0;
            while (n7 < n2) {
                n6 = this.matrix[n3][n7];
                n5 = 0;
                while (n5 < 32) {
                    n4 = n6 >>> n5 & 1;
                    d += (double)n4;
                    d2 += 1.0;
                    ++n5;
                }
                ++n7;
            }
            n6 = this.matrix[n3][this.length - 1];
            n5 = 0;
            while (n5 < n) {
                n4 = n6 >>> n5 & 1;
                d += (double)n4;
                d2 += 1.0;
                ++n5;
            }
            ++n3;
        }
        return d / d2;
    }

    public boolean isZero() {
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.length) {
                if (this.matrix[n][n2] != 0) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public GF2Matrix getLeftSubMatrix() {
        if (this.numColumns <= this.numRows) {
            throw new ArithmeticException("empty submatrix");
        }
        int n = this.numRows + 31 >> 5;
        int[][] nArray = new int[this.numRows][n];
        int n2 = (1 << (this.numRows & 0x1F)) - 1;
        if (n2 == 0) {
            n2 = -1;
        }
        int n3 = this.numRows - 1;
        while (n3 >= 0) {
            System.arraycopy(this.matrix[n3], 0, nArray[n3], 0, n);
            int[] nArray2 = nArray[n3];
            int n4 = n - 1;
            nArray2[n4] = nArray2[n4] & n2;
            --n3;
        }
        return new GF2Matrix(this.numRows, nArray);
    }

    public GF2Matrix extendLeftCompactForm() {
        int n = this.numColumns + this.numRows;
        GF2Matrix gF2Matrix = new GF2Matrix(this.numRows, n);
        int n2 = this.numRows - 1 + this.numColumns;
        int n3 = this.numRows - 1;
        while (n3 >= 0) {
            System.arraycopy(this.matrix[n3], 0, gF2Matrix.matrix[n3], 0, this.length);
            int[] nArray = gF2Matrix.matrix[n3];
            int n4 = n2 >> 5;
            nArray[n4] = nArray[n4] | 1 << (n2 & 0x1F);
            --n3;
            --n2;
        }
        return gF2Matrix;
    }

    public GF2Matrix getRightSubMatrix() {
        if (this.numColumns <= this.numRows) {
            throw new ArithmeticException("empty submatrix");
        }
        int n = this.numRows >> 5;
        int n2 = this.numRows & 0x1F;
        GF2Matrix gF2Matrix = new GF2Matrix(this.numRows, this.numColumns - this.numRows);
        int n3 = this.numRows - 1;
        while (n3 >= 0) {
            if (n2 != 0) {
                int n4 = n;
                int n5 = 0;
                while (n5 < gF2Matrix.length - 1) {
                    gF2Matrix.matrix[n3][n5] = this.matrix[n3][n4++] >>> n2 | this.matrix[n3][n4] << 32 - n2;
                    ++n5;
                }
                gF2Matrix.matrix[n3][gF2Matrix.length - 1] = this.matrix[n3][n4++] >>> n2;
                if (n4 < this.length) {
                    int[] nArray = gF2Matrix.matrix[n3];
                    int n6 = gF2Matrix.length - 1;
                    nArray[n6] = nArray[n6] | this.matrix[n3][n4] << 32 - n2;
                }
            } else {
                System.arraycopy(this.matrix[n3], n, gF2Matrix.matrix[n3], 0, gF2Matrix.length);
            }
            --n3;
        }
        return gF2Matrix;
    }

    public GF2Matrix extendRightCompactForm() {
        GF2Matrix gF2Matrix = new GF2Matrix(this.numRows, this.numRows + this.numColumns);
        int n = this.numRows >> 5;
        int n2 = this.numRows & 0x1F;
        int n3 = this.numRows - 1;
        while (n3 >= 0) {
            int[] nArray = gF2Matrix.matrix[n3];
            int n4 = n3 >> 5;
            nArray[n4] = nArray[n4] | 1 << (n3 & 0x1F);
            if (n2 != 0) {
                int n5;
                int n6 = n;
                int n7 = 0;
                while (n7 < this.length - 1) {
                    n5 = this.matrix[n3][n7];
                    int[] nArray2 = gF2Matrix.matrix[n3];
                    int n8 = n6++;
                    nArray2[n8] = nArray2[n8] | n5 << n2;
                    int[] nArray3 = gF2Matrix.matrix[n3];
                    int n9 = n6;
                    nArray3[n9] = nArray3[n9] | n5 >>> 32 - n2;
                    ++n7;
                }
                n5 = this.matrix[n3][this.length - 1];
                int[] nArray4 = gF2Matrix.matrix[n3];
                int n10 = n6++;
                nArray4[n10] = nArray4[n10] | n5 << n2;
                if (n6 < gF2Matrix.length) {
                    int[] nArray5 = gF2Matrix.matrix[n3];
                    int n11 = n6;
                    nArray5[n11] = nArray5[n11] | n5 >>> 32 - n2;
                }
            } else {
                System.arraycopy(this.matrix[n3], 0, gF2Matrix.matrix[n3], n, this.length);
            }
            --n3;
        }
        return gF2Matrix;
    }

    public Matrix computeTranspose() {
        int[][] nArray = new int[this.numColumns][this.numRows + 31 >>> 5];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numColumns) {
                int n3 = n2 >>> 5;
                int n4 = n2 & 0x1F;
                int n5 = this.matrix[n][n3] >>> n4 & 1;
                int n6 = n >>> 5;
                int n7 = n & 0x1F;
                if (n5 == 1) {
                    int[] nArray2 = nArray[n2];
                    int n8 = n6;
                    nArray2[n8] = nArray2[n8] | 1 << n7;
                }
                ++n2;
            }
            ++n;
        }
        return new GF2Matrix(this.numRows, nArray);
    }

    public Matrix computeInverse() {
        int n;
        int n2;
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] nArray = new int[this.numRows][this.length];
        int n3 = this.numRows - 1;
        while (n3 >= 0) {
            nArray[n3] = IntUtils.clone(this.matrix[n3]);
            --n3;
        }
        int[][] nArray2 = new int[this.numRows][this.length];
        int n4 = this.numRows - 1;
        while (n4 >= 0) {
            n2 = n4 >> 5;
            n = n4 & 0x1F;
            nArray2[n4][n2] = 1 << n;
            --n4;
        }
        n2 = 0;
        while (n2 < this.numRows) {
            int n5;
            n = n2 >> 5;
            int n6 = 1 << (n2 & 0x1F);
            if ((nArray[n2][n] & n6) == 0) {
                n5 = 0;
                int n7 = n2 + 1;
                while (n7 < this.numRows) {
                    if ((nArray[n7][n] & n6) != 0) {
                        n5 = 1;
                        GF2Matrix.swapRows(nArray, n2, n7);
                        GF2Matrix.swapRows(nArray2, n2, n7);
                        n7 = this.numRows;
                    }
                    ++n7;
                }
                if (n5 == 0) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            n5 = this.numRows - 1;
            while (n5 >= 0) {
                if (n5 != n2 && (nArray[n5][n] & n6) != 0) {
                    GF2Matrix.addToRow(nArray[n2], nArray[n5], n);
                    GF2Matrix.addToRow(nArray2[n2], nArray2[n5], 0);
                }
                --n5;
            }
            ++n2;
        }
        return new GF2Matrix(this.numColumns, nArray2);
    }

    public Matrix leftMultiply(Permutation permutation) {
        int[] nArray = permutation.getVector();
        if (nArray.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[][] nArrayArray = new int[this.numRows][];
        int n = this.numRows - 1;
        while (n >= 0) {
            nArrayArray[n] = IntUtils.clone(this.matrix[nArray[n]]);
            --n;
        }
        return new GF2Matrix(this.numRows, nArrayArray);
    }

    public Vector leftMultiply(Vector vector) {
        int n;
        int n2;
        int n3;
        if (!(vector instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vector.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = ((GF2Vector)vector).getVecArray();
        int[] nArray2 = new int[this.length];
        int n4 = this.numRows >> 5;
        int n5 = 1 << (this.numRows & 0x1F);
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            n3 = 1;
            do {
                if ((n2 = nArray[n7] & n3) != 0) {
                    n = 0;
                    while (n < this.length) {
                        int n8 = n;
                        nArray2[n8] = nArray2[n8] ^ this.matrix[n6][n];
                        ++n;
                    }
                }
                ++n6;
            } while ((n3 <<= 1) != 0);
            ++n7;
        }
        n3 = 1;
        while (n3 != n5) {
            n2 = nArray[n4] & n3;
            if (n2 != 0) {
                n = 0;
                while (n < this.length) {
                    int n9 = n;
                    nArray2[n9] = nArray2[n9] ^ this.matrix[n6][n];
                    ++n;
                }
            }
            ++n6;
            n3 <<= 1;
        }
        return new GF2Vector(nArray2, this.numColumns);
    }

    public Vector leftMultiplyLeftCompactForm(Vector vector) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (!(vector instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vector.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = ((GF2Vector)vector).getVecArray();
        int[] nArray2 = new int[this.numRows + this.numColumns + 31 >>> 5];
        int n6 = this.numRows >>> 5;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n6) {
            n5 = 1;
            do {
                if ((n4 = nArray[n8] & n5) != 0) {
                    n3 = 0;
                    while (n3 < this.length) {
                        int n9 = n3;
                        nArray2[n9] = nArray2[n9] ^ this.matrix[n7][n3];
                        ++n3;
                    }
                    n2 = this.numColumns + n7 >>> 5;
                    n = this.numColumns + n7 & 0x1F;
                    int n10 = n2;
                    nArray2[n10] = nArray2[n10] | 1 << n;
                }
                ++n7;
            } while ((n5 <<= 1) != 0);
            ++n8;
        }
        n5 = 1 << (this.numRows & 0x1F);
        n4 = 1;
        while (n4 != n5) {
            n3 = nArray[n6] & n4;
            if (n3 != 0) {
                n2 = 0;
                while (n2 < this.length) {
                    int n11 = n2;
                    nArray2[n11] = nArray2[n11] ^ this.matrix[n7][n2];
                    ++n2;
                }
                n = this.numColumns + n7 >>> 5;
                int n12 = this.numColumns + n7 & 0x1F;
                int n13 = n;
                nArray2[n13] = nArray2[n13] | 1 << n12;
            }
            ++n7;
            n4 <<= 1;
        }
        return new GF2Vector(nArray2, this.numRows + this.numColumns);
    }

    public Matrix rightMultiply(Matrix matrix) {
        if (!(matrix instanceof GF2Matrix)) {
            throw new ArithmeticException("matrix is not defined over GF(2)");
        }
        if (matrix.numRows != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Matrix gF2Matrix = (GF2Matrix)matrix;
        GF2Matrix gF2Matrix2 = new GF2Matrix(this.numRows, matrix.numColumns);
        int n = this.numColumns & 0x1F;
        int n2 = n == 0 ? this.length : this.length - 1;
        int n3 = 0;
        while (n3 < this.numRows) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n2) {
                n7 = this.matrix[n3][n9];
                n6 = 0;
                while (n6 < 32) {
                    n5 = n7 & 1 << n6;
                    if (n5 != 0) {
                        n4 = 0;
                        while (n4 < gF2Matrix.length) {
                            int[] nArray = gF2Matrix2.matrix[n3];
                            int n10 = n4;
                            nArray[n10] = nArray[n10] ^ gF2Matrix.matrix[n8][n4];
                            ++n4;
                        }
                    }
                    ++n8;
                    ++n6;
                }
                ++n9;
            }
            n7 = this.matrix[n3][this.length - 1];
            n6 = 0;
            while (n6 < n) {
                n5 = n7 & 1 << n6;
                if (n5 != 0) {
                    n4 = 0;
                    while (n4 < gF2Matrix.length) {
                        int[] nArray = gF2Matrix2.matrix[n3];
                        int n11 = n4;
                        nArray[n11] = nArray[n11] ^ gF2Matrix.matrix[n8][n4];
                        ++n4;
                    }
                }
                ++n8;
                ++n6;
            }
            ++n3;
        }
        return gF2Matrix2;
    }

    public Matrix rightMultiply(Permutation permutation) {
        int[] nArray = permutation.getVector();
        if (nArray.length != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Matrix gF2Matrix = new GF2Matrix(this.numRows, this.numColumns);
        int n = this.numColumns - 1;
        while (n >= 0) {
            int n2 = n >>> 5;
            int n3 = n & 0x1F;
            int n4 = nArray[n] >>> 5;
            int n5 = nArray[n] & 0x1F;
            int n6 = this.numRows - 1;
            while (n6 >= 0) {
                int[] nArray2 = gF2Matrix.matrix[n6];
                int n7 = n2;
                nArray2[n7] = nArray2[n7] | (this.matrix[n6][n4] >>> n5 & 1) << n3;
                --n6;
            }
            --n;
        }
        return gF2Matrix;
    }

    public Vector rightMultiply(Vector vector) {
        if (!(vector instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vector.length != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = ((GF2Vector)vector).getVecArray();
        int[] nArray2 = new int[this.numRows + 31 >>> 5];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.length) {
                n2 ^= this.matrix[n][n3] & nArray[n3];
                ++n3;
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < 32) {
                n4 ^= n2 >>> n5 & 1;
                ++n5;
            }
            if (n4 == 1) {
                int n6 = n >>> 5;
                nArray2[n6] = nArray2[n6] | 1 << (n & 0x1F);
            }
            ++n;
        }
        return new GF2Vector(nArray2, this.numRows);
    }

    public Vector rightMultiplyRightCompactForm(Vector vector) {
        if (!(vector instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vector.length != this.numColumns + this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = ((GF2Vector)vector).getVecArray();
        int[] nArray2 = new int[this.numRows + 31 >>> 5];
        int n = this.numRows >> 5;
        int n2 = this.numRows & 0x1F;
        int n3 = 0;
        while (n3 < this.numRows) {
            int n4;
            int n5;
            int n6 = nArray[n3 >> 5] >>> (n3 & 0x1F) & 1;
            int n7 = n;
            if (n2 != 0) {
                n5 = 0;
                n4 = 0;
                while (n4 < this.length - 1) {
                    n5 = nArray[n7++] >>> n2 | nArray[n7] << 32 - n2;
                    n6 ^= this.matrix[n3][n4] & n5;
                    ++n4;
                }
                n5 = nArray[n7++] >>> n2;
                if (n7 < nArray.length) {
                    n5 |= nArray[n7] << 32 - n2;
                }
                n6 ^= this.matrix[n3][this.length - 1] & n5;
            } else {
                n5 = 0;
                while (n5 < this.length) {
                    n6 ^= this.matrix[n3][n5] & nArray[n7++];
                    ++n5;
                }
            }
            n5 = 0;
            n4 = 0;
            while (n4 < 32) {
                n5 ^= n6 & 1;
                n6 >>>= 1;
                ++n4;
            }
            if (n5 == 1) {
                int n8 = n3 >> 5;
                nArray2[n8] = nArray2[n8] | 1 << (n3 & 0x1F);
            }
            ++n3;
        }
        return new GF2Vector(nArray2, this.numRows);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GF2Matrix)) {
            return false;
        }
        GF2Matrix gF2Matrix = (GF2Matrix)object;
        if (this.numRows != gF2Matrix.numRows || this.numColumns != gF2Matrix.numColumns || this.length != gF2Matrix.length) {
            return false;
        }
        int n = 0;
        while (n < this.numRows) {
            if (!IntUtils.equals(this.matrix[n], gF2Matrix.matrix[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = (this.numRows * 31 + this.numColumns) * 31 + this.length;
        int n2 = 0;
        while (n2 < this.numRows) {
            n = n * 31 + Arrays.hashCode(this.matrix[n2]);
            ++n2;
        }
        return n;
    }

    public String toString() {
        int n = this.numColumns & 0x1F;
        int n2 = n == 0 ? this.length : this.length - 1;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < this.numRows) {
            int n4;
            int n5;
            int n6;
            stringBuffer.append(n3 + ": ");
            int n7 = 0;
            while (n7 < n2) {
                n6 = this.matrix[n3][n7];
                n5 = 0;
                while (n5 < 32) {
                    n4 = n6 >>> n5 & 1;
                    if (n4 == 0) {
                        stringBuffer.append('0');
                    } else {
                        stringBuffer.append('1');
                    }
                    ++n5;
                }
                stringBuffer.append(' ');
                ++n7;
            }
            n6 = this.matrix[n3][this.length - 1];
            n5 = 0;
            while (n5 < n) {
                n4 = n6 >>> n5 & 1;
                if (n4 == 0) {
                    stringBuffer.append('0');
                } else {
                    stringBuffer.append('1');
                }
                ++n5;
            }
            stringBuffer.append('\n');
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static void swapRows(int[][] nArray, int n, int n2) {
        int[] nArray2 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = nArray2;
    }

    private static void addToRow(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray2.length - 1;
        while (n2 >= n) {
            nArray2[n2] = nArray[n2] ^ nArray2[n2];
            --n2;
        }
    }
}

