/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.math.linearalgebra.GFElement;
import org.bouncycastle.util.Arrays;

public class GF2nONBElement
extends GF2nElement {
    private static final long[] mBitmask = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    private static final long[] mMaxmask = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};
    private static final int[] mIBY64 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private long[] mPol;

    public GF2nONBElement(GF2nONBField gF2nONBField, SecureRandom secureRandom) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = new long[this.mLength];
        if (this.mLength > 1) {
            int n = 0;
            while (n < this.mLength - 1) {
                this.mPol[n] = secureRandom.nextLong();
                ++n;
            }
            long l = secureRandom.nextLong();
            this.mPol[this.mLength - 1] = l >>> 64 - this.mBit;
        } else {
            this.mPol[0] = secureRandom.nextLong();
            this.mPol[0] = this.mPol[0] >>> 64 - this.mBit;
        }
    }

    public GF2nONBElement(GF2nONBField gF2nONBField, byte[] byArray) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(byArray);
    }

    public GF2nONBElement(GF2nONBField gF2nONBField, BigInteger bigInteger) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(bigInteger);
    }

    private GF2nONBElement(GF2nONBField gF2nONBField, long[] lArray) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = lArray;
    }

    public GF2nONBElement(GF2nONBElement gF2nONBElement) {
        this.mField = gF2nONBElement.mField;
        this.mDegree = this.mField.getDegree();
        this.mLength = ((GF2nONBField)this.mField).getONBLength();
        this.mBit = ((GF2nONBField)this.mField).getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(gF2nONBElement.getElement());
    }

    public Object clone() {
        return new GF2nONBElement(this);
    }

    public static GF2nONBElement ZERO(GF2nONBField gF2nONBField) {
        long[] lArray = new long[gF2nONBField.getONBLength()];
        return new GF2nONBElement(gF2nONBField, lArray);
    }

    public static GF2nONBElement ONE(GF2nONBField gF2nONBField) {
        int n = gF2nONBField.getONBLength();
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n - 1) {
            lArray[n2] = -1L;
            ++n2;
        }
        lArray[n - 1] = mMaxmask[gF2nONBField.getONBBit() - 1];
        return new GF2nONBElement(gF2nONBField, lArray);
    }

    void assignZero() {
        this.mPol = new long[this.mLength];
    }

    void assignOne() {
        int n = 0;
        while (n < this.mLength - 1) {
            this.mPol[n] = -1L;
            ++n;
        }
        this.mPol[this.mLength - 1] = mMaxmask[this.mBit - 1];
    }

    private void assign(BigInteger bigInteger) {
        this.assign(bigInteger.toByteArray());
    }

    private void assign(long[] lArray) {
        System.arraycopy(lArray, 0, this.mPol, 0, this.mLength);
    }

    private void assign(byte[] byArray) {
        this.mPol = new long[this.mLength];
        int n = 0;
        while (n < byArray.length) {
            int n2 = n >>> 3;
            this.mPol[n2] = this.mPol[n2] | ((long)byArray[byArray.length - 1 - n] & 0xFFL) << ((n & 7) << 3);
            ++n;
        }
    }

    public boolean isZero() {
        boolean bl = true;
        int n = 0;
        while (n < this.mLength && bl) {
            bl = bl && (this.mPol[n] & 0xFFFFFFFFFFFFFFFFL) == 0L;
            ++n;
        }
        return bl;
    }

    public boolean isOne() {
        boolean bl = true;
        int n = 0;
        while (n < this.mLength - 1 && bl) {
            bl = bl && (this.mPol[n] & 0xFFFFFFFFFFFFFFFFL) == -1L;
            ++n;
        }
        if (bl) {
            bl = bl && (this.mPol[this.mLength - 1] & mMaxmask[this.mBit - 1]) == mMaxmask[this.mBit - 1];
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GF2nONBElement)) {
            return false;
        }
        GF2nONBElement gF2nONBElement = (GF2nONBElement)object;
        int n = 0;
        while (n < this.mLength) {
            if (this.mPol[n] != gF2nONBElement.mPol[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mPol);
    }

    public boolean testRightmostBit() {
        return (this.mPol[this.mLength - 1] & mBitmask[this.mBit - 1]) != 0L;
    }

    boolean testBit(int n) {
        if (n < 0 || n > this.mDegree) {
            return false;
        }
        long l = this.mPol[n >>> 6] & mBitmask[n & 0x3F];
        return l != 0L;
    }

    private long[] getElement() {
        long[] lArray = new long[this.mPol.length];
        System.arraycopy(this.mPol, 0, lArray, 0, this.mPol.length);
        return lArray;
    }

    private long[] getElementReverseOrder() {
        long[] lArray = new long[this.mPol.length];
        int n = 0;
        while (n < this.mDegree) {
            if (this.testBit(this.mDegree - n - 1)) {
                int n2 = n >>> 6;
                lArray[n2] = lArray[n2] | mBitmask[n & 0x3F];
            }
            ++n;
        }
        return lArray;
    }

    void reverseOrder() {
        this.mPol = this.getElementReverseOrder();
    }

    public GFElement add(GFElement gFElement) throws RuntimeException {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.addToThis(gFElement);
        return gF2nONBElement;
    }

    public void addToThis(GFElement gFElement) throws RuntimeException {
        if (!(gFElement instanceof GF2nONBElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nONBElement)gFElement).mField)) {
            throw new RuntimeException();
        }
        int n = 0;
        while (n < this.mLength) {
            int n2 = n;
            this.mPol[n2] = this.mPol[n2] ^ ((GF2nONBElement)gFElement).mPol[n];
            ++n;
        }
    }

    public GF2nElement increase() {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.increaseThis();
        return gF2nONBElement;
    }

    public void increaseThis() {
        this.addToThis(GF2nONBElement.ONE((GF2nONBField)this.mField));
    }

    public GFElement multiply(GFElement gFElement) throws RuntimeException {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.multiplyThisBy(gFElement);
        return gF2nONBElement;
    }

    public void multiplyThisBy(GFElement gFElement) throws RuntimeException {
        if (!(gFElement instanceof GF2nONBElement)) {
            throw new RuntimeException("The elements have different representation: not yet implemented");
        }
        if (!this.mField.equals(((GF2nONBElement)gFElement).mField)) {
            throw new RuntimeException();
        }
        if (this.equals(gFElement)) {
            this.squareThis();
        } else {
            long[] lArray = this.mPol;
            long[] lArray2 = ((GF2nONBElement)gFElement).mPol;
            long[] lArray3 = new long[this.mLength];
            int[][] nArray = ((GF2nONBField)this.mField).mMult;
            int n = this.mLength - 1;
            int n2 = this.mBit - 1;
            boolean bl = false;
            long l = mBitmask[63];
            long l2 = mBitmask[n2];
            int n3 = 0;
            while (n3 < this.mDegree) {
                boolean bl2;
                int n4;
                int n5;
                bl = false;
                int n6 = 0;
                while (n6 < this.mDegree) {
                    n5 = mIBY64[n6];
                    n4 = n6 & 0x3F;
                    int n7 = mIBY64[nArray[n6][0]];
                    int n8 = nArray[n6][0] & 0x3F;
                    if ((lArray[n5] & mBitmask[n4]) != 0L) {
                        if ((lArray2[n7] & mBitmask[n8]) != 0L) {
                            bl ^= true;
                        }
                        if (nArray[n6][1] != -1 && (lArray2[n7 = mIBY64[nArray[n6][1]]] & mBitmask[n8 = nArray[n6][1] & 0x3F]) != 0L) {
                            bl ^= true;
                        }
                    }
                    ++n6;
                }
                n5 = mIBY64[n3];
                n4 = n3 & 0x3F;
                if (bl) {
                    int n9 = n5;
                    lArray3[n9] = lArray3[n9] ^ mBitmask[n4];
                }
                if (this.mLength > 1) {
                    boolean bl3;
                    bl2 = (lArray[n] & 1L) == 1L;
                    int n10 = n - 1;
                    while (n10 >= 0) {
                        bl3 = (lArray[n10] & 1L) != 0L;
                        lArray[n10] = lArray[n10] >>> 1;
                        if (bl2) {
                            int n11 = n10;
                            lArray[n11] = lArray[n11] ^ l;
                        }
                        bl2 = bl3;
                        --n10;
                    }
                    lArray[n] = lArray[n] >>> 1;
                    if (bl2) {
                        int n12 = n;
                        lArray[n12] = lArray[n12] ^ l2;
                    }
                    bl2 = (lArray2[n] & 1L) == 1L;
                    int n13 = n - 1;
                    while (n13 >= 0) {
                        bl3 = (lArray2[n13] & 1L) != 0L;
                        lArray2[n13] = lArray2[n13] >>> 1;
                        if (bl2) {
                            int n14 = n13;
                            lArray2[n14] = lArray2[n14] ^ l;
                        }
                        bl2 = bl3;
                        --n13;
                    }
                    lArray2[n] = lArray2[n] >>> 1;
                    if (bl2) {
                        int n15 = n;
                        lArray2[n15] = lArray2[n15] ^ l2;
                    }
                } else {
                    bl2 = (lArray[0] & 1L) == 1L;
                    lArray[0] = lArray[0] >>> 1;
                    if (bl2) {
                        lArray[0] = lArray[0] ^ l2;
                    }
                    bl2 = (lArray2[0] & 1L) == 1L;
                    lArray2[0] = lArray2[0] >>> 1;
                    if (bl2) {
                        lArray2[0] = lArray2[0] ^ l2;
                    }
                }
                ++n3;
            }
            this.assign(lArray3);
        }
    }

    public GF2nElement square() {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.squareThis();
        return gF2nONBElement;
    }

    public void squareThis() {
        boolean bl;
        long[] lArray = this.getElement();
        int n = this.mLength - 1;
        int n2 = this.mBit - 1;
        long l = mBitmask[63];
        boolean bl2 = (lArray[n] & mBitmask[n2]) != 0L;
        int n3 = 0;
        while (n3 < n) {
            bl = (lArray[n3] & l) != 0L;
            lArray[n3] = lArray[n3] << 1;
            if (bl2) {
                int n4 = n3;
                lArray[n4] = lArray[n4] ^ 1L;
            }
            bl2 = bl;
            ++n3;
        }
        bl = (lArray[n] & mBitmask[n2]) != 0L;
        lArray[n] = lArray[n] << 1;
        if (bl2) {
            int n5 = n;
            lArray[n5] = lArray[n5] ^ 1L;
        }
        if (bl) {
            int n6 = n;
            lArray[n6] = lArray[n6] ^ mBitmask[n2 + 1];
        }
        this.assign(lArray);
    }

    public GFElement invert() throws ArithmeticException {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.invertThis();
        return gF2nONBElement;
    }

    public void invertThis() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        int n = 31;
        boolean bl = false;
        while (!bl && n >= 0) {
            if (((long)(this.mDegree - 1) & mBitmask[n]) != 0L) {
                bl = true;
            }
            --n;
        }
        GF2nElement gF2nElement = GF2nONBElement.ZERO((GF2nONBField)this.mField);
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        int n2 = 1;
        int n3 = ++n - 1;
        while (n3 >= 0) {
            gF2nElement = (GF2nElement)((GF2nElement)gF2nONBElement).clone();
            int n4 = 1;
            while (n4 <= n2) {
                gF2nElement.squareThis();
                ++n4;
            }
            ((GF2nElement)gF2nONBElement).multiplyThisBy(gF2nElement);
            n2 <<= 1;
            if (((long)(this.mDegree - 1) & mBitmask[n3]) != 0L) {
                ((GF2nElement)gF2nONBElement).squareThis();
                ((GF2nElement)gF2nONBElement).multiplyThisBy(this);
                ++n2;
            }
            --n3;
        }
        ((GF2nElement)gF2nONBElement).squareThis();
    }

    public GF2nElement squareRoot() {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.squareRootThis();
        return gF2nONBElement;
    }

    public void squareRootThis() {
        long[] lArray = this.getElement();
        int n = this.mLength - 1;
        int n2 = this.mBit - 1;
        long l = mBitmask[63];
        boolean bl = (lArray[0] & 1L) != 0L;
        int n3 = n;
        while (n3 >= 0) {
            boolean bl2 = (lArray[n3] & 1L) != 0L;
            lArray[n3] = lArray[n3] >>> 1;
            if (bl) {
                if (n3 == n) {
                    int n4 = n3;
                    lArray[n4] = lArray[n4] ^ mBitmask[n2];
                } else {
                    int n5 = n3;
                    lArray[n5] = lArray[n5] ^ l;
                }
            }
            bl = bl2;
            --n3;
        }
        this.assign(lArray);
    }

    public int trace() {
        int n;
        int n2 = 0;
        int n3 = this.mLength - 1;
        int n4 = 0;
        while (n4 < n3) {
            n = 0;
            while (n < 64) {
                if ((this.mPol[n4] & mBitmask[n]) != 0L) {
                    n2 ^= 1;
                }
                ++n;
            }
            ++n4;
        }
        n = this.mBit;
        int n5 = 0;
        while (n5 < n) {
            if ((this.mPol[n3] & mBitmask[n5]) != 0L) {
                n2 ^= 1;
            }
            ++n5;
        }
        return n2;
    }

    public GF2nElement solveQuadraticEquation() throws RuntimeException {
        if (this.trace() == 1) {
            throw new RuntimeException();
        }
        long l = mBitmask[63];
        long l2 = 0L;
        long l3 = 1L;
        long[] lArray = new long[this.mLength];
        long l4 = 0L;
        int n = 1;
        int n2 = 0;
        while (n2 < this.mLength - 1) {
            n = 1;
            while (n < 64) {
                if (!((mBitmask[n] & this.mPol[n2]) != l2 && (l4 & mBitmask[n - 1]) != l2 || (this.mPol[n2] & mBitmask[n]) == l2 && (l4 & mBitmask[n - 1]) == l2)) {
                    l4 ^= mBitmask[n];
                }
                ++n;
            }
            lArray[n2] = l4;
            l4 = (l & l4) != l2 && (l3 & this.mPol[n2 + 1]) == l3 || (l & l4) == l2 && (l3 & this.mPol[n2 + 1]) == l2 ? l2 : l3;
            ++n2;
        }
        int n3 = this.mDegree & 0x3F;
        long l5 = this.mPol[this.mLength - 1];
        n = 1;
        while (n < n3) {
            if (!((mBitmask[n] & l5) != l2 && (mBitmask[n - 1] & l4) != l2 || (mBitmask[n] & l5) == l2 && (mBitmask[n - 1] & l4) == l2)) {
                l4 ^= mBitmask[n];
            }
            ++n;
        }
        lArray[this.mLength - 1] = l4;
        return new GF2nONBElement((GF2nONBField)this.mField, lArray);
    }

    public String toString() {
        return this.toString(16);
    }

    public String toString(int n) {
        String string;
        block5: {
            long[] lArray;
            block4: {
                string = "";
                lArray = this.getElement();
                int n2 = this.mBit;
                if (n != 2) break block4;
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    string = (lArray[lArray.length - 1] & 1L << n3) == 0L ? string + "0" : string + "1";
                    --n3;
                }
                int n4 = lArray.length - 2;
                while (n4 >= 0) {
                    int n5 = 63;
                    while (n5 >= 0) {
                        string = (lArray[n4] & mBitmask[n5]) == 0L ? string + "0" : string + "1";
                        --n5;
                    }
                    --n4;
                }
                break block5;
            }
            if (n != 16) break block5;
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            int n6 = lArray.length - 1;
            while (n6 >= 0) {
                string = string + cArray[(int)(lArray[n6] >>> 60) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 56) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 52) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 48) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 44) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 40) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 36) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 32) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 28) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 24) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 20) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 16) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 12) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 8) & 0xF];
                string = string + cArray[(int)(lArray[n6] >>> 4) & 0xF];
                string = string + cArray[(int)lArray[n6] & 0xF];
                string = string + " ";
                --n6;
            }
        }
        return string;
    }

    public BigInteger toFlexiBigInt() {
        return new BigInteger(1, this.toByteArray());
    }

    public byte[] toByteArray() {
        int n = (this.mDegree - 1 >> 3) + 1;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n - n2 - 1] = (byte)((this.mPol[n2 >>> 3] & 255L << ((n2 & 7) << 3)) >>> ((n2 & 7) << 3));
            ++n2;
        }
        return byArray;
    }
}

