/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import java.util.Random;
import java.util.Vector;
import org.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nField;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import org.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;

public class GF2nONBField
extends GF2nField {
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private int mType;
    int[][] mMult;

    public GF2nONBField(int n, SecureRandom secureRandom) throws RuntimeException {
        super(secureRandom);
        if (n < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = n;
        this.mLength = this.mDegree / 64;
        this.mBit = this.mDegree & 0x3F;
        if (this.mBit == 0) {
            this.mBit = 64;
        } else {
            ++this.mLength;
        }
        this.computeType();
        if (this.mType < 3) {
            this.mMult = new int[this.mDegree][2];
            int n2 = 0;
            while (n2 < this.mDegree) {
                this.mMult[n2][0] = -1;
                this.mMult[n2][1] = -1;
                ++n2;
            }
        } else {
            throw new RuntimeException("\nThe type of this field is " + this.mType);
        }
        this.computeMultMatrix();
        this.computeFieldPolynomial();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    int getONBLength() {
        return this.mLength;
    }

    int getONBBit() {
        return this.mBit;
    }

    protected GF2nElement getRandomRoot(GF2Polynomial gF2Polynomial) {
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(gF2Polynomial, this);
        int n = gF2nPolynomial.getDegree();
        while (n > 1) {
            GF2nPolynomial gF2nPolynomial2;
            int n2;
            do {
                GF2nONBElement gF2nONBElement = new GF2nONBElement(this, this.random);
                GF2nPolynomial gF2nPolynomial3 = new GF2nPolynomial(2, GF2nONBElement.ZERO(this));
                gF2nPolynomial3.set(1, gF2nONBElement);
                GF2nPolynomial gF2nPolynomial4 = new GF2nPolynomial(gF2nPolynomial3);
                int n3 = 1;
                while (n3 <= this.mDegree - 1) {
                    gF2nPolynomial4 = gF2nPolynomial4.multiplyAndReduce(gF2nPolynomial4, gF2nPolynomial);
                    gF2nPolynomial4 = gF2nPolynomial4.add(gF2nPolynomial3);
                    ++n3;
                }
                gF2nPolynomial2 = gF2nPolynomial4.gcd(gF2nPolynomial);
                n2 = gF2nPolynomial2.getDegree();
                n = gF2nPolynomial.getDegree();
            } while (n2 == 0 || n2 == n);
            gF2nPolynomial = n2 << 1 > n ? gF2nPolynomial.quotient(gF2nPolynomial2) : new GF2nPolynomial(gF2nPolynomial2);
            n = gF2nPolynomial.getDegree();
        }
        return gF2nPolynomial.at(0);
    }

    protected void computeCOBMatrix(GF2nField gF2nField) {
        GF2nElement gF2nElement;
        if (this.mDegree != gF2nField.mDegree) {
            throw new IllegalArgumentException("GF2nField.computeCOBMatrix: B1 has a different degree and thus cannot be coverted to!");
        }
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[this.mDegree];
        int n = 0;
        while (n < this.mDegree) {
            gF2PolynomialArray[n] = new GF2Polynomial(this.mDegree);
            ++n;
        }
        while ((gF2nElement = gF2nField.getRandomRoot(this.fieldPolynomial)).isZero()) {
        }
        GF2nPolynomialElement[] gF2nPolynomialElementArray = new GF2nPolynomialElement[this.mDegree];
        gF2nPolynomialElementArray[0] = (GF2nElement)gF2nElement.clone();
        n = 1;
        while (n < this.mDegree) {
            gF2nPolynomialElementArray[n] = ((GF2nElement)gF2nPolynomialElementArray[n - 1]).square();
            ++n;
        }
        n = 0;
        while (n < this.mDegree) {
            int n2 = 0;
            while (n2 < this.mDegree) {
                if (((GF2nElement)gF2nPolynomialElementArray[n]).testBit(n2)) {
                    gF2PolynomialArray[this.mDegree - n2 - 1].setBit(this.mDegree - n - 1);
                }
                ++n2;
            }
            ++n;
        }
        this.fields.addElement(gF2nField);
        this.matrices.addElement(gF2PolynomialArray);
        gF2nField.fields.addElement(this);
        gF2nField.matrices.addElement(this.invertMatrix(gF2PolynomialArray));
    }

    protected void computeFieldPolynomial() {
        if (this.mType == 1) {
            this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1, "ALL");
        } else if (this.mType == 2) {
            GF2Polynomial gF2Polynomial = new GF2Polynomial(this.mDegree + 1, "ONE");
            GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this.mDegree + 1, "X");
            gF2Polynomial2.addToThis(gF2Polynomial);
            int n = 1;
            while (n < this.mDegree) {
                GF2Polynomial gF2Polynomial3 = gF2Polynomial;
                gF2Polynomial = gF2Polynomial2;
                gF2Polynomial2 = gF2Polynomial.shiftLeft();
                gF2Polynomial2.addToThis(gF2Polynomial3);
                ++n;
            }
            this.fieldPolynomial = gF2Polynomial2;
        }
    }

    int[][] invMatrix(int[][] nArray) {
        int[][] nArray2 = new int[this.mDegree][this.mDegree];
        nArray2 = nArray;
        int[][] nArray3 = new int[this.mDegree][this.mDegree];
        int n = 0;
        while (n < this.mDegree) {
            nArray3[n][n] = 1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.mDegree) {
            int n3 = n2;
            while (n3 < this.mDegree) {
                nArray2[this.mDegree - 1 - n2][n3] = nArray2[n2][n2];
                ++n3;
            }
            ++n2;
        }
        return null;
    }

    private void computeType() throws RuntimeException {
        int n;
        if ((this.mDegree & 7) == 0) {
            throw new RuntimeException("The extension degree is divisible by 8!");
        }
        int n2 = 0;
        int n3 = 0;
        this.mType = 1;
        int n4 = 0;
        while (n4 != 1) {
            n2 = this.mType * this.mDegree + 1;
            if (IntegerFunctions.isPrime(n2)) {
                n3 = IntegerFunctions.order(2, n2);
                n4 = IntegerFunctions.gcd(this.mType * this.mDegree / n3, this.mDegree);
            }
            ++this.mType;
        }
        --this.mType;
        if (this.mType == 1 && IntegerFunctions.isPrime(n2 = (this.mDegree << 1) + 1) && (n = IntegerFunctions.gcd((this.mDegree << 1) / (n3 = IntegerFunctions.order(2, n2)), this.mDegree)) == 1) {
            ++this.mType;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeMultMatrix() {
        int n;
        if ((this.mType & 7) == 0) throw new RuntimeException("bisher nur fuer Gausssche Normalbasen implementiert");
        int n2 = this.mType * this.mDegree + 1;
        int[] nArray = new int[n2];
        int n3 = this.mType == 1 ? 1 : (this.mType == 2 ? n2 - 1 : this.elementOfOrder(this.mType, n2));
        int n4 = 1;
        int n5 = 0;
        while (n5 < this.mType) {
            int n6 = n4;
            n = 0;
            while (n < this.mDegree) {
                nArray[n6] = n;
                if ((n6 = (n6 << 1) % n2) < 0) {
                    n6 += n2;
                }
                ++n;
            }
            if ((n4 = n3 * n4 % n2) < 0) {
                n4 += n2;
            }
            ++n5;
        }
        if (this.mType == 1) {
            n = 1;
            while (n < n2 - 1) {
                if (this.mMult[nArray[n + 1]][0] == -1) {
                    this.mMult[nArray[n + 1]][0] = nArray[n2 - n];
                } else {
                    this.mMult[nArray[n + 1]][1] = nArray[n2 - n];
                }
                ++n;
            }
            int n7 = this.mDegree >> 1;
            int n8 = 1;
            while (n8 <= n7) {
                if (this.mMult[n8 - 1][0] == -1) {
                    this.mMult[n8 - 1][0] = n7 + n8 - 1;
                } else {
                    this.mMult[n8 - 1][1] = n7 + n8 - 1;
                }
                if (this.mMult[n7 + n8 - 1][0] == -1) {
                    this.mMult[n7 + n8 - 1][0] = n8 - 1;
                } else {
                    this.mMult[n7 + n8 - 1][1] = n8 - 1;
                }
                ++n8;
            }
            return;
        } else {
            if (this.mType != 2) throw new RuntimeException("only type 1 or type 2 implemented");
            n = 1;
            while (n < n2 - 1) {
                if (this.mMult[nArray[n + 1]][0] == -1) {
                    this.mMult[nArray[n + 1]][0] = nArray[n2 - n];
                } else {
                    this.mMult[nArray[n + 1]][1] = nArray[n2 - n];
                }
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int elementOfOrder(int var1_1, int var2_2) {
        var3_3 = new Random();
        var4_4 = 0;
        while (var4_4 == 0) {
            var4_4 = var3_3.nextInt();
            if ((var4_4 %= var2_2 - 1) >= 0) continue;
            var4_4 += var2_2 - 1;
        }
        var5_5 = IntegerFunctions.order(var4_4, var2_2);
        ** GOTO lbl16
        {
            var4_4 = var3_3.nextInt();
            if ((var4_4 %= var2_2 - 1) < 0) {
                var4_4 += var2_2 - 1;
            }
            do {
                if (var4_4 == 0) continue block1;
                var5_5 = IntegerFunctions.order(var4_4, var2_2);
lbl16:
                // 2 sources

            } while (var5_5 % var1_1 != 0 || var5_5 == 0);
        }
        var6_6 = var4_4;
        var5_5 = var1_1 / var5_5;
        var7_7 = 2;
        while (var7_7 <= var5_5) {
            var6_6 *= var4_4;
            ++var7_7;
        }
        return var6_6;
    }
}

