/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io.pem;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemHeader;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class PemWriter
extends BufferedWriter {
    private static final int LINE_LENGTH = 64;
    private final int nlLength;
    private char[] buf = new char[64];

    public PemWriter(Writer writer) {
        super(writer);
        String string = Strings.lineSeparator();
        this.nlLength = string != null ? string.length() : 2;
    }

    public int getOutputSize(PemObject pemObject) {
        int n = 2 * (pemObject.getType().length() + 10 + this.nlLength) + 6 + 4;
        if (!pemObject.getHeaders().isEmpty()) {
            Iterator iterator = pemObject.getHeaders().iterator();
            while (iterator.hasNext()) {
                PemHeader pemHeader = (PemHeader)iterator.next();
                n += pemHeader.getName().length() + ": ".length() + pemHeader.getValue().length() + this.nlLength;
            }
            n += this.nlLength;
        }
        int n2 = (pemObject.getContent().length + 2) / 3 * 4;
        return n += n2 + (n2 + 64 - 1) / 64 * this.nlLength;
    }

    public void writeObject(PemObjectGenerator pemObjectGenerator) throws IOException {
        PemObject pemObject = pemObjectGenerator.generate();
        this.writePreEncapsulationBoundary(pemObject.getType());
        if (!pemObject.getHeaders().isEmpty()) {
            Iterator iterator = pemObject.getHeaders().iterator();
            while (iterator.hasNext()) {
                PemHeader pemHeader = (PemHeader)iterator.next();
                this.write(pemHeader.getName());
                this.write(": ");
                this.write(pemHeader.getValue());
                this.newLine();
            }
            this.newLine();
        }
        this.writeEncoded(pemObject.getContent());
        this.writePostEncapsulationBoundary(pemObject.getType());
    }

    private void writeEncoded(byte[] byArray) throws IOException {
        byArray = Base64.encode(byArray);
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            while (n2 != this.buf.length) {
                if (n + n2 >= byArray.length) break;
                this.buf[n2] = (char)byArray[n + n2];
                ++n2;
            }
            this.write(this.buf, 0, n2);
            this.newLine();
            n += this.buf.length;
        }
    }

    private void writePreEncapsulationBoundary(String string) throws IOException {
        this.write("-----BEGIN " + string + "-----");
        this.newLine();
    }

    private void writePostEncapsulationBoundary(String string) throws IOException {
        this.write("-----END " + string + "-----");
        this.newLine();
    }
}

