/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;

public class KeyRecRepContent
extends ASN1Object {
    private final PKIStatusInfo status;
    private CMPCertificate newSigCert;
    private ASN1Sequence caCerts;
    private ASN1Sequence keyPairHist;

    private KeyRecRepContent(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.status = PKIStatusInfo.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.newSigCert = CMPCertificate.getInstance(aSN1TaggedObject.getObject());
                    break;
                }
                case 1: {
                    this.caCerts = ASN1Sequence.getInstance((Object)aSN1TaggedObject.getObject());
                    break;
                }
                case 2: {
                    this.keyPairHist = ASN1Sequence.getInstance((Object)aSN1TaggedObject.getObject());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag number: " + aSN1TaggedObject.getTagNo());
                }
            }
        }
    }

    public static KeyRecRepContent getInstance(Object object) {
        if (object instanceof KeyRecRepContent) {
            return (KeyRecRepContent)((Object)object);
        }
        if (object != null) {
            return new KeyRecRepContent(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public CMPCertificate getNewSigCert() {
        return this.newSigCert;
    }

    public CMPCertificate[] getCaCerts() {
        if (this.caCerts == null) {
            return null;
        }
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.caCerts.size()];
        int n = 0;
        while (n != cMPCertificateArray.length) {
            cMPCertificateArray[n] = CMPCertificate.getInstance(this.caCerts.getObjectAt(n));
            ++n;
        }
        return cMPCertificateArray;
    }

    public CertifiedKeyPair[] getKeyPairHist() {
        if (this.keyPairHist == null) {
            return null;
        }
        CertifiedKeyPair[] certifiedKeyPairArray = new CertifiedKeyPair[this.keyPairHist.size()];
        int n = 0;
        while (n != certifiedKeyPairArray.length) {
            certifiedKeyPairArray[n] = CertifiedKeyPair.getInstance(this.keyPairHist.getObjectAt(n));
            ++n;
        }
        return certifiedKeyPairArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        aSN1EncodableVector.add((ASN1Encodable)this.status);
        this.addOptional(aSN1EncodableVector, 0, (ASN1Encodable)this.newSigCert);
        this.addOptional(aSN1EncodableVector, 1, (ASN1Encodable)this.caCerts);
        this.addOptional(aSN1EncodableVector, 2, (ASN1Encodable)this.keyPairHist);
        return new DERSequence(aSN1EncodableVector);
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, n, aSN1Encodable));
        }
    }
}

