/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.tsp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.tsp.ArchiveTimeStamp;

public class ArchiveTimeStampChain
extends ASN1Object {
    private ASN1Sequence archiveTimestamps;

    public static ArchiveTimeStampChain getInstance(Object object) {
        if (object instanceof ArchiveTimeStampChain) {
            return (ArchiveTimeStampChain)((Object)object);
        }
        if (object != null) {
            return new ArchiveTimeStampChain(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public ArchiveTimeStampChain(ArchiveTimeStamp archiveTimeStamp) {
        this.archiveTimestamps = new DERSequence((ASN1Encodable)archiveTimeStamp);
    }

    public ArchiveTimeStampChain(ArchiveTimeStamp[] archiveTimeStampArray) {
        this.archiveTimestamps = new DERSequence((ASN1Encodable[])archiveTimeStampArray);
    }

    private ArchiveTimeStampChain(ASN1Sequence aSN1Sequence) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(aSN1Sequence.size());
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)ArchiveTimeStamp.getInstance(enumeration.nextElement()));
        }
        this.archiveTimestamps = new DERSequence(aSN1EncodableVector);
    }

    public ArchiveTimeStamp[] getArchiveTimestamps() {
        ArchiveTimeStamp[] archiveTimeStampArray = new ArchiveTimeStamp[this.archiveTimestamps.size()];
        int n = 0;
        while (n != archiveTimeStampArray.length) {
            archiveTimeStampArray[n] = ArchiveTimeStamp.getInstance(this.archiveTimestamps.getObjectAt(n));
            ++n;
        }
        return archiveTimeStampArray;
    }

    public ArchiveTimeStampChain append(ArchiveTimeStamp archiveTimeStamp) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(this.archiveTimestamps.size() + 1);
        int n = 0;
        while (n != this.archiveTimestamps.size()) {
            aSN1EncodableVector.add(this.archiveTimestamps.getObjectAt(n));
            ++n;
        }
        aSN1EncodableVector.add((ASN1Encodable)archiveTimeStamp);
        return new ArchiveTimeStampChain((ASN1Sequence)new DERSequence(aSN1EncodableVector));
    }

    public ASN1Primitive toASN1Primitive() {
        return this.archiveTimestamps;
    }
}

