/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.tsp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.tsp.ArchiveTimeStampChain;

public class ArchiveTimeStampSequence
extends ASN1Object {
    private ASN1Sequence archiveTimeStampChains;

    public static ArchiveTimeStampSequence getInstance(Object object) {
        if (object instanceof ArchiveTimeStampChain) {
            return (ArchiveTimeStampSequence)((Object)object);
        }
        if (object != null) {
            return new ArchiveTimeStampSequence(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    private ArchiveTimeStampSequence(ASN1Sequence aSN1Sequence) throws IllegalArgumentException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(aSN1Sequence.size());
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)ArchiveTimeStampChain.getInstance(enumeration.nextElement()));
        }
        this.archiveTimeStampChains = new DERSequence(aSN1EncodableVector);
    }

    public ArchiveTimeStampSequence(ArchiveTimeStampChain archiveTimeStampChain) {
        this.archiveTimeStampChains = new DERSequence((ASN1Encodable)archiveTimeStampChain);
    }

    public ArchiveTimeStampSequence(ArchiveTimeStampChain[] archiveTimeStampChainArray) {
        this.archiveTimeStampChains = new DERSequence((ASN1Encodable[])archiveTimeStampChainArray);
    }

    public ArchiveTimeStampChain[] getArchiveTimeStampChains() {
        ArchiveTimeStampChain[] archiveTimeStampChainArray = new ArchiveTimeStampChain[this.archiveTimeStampChains.size()];
        int n = 0;
        while (n != archiveTimeStampChainArray.length) {
            archiveTimeStampChainArray[n] = ArchiveTimeStampChain.getInstance(this.archiveTimeStampChains.getObjectAt(n));
            ++n;
        }
        return archiveTimeStampChainArray;
    }

    public int size() {
        return this.archiveTimeStampChains.size();
    }

    public ArchiveTimeStampSequence append(ArchiveTimeStampChain archiveTimeStampChain) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(this.archiveTimeStampChains.size() + 1);
        int n = 0;
        while (n != this.archiveTimeStampChains.size()) {
            aSN1EncodableVector.add(this.archiveTimeStampChains.getObjectAt(n));
            ++n;
        }
        aSN1EncodableVector.add((ASN1Encodable)archiveTimeStampChain);
        return new ArchiveTimeStampSequence((ASN1Sequence)new DERSequence(aSN1EncodableVector));
    }

    public ASN1Primitive toASN1Primitive() {
        return this.archiveTimeStampChains;
    }
}

