/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.JCEUtil;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class KeyAgreement {
    KeyAgreementSpi keyAgreeSpi;
    Provider provider;
    String algorithm;

    protected KeyAgreement(KeyAgreementSpi keyAgreementSpi, Provider provider, String string) {
        this.keyAgreeSpi = keyAgreementSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyAgreement getInstance(String string) throws NoSuchAlgorithmException {
        try {
            JCEUtil.Implementation implementation = JCEUtil.getImplementation("KeyAgreement", string, (String)null);
            if (implementation == null) {
                throw new NoSuchAlgorithmException(string + " not found");
            }
            KeyAgreement keyAgreement = new KeyAgreement((KeyAgreementSpi)implementation.getEngine(), implementation.getProvider(), string);
            return keyAgreement;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static final KeyAgreement getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("No provider specified to KeyAgreement.getInstance()");
        }
        JCEUtil.Implementation implementation = JCEUtil.getImplementation("KeyAgreement", string, provider);
        if (implementation == null) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
        KeyAgreement keyAgreement = new KeyAgreement((KeyAgreementSpi)implementation.getEngine(), implementation.getProvider(), string);
        return keyAgreement;
    }

    public static final KeyAgreement getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("No provider specified to KeyAgreement.getInstance()");
        }
        JCEUtil.Implementation implementation = JCEUtil.getImplementation("KeyAgreement", string, string2);
        if (implementation == null) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
        KeyAgreement keyAgreement = new KeyAgreement((KeyAgreementSpi)implementation.getEngine(), implementation.getProvider(), string);
        return keyAgreement;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.keyAgreeSpi.engineInit(key, null);
    }

    public final void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.keyAgreeSpi.engineInit(key, secureRandom);
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.keyAgreeSpi.engineInit(key, algorithmParameterSpec, null);
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.keyAgreeSpi.engineInit(key, algorithmParameterSpec, secureRandom);
    }

    public final Key doPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        return this.keyAgreeSpi.engineDoPhase(key, bl);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        return this.keyAgreeSpi.engineGenerateSecret();
    }

    public final int generateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        return this.keyAgreeSpi.engineGenerateSecret(byArray, n);
    }

    public final SecretKey generateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        return this.keyAgreeSpi.engineGenerateSecret(string);
    }
}

