/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;

public abstract class ASN1BMPString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(class$org$bouncycastle$asn1$ASN1BMPString == null ? (class$org$bouncycastle$asn1$ASN1BMPString = ASN1BMPString.class$("org.bouncycastle.asn1.ASN1BMPString")) : class$org$bouncycastle$asn1$ASN1BMPString, 30){

        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1BMPString.createPrimitive(dEROctetString.getOctets());
        }
    };
    final char[] string;
    static /* synthetic */ Class class$org$bouncycastle$asn1$ASN1BMPString;

    public static ASN1BMPString getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1BMPString) {
            return (ASN1BMPString)object;
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1BMPString) {
            return (ASN1BMPString)aSN1Primitive;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1BMPString)TYPE.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1BMPString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1BMPString)TYPE.getContextInstance(aSN1TaggedObject, bl);
    }

    ASN1BMPString(String string) {
        if (string == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.string = string.toCharArray();
    }

    ASN1BMPString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        int n = byArray.length;
        if (0 != (n & 1)) {
            throw new IllegalArgumentException("malformed BMPString encoding encountered");
        }
        int n2 = n / 2;
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 != n2) {
            cArray[n3] = (char)(byArray[2 * n3] << 8 | byArray[2 * n3 + 1] & 0xFF);
            ++n3;
        }
        this.string = cArray;
    }

    ASN1BMPString(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.string = cArray;
    }

    public final String getString() {
        return new String(this.string);
    }

    public String toString() {
        return this.getString();
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1BMPString)) {
            return false;
        }
        ASN1BMPString aSN1BMPString = (ASN1BMPString)aSN1Primitive;
        return Arrays.areEqual(this.string, aSN1BMPString.string);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.string);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.string.length * 2);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        char c;
        int n;
        int n2 = this.string.length;
        aSN1OutputStream.writeIdentifier(bl, 30);
        aSN1OutputStream.writeDL(n2 * 2);
        byte[] byArray = new byte[8];
        int n3 = 0;
        int n4 = n2 & 0xFFFFFFFC;
        while (n3 < n4) {
            n = this.string[n3];
            c = this.string[n3 + 1];
            char c2 = this.string[n3 + 2];
            char c3 = this.string[n3 + 3];
            n3 += 4;
            byArray[0] = (byte)(n >> 8);
            byArray[1] = (byte)n;
            byArray[2] = (byte)(c >> 8);
            byArray[3] = (byte)c;
            byArray[4] = (byte)(c2 >> 8);
            byArray[5] = (byte)c2;
            byArray[6] = (byte)(c3 >> 8);
            byArray[7] = (byte)c3;
            aSN1OutputStream.write(byArray, 0, 8);
        }
        if (n3 < n2) {
            n = 0;
            do {
                c = this.string[n3];
                byArray[n++] = (byte)(c >> 8);
                byArray[n++] = (byte)c;
            } while (++n3 < n2);
            aSN1OutputStream.write(byArray, 0, n);
        }
    }

    static ASN1BMPString createPrimitive(byte[] byArray) {
        return new DERBMPString(byArray);
    }

    static ASN1BMPString createPrimitive(char[] cArray) {
        return new DERBMPString(cArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

