/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class SM3Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 32;
    private static final int BLOCK_SIZE = 16;
    private int[] V = new int[8];
    private int[] inwords = new int[16];
    private int xOff;
    private int[] W = new int[68];
    private static final int[] T;

    public SM3Digest() {
        this.reset();
    }

    public SM3Digest(SM3Digest sM3Digest) {
        super(sM3Digest);
        this.copyIn(sM3Digest);
    }

    private void copyIn(SM3Digest sM3Digest) {
        System.arraycopy(sM3Digest.V, 0, this.V, 0, this.V.length);
        System.arraycopy(sM3Digest.inwords, 0, this.inwords, 0, this.inwords.length);
        this.xOff = sM3Digest.xOff;
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    public Memoable copy() {
        return new SM3Digest(this);
    }

    public void reset(Memoable memoable) {
        SM3Digest sM3Digest = (SM3Digest)memoable;
        super.copyIn(sM3Digest);
        this.copyIn(sM3Digest);
    }

    public void reset() {
        super.reset();
        this.V[0] = 1937774191;
        this.V[1] = 1226093241;
        this.V[2] = 388252375;
        this.V[3] = -628488704;
        this.V[4] = -1452330820;
        this.V[5] = 372324522;
        this.V[6] = -477237683;
        this.V[7] = -1325724082;
        this.xOff = 0;
    }

    public int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.intToBigEndian(this.V, byArray, n);
        this.reset();
        return 32;
    }

    protected void processWord(byte[] byArray, int n) {
        int n2;
        this.inwords[this.xOff] = n2 = (byArray[n] & 0xFF) << 24 | (byArray[++n] & 0xFF) << 16 | (byArray[++n] & 0xFF) << 8 | byArray[++n] & 0xFF;
        ++this.xOff;
        if (this.xOff >= 16) {
            this.processBlock();
        }
    }

    protected void processLength(long l) {
        if (this.xOff > 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
            this.processBlock();
        }
        while (this.xOff < 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
        }
        this.inwords[this.xOff++] = (int)(l >>> 32);
        this.inwords[this.xOff++] = (int)l;
    }

    private int P0(int n) {
        int n2 = n << 9 | n >>> 23;
        int n3 = n << 17 | n >>> 15;
        return n ^ n2 ^ n3;
    }

    private int P1(int n) {
        int n2 = n << 15 | n >>> 17;
        int n3 = n << 23 | n >>> 9;
        return n ^ n2 ^ n3;
    }

    private int FF0(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int FF1(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private int GG0(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int GG1(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    protected void processBlock() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = 0;
        while (n13 < 16) {
            this.W[n13] = this.inwords[n13];
            ++n13;
        }
        int n14 = 16;
        while (n14 < 68) {
            n12 = this.W[n14 - 3];
            n11 = n12 << 15 | n12 >>> 17;
            n10 = this.W[n14 - 13];
            n9 = n10 << 7 | n10 >>> 25;
            this.W[n14] = this.P1(this.W[n14 - 16] ^ this.W[n14 - 9] ^ n11) ^ n9 ^ this.W[n14 - 6];
            ++n14;
        }
        n12 = this.V[0];
        n11 = this.V[1];
        n10 = this.V[2];
        n9 = this.V[3];
        int n15 = this.V[4];
        int n16 = this.V[5];
        int n17 = this.V[6];
        int n18 = this.V[7];
        int n19 = 0;
        while (n19 < 16) {
            n8 = n12 << 12 | n12 >>> 20;
            n7 = n8 + n15 + T[n19];
            n6 = n7 << 7 | n7 >>> 25;
            n5 = n6 ^ n8;
            n4 = this.W[n19];
            n3 = n4 ^ this.W[n19 + 4];
            n2 = this.FF0(n12, n11, n10) + n9 + n5 + n3;
            n = this.GG0(n15, n16, n17) + n18 + n6 + n4;
            n9 = n10;
            n10 = n11 << 9 | n11 >>> 23;
            n11 = n12;
            n12 = n2;
            n18 = n17;
            n17 = n16 << 19 | n16 >>> 13;
            n16 = n15;
            n15 = this.P0(n);
            ++n19;
        }
        n8 = 16;
        while (n8 < 64) {
            n7 = n12 << 12 | n12 >>> 20;
            n6 = n7 + n15 + T[n8];
            n5 = n6 << 7 | n6 >>> 25;
            n4 = n5 ^ n7;
            n3 = this.W[n8];
            n2 = n3 ^ this.W[n8 + 4];
            n = this.FF1(n12, n11, n10) + n9 + n4 + n2;
            int n20 = this.GG1(n15, n16, n17) + n18 + n5 + n3;
            n9 = n10;
            n10 = n11 << 9 | n11 >>> 23;
            n11 = n12;
            n12 = n;
            n18 = n17;
            n17 = n16 << 19 | n16 >>> 13;
            n16 = n15;
            n15 = this.P0(n20);
            ++n8;
        }
        this.V[0] = this.V[0] ^ n12;
        this.V[1] = this.V[1] ^ n11;
        this.V[2] = this.V[2] ^ n10;
        this.V[3] = this.V[3] ^ n9;
        this.V[4] = this.V[4] ^ n15;
        this.V[5] = this.V[5] ^ n16;
        this.V[6] = this.V[6] ^ n17;
        this.V[7] = this.V[7] ^ n18;
        this.xOff = 0;
    }

    static {
        int n;
        T = new int[64];
        int n2 = 0;
        while (n2 < 16) {
            n = 2043430169;
            SM3Digest.T[n2] = n << n2 | n >>> 32 - n2;
            ++n2;
        }
        n = 16;
        while (n < 64) {
            int n3 = n % 32;
            int n4 = 2055708042;
            SM3Digest.T[n] = n4 << n3 | n4 >>> 32 - n3;
            ++n;
        }
    }
}

