/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Pack;

public class ISAACEngine
implements StreamCipher {
    private final int sizeL = 8;
    private final int stateArraySize = 256;
    private int[] engineState = null;
    private int[] results = null;
    private int a = 0;
    private int b = 0;
    private int c = 0;
    private int index = 0;
    private byte[] keyStream = new byte[1024];
    private byte[] workingKey = null;
    private boolean initialised = false;

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to ISAAC init - " + cipherParameters.getClass().getName());
        }
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        this.setKey(keyParameter.getKey());
    }

    public byte returnByte(byte by) {
        if (this.index == 0) {
            this.isaac();
            this.keyStream = Pack.intToBigEndian(this.results);
        }
        byte by2 = (byte)(this.keyStream[this.index] ^ by);
        this.index = this.index + 1 & 0x3FF;
        return by2;
    }

    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + n2 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n4 = 0;
        while (n4 < n2) {
            if (this.index == 0) {
                this.isaac();
                this.keyStream = Pack.intToBigEndian(this.results);
            }
            byArray2[n4 + n3] = (byte)(this.keyStream[this.index] ^ byArray[n4 + n]);
            this.index = this.index + 1 & 0x3FF;
            ++n4;
        }
        return n2;
    }

    public String getAlgorithmName() {
        return "ISAAC";
    }

    public void reset() {
        this.setKey(this.workingKey);
    }

    private void setKey(byte[] byArray) {
        this.workingKey = byArray;
        if (this.engineState == null) {
            this.engineState = new int[256];
        }
        if (this.results == null) {
            this.results = new int[256];
        }
        int n = 0;
        while (n < 256) {
            this.results[n] = 0;
            this.engineState[n] = 0;
            ++n;
        }
        this.c = 0;
        this.b = 0;
        this.a = 0;
        this.index = 0;
        byte[] byArray2 = new byte[byArray.length + (byArray.length & 3)];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        n = 0;
        while (n < byArray2.length) {
            this.results[n >>> 2] = Pack.littleEndianToInt(byArray2, n);
            n += 4;
        }
        int[] nArray = new int[8];
        n = 0;
        while (n < 8) {
            nArray[n] = -1640531527;
            ++n;
        }
        n = 0;
        while (n < 4) {
            this.mix(nArray);
            ++n;
        }
        n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < 256) {
                int n3 = 0;
                while (n3 < 8) {
                    int n4 = n3;
                    nArray[n4] = nArray[n4] + (n < 1 ? this.results[n2 + n3] : this.engineState[n2 + n3]);
                    ++n3;
                }
                this.mix(nArray);
                n3 = 0;
                while (n3 < 8) {
                    this.engineState[n2 + n3] = nArray[n3];
                    ++n3;
                }
                n2 += 8;
            }
            ++n;
        }
        this.isaac();
        this.initialised = true;
    }

    private void isaac() {
        this.b += ++this.c;
        int n = 0;
        while (n < 256) {
            int n2;
            int n3 = this.engineState[n];
            switch (n & 3) {
                case 0: {
                    this.a ^= this.a << 13;
                    break;
                }
                case 1: {
                    this.a ^= this.a >>> 6;
                    break;
                }
                case 2: {
                    this.a ^= this.a << 2;
                    break;
                }
                case 3: {
                    this.a ^= this.a >>> 16;
                }
            }
            this.a += this.engineState[n + 128 & 0xFF];
            this.engineState[n] = n2 = this.engineState[n3 >>> 2 & 0xFF] + this.a + this.b;
            this.results[n] = this.b = this.engineState[n2 >>> 10 & 0xFF] + n3;
            ++n;
        }
    }

    private void mix(int[] nArray) {
        nArray[0] = nArray[0] ^ nArray[1] << 11;
        nArray[3] = nArray[3] + nArray[0];
        nArray[1] = nArray[1] + nArray[2];
        nArray[1] = nArray[1] ^ nArray[2] >>> 2;
        nArray[4] = nArray[4] + nArray[1];
        nArray[2] = nArray[2] + nArray[3];
        nArray[2] = nArray[2] ^ nArray[3] << 8;
        nArray[5] = nArray[5] + nArray[2];
        nArray[3] = nArray[3] + nArray[4];
        nArray[3] = nArray[3] ^ nArray[4] >>> 16;
        nArray[6] = nArray[6] + nArray[3];
        nArray[4] = nArray[4] + nArray[5];
        nArray[4] = nArray[4] ^ nArray[5] << 10;
        nArray[7] = nArray[7] + nArray[4];
        nArray[5] = nArray[5] + nArray[6];
        nArray[5] = nArray[5] ^ nArray[6] >>> 4;
        nArray[0] = nArray[0] + nArray[5];
        nArray[6] = nArray[6] + nArray[7];
        nArray[6] = nArray[6] ^ nArray[7] << 8;
        nArray[1] = nArray[1] + nArray[6];
        nArray[7] = nArray[7] + nArray[0];
        nArray[7] = nArray[7] ^ nArray[0] >>> 9;
        nArray[2] = nArray[2] + nArray[7];
        nArray[0] = nArray[0] + nArray[1];
    }
}

