/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RC2Parameters;

public class RC2Engine
implements BlockCipher {
    private static byte[] piTable = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};
    private static final int BLOCK_SIZE = 8;
    private int[] workingKey;
    private boolean encrypting;

    private int[] generateWorkingKey(byte[] byArray, int n) {
        int n2;
        int n3;
        int[] nArray = new int[128];
        int n4 = 0;
        while (n4 != byArray.length) {
            nArray[n4] = byArray[n4] & 0xFF;
            ++n4;
        }
        int n5 = byArray.length;
        if (n5 < 128) {
            n3 = 0;
            n2 = nArray[n5 - 1];
            do {
                n2 = piTable[n2 + nArray[n3++] & 0xFF] & 0xFF;
                nArray[n5++] = n2;
            } while (n5 < 128);
        }
        n5 = n + 7 >> 3;
        nArray[128 - n5] = n2 = piTable[nArray[128 - n5] & 255 >> (7 & -n)] & 0xFF;
        n3 = 128 - n5 - 1;
        while (n3 >= 0) {
            nArray[n3] = n2 = piTable[n2 ^ nArray[n3 + n5]] & 0xFF;
            --n3;
        }
        int[] nArray2 = new int[64];
        int n6 = 0;
        while (n6 != nArray2.length) {
            nArray2[n6] = nArray[2 * n6] + (nArray[2 * n6 + 1] << 8);
            ++n6;
        }
        return nArray2;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.encrypting = bl;
        if (cipherParameters instanceof RC2Parameters) {
            RC2Parameters rC2Parameters = (RC2Parameters)cipherParameters;
            this.workingKey = this.generateWorkingKey(rC2Parameters.getKey(), rC2Parameters.getEffectiveKeyBits());
        } else if (cipherParameters instanceof KeyParameter) {
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            this.workingKey = this.generateWorkingKey(byArray, byArray.length * 8);
        } else {
            throw new IllegalArgumentException("invalid parameter passed to RC2 init - " + cipherParameters.getClass().getName());
        }
    }

    public void reset() {
    }

    public String getAlgorithmName() {
        return "RC2";
    }

    public int getBlockSize() {
        return 8;
    }

    public final int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.workingKey == null) {
            throw new IllegalStateException("RC2 engine not initialised");
        }
        if (n + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.encrypting) {
            this.encryptBlock(byArray, n, byArray2, n2);
        } else {
            this.decryptBlock(byArray, n, byArray2, n2);
        }
        return 8;
    }

    private int rotateWordLeft(int n, int n2) {
        return (n &= 0xFFFF) << n2 | n >> 16 - n2;
    }

    private void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ((byArray[n + 7] & 0xFF) << 8) + (byArray[n + 6] & 0xFF);
        int n4 = ((byArray[n + 5] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
        int n5 = ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
        int n6 = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 0] & 0xFF);
        int n7 = 0;
        while (n7 <= 16) {
            n6 = this.rotateWordLeft(n6 + (n5 & ~n3) + (n4 & n3) + this.workingKey[n7], 1);
            n5 = this.rotateWordLeft(n5 + (n4 & ~n6) + (n3 & n6) + this.workingKey[n7 + 1], 2);
            n4 = this.rotateWordLeft(n4 + (n3 & ~n5) + (n6 & n5) + this.workingKey[n7 + 2], 3);
            n3 = this.rotateWordLeft(n3 + (n6 & ~n4) + (n5 & n4) + this.workingKey[n7 + 3], 5);
            n7 += 4;
        }
        n4 += this.workingKey[(n5 += this.workingKey[(n6 += this.workingKey[n3 & 0x3F]) & 0x3F]) & 0x3F];
        n3 += this.workingKey[n4 & 0x3F];
        int n8 = 20;
        while (n8 <= 40) {
            n6 = this.rotateWordLeft(n6 + (n5 & ~n3) + (n4 & n3) + this.workingKey[n8], 1);
            n5 = this.rotateWordLeft(n5 + (n4 & ~n6) + (n3 & n6) + this.workingKey[n8 + 1], 2);
            n4 = this.rotateWordLeft(n4 + (n3 & ~n5) + (n6 & n5) + this.workingKey[n8 + 2], 3);
            n3 = this.rotateWordLeft(n3 + (n6 & ~n4) + (n5 & n4) + this.workingKey[n8 + 3], 5);
            n8 += 4;
        }
        n4 += this.workingKey[(n5 += this.workingKey[(n6 += this.workingKey[n3 & 0x3F]) & 0x3F]) & 0x3F];
        n3 += this.workingKey[n4 & 0x3F];
        int n9 = 44;
        while (n9 < 64) {
            n6 = this.rotateWordLeft(n6 + (n5 & ~n3) + (n4 & n3) + this.workingKey[n9], 1);
            n5 = this.rotateWordLeft(n5 + (n4 & ~n6) + (n3 & n6) + this.workingKey[n9 + 1], 2);
            n4 = this.rotateWordLeft(n4 + (n3 & ~n5) + (n6 & n5) + this.workingKey[n9 + 2], 3);
            n3 = this.rotateWordLeft(n3 + (n6 & ~n4) + (n5 & n4) + this.workingKey[n9 + 3], 5);
            n9 += 4;
        }
        byArray2[n2 + 0] = (byte)n6;
        byArray2[n2 + 1] = (byte)(n6 >> 8);
        byArray2[n2 + 2] = (byte)n5;
        byArray2[n2 + 3] = (byte)(n5 >> 8);
        byArray2[n2 + 4] = (byte)n4;
        byArray2[n2 + 5] = (byte)(n4 >> 8);
        byArray2[n2 + 6] = (byte)n3;
        byArray2[n2 + 7] = (byte)(n3 >> 8);
    }

    private void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ((byArray[n + 7] & 0xFF) << 8) + (byArray[n + 6] & 0xFF);
        int n4 = ((byArray[n + 5] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
        int n5 = ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
        int n6 = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 0] & 0xFF);
        int n7 = 60;
        while (n7 >= 44) {
            n3 = this.rotateWordLeft(n3, 11) - ((n6 & ~n4) + (n5 & n4) + this.workingKey[n7 + 3]);
            n4 = this.rotateWordLeft(n4, 13) - ((n3 & ~n5) + (n6 & n5) + this.workingKey[n7 + 2]);
            n5 = this.rotateWordLeft(n5, 14) - ((n4 & ~n6) + (n3 & n6) + this.workingKey[n7 + 1]);
            n6 = this.rotateWordLeft(n6, 15) - ((n5 & ~n3) + (n4 & n3) + this.workingKey[n7]);
            n7 -= 4;
        }
        n3 -= this.workingKey[n4 & 0x3F];
        n4 -= this.workingKey[n5 & 0x3F];
        n5 -= this.workingKey[n6 & 0x3F];
        n6 -= this.workingKey[n3 & 0x3F];
        int n8 = 40;
        while (n8 >= 20) {
            n3 = this.rotateWordLeft(n3, 11) - ((n6 & ~n4) + (n5 & n4) + this.workingKey[n8 + 3]);
            n4 = this.rotateWordLeft(n4, 13) - ((n3 & ~n5) + (n6 & n5) + this.workingKey[n8 + 2]);
            n5 = this.rotateWordLeft(n5, 14) - ((n4 & ~n6) + (n3 & n6) + this.workingKey[n8 + 1]);
            n6 = this.rotateWordLeft(n6, 15) - ((n5 & ~n3) + (n4 & n3) + this.workingKey[n8]);
            n8 -= 4;
        }
        n3 -= this.workingKey[n4 & 0x3F];
        n4 -= this.workingKey[n5 & 0x3F];
        n5 -= this.workingKey[n6 & 0x3F];
        n6 -= this.workingKey[n3 & 0x3F];
        int n9 = 16;
        while (n9 >= 0) {
            n3 = this.rotateWordLeft(n3, 11) - ((n6 & ~n4) + (n5 & n4) + this.workingKey[n9 + 3]);
            n4 = this.rotateWordLeft(n4, 13) - ((n3 & ~n5) + (n6 & n5) + this.workingKey[n9 + 2]);
            n5 = this.rotateWordLeft(n5, 14) - ((n4 & ~n6) + (n3 & n6) + this.workingKey[n9 + 1]);
            n6 = this.rotateWordLeft(n6, 15) - ((n5 & ~n3) + (n4 & n3) + this.workingKey[n9]);
            n9 -= 4;
        }
        byArray2[n2 + 0] = (byte)n6;
        byArray2[n2 + 1] = (byte)(n6 >> 8);
        byArray2[n2 + 2] = (byte)n5;
        byArray2[n2 + 3] = (byte)(n5 >> 8);
        byArray2[n2 + 4] = (byte)n4;
        byArray2[n2 + 5] = (byte)(n4 >> 8);
        byArray2[n2 + 6] = (byte)n3;
        byArray2[n2 + 7] = (byte)(n3 >> 8);
    }
}

