/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.custom.sec.SecP224R1Field;
import org.bouncycastle.math.raw.Mod;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat224;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class SecP224R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001"));
    protected int[] x;

    public SecP224R1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP224R1FieldElement");
        }
        this.x = SecP224R1Field.fromBigInteger(bigInteger);
    }

    public SecP224R1FieldElement() {
        this.x = Nat224.create();
    }

    protected SecP224R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    public boolean isZero() {
        return Nat224.isZero(this.x);
    }

    public boolean isOne() {
        return Nat224.isOne(this.x);
    }

    public boolean testBitZero() {
        return Nat224.getBit(this.x, 0) == 1;
    }

    public BigInteger toBigInteger() {
        return Nat224.toBigInteger(this.x);
    }

    public String getFieldName() {
        return "SecP224R1Field";
    }

    public int getFieldSize() {
        return Q.bitLength();
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat224.create();
        SecP224R1Field.add(this.x, ((SecP224R1FieldElement)eCFieldElement).x, nArray);
        return new SecP224R1FieldElement(nArray);
    }

    public ECFieldElement addOne() {
        int[] nArray = Nat224.create();
        SecP224R1Field.addOne(this.x, nArray);
        return new SecP224R1FieldElement(nArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat224.create();
        SecP224R1Field.subtract(this.x, ((SecP224R1FieldElement)eCFieldElement).x, nArray);
        return new SecP224R1FieldElement(nArray);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat224.create();
        SecP224R1Field.multiply(this.x, ((SecP224R1FieldElement)eCFieldElement).x, nArray);
        return new SecP224R1FieldElement(nArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat224.create();
        SecP224R1Field.inv(((SecP224R1FieldElement)eCFieldElement).x, nArray);
        SecP224R1Field.multiply(nArray, this.x, nArray);
        return new SecP224R1FieldElement(nArray);
    }

    public ECFieldElement negate() {
        int[] nArray = Nat224.create();
        SecP224R1Field.negate(this.x, nArray);
        return new SecP224R1FieldElement(nArray);
    }

    public ECFieldElement square() {
        int[] nArray = Nat224.create();
        SecP224R1Field.square(this.x, nArray);
        return new SecP224R1FieldElement(nArray);
    }

    public ECFieldElement invert() {
        int[] nArray = Nat224.create();
        SecP224R1Field.inv(this.x, nArray);
        return new SecP224R1FieldElement(nArray);
    }

    /*
     * Unable to fully structure code
     */
    public ECFieldElement sqrt() {
        var1_1 = this.x;
        if (Nat224.isZero(var1_1) || Nat224.isOne(var1_1)) {
            return this;
        }
        var2_2 = Nat224.create();
        SecP224R1Field.negate(var1_1, var2_2);
        var3_3 = Mod.random(SecP224R1Field.P);
        var4_4 = Nat224.create();
        if (SecP224R1FieldElement.isSquare(var1_1)) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            SecP224R1Field.addOne(var3_3, var3_3);
lbl11:
            // 2 sources

            ** while (!SecP224R1FieldElement.trySqrt((int[])var2_2, (int[])var3_3, (int[])var4_4))
        }
lbl12:
        // 1 sources

        SecP224R1Field.square(var4_4, var3_3);
        return Nat224.eq(var1_1, var3_3) != false ? new SecP224R1FieldElement(var4_4) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP224R1FieldElement)) {
            return false;
        }
        SecP224R1FieldElement secP224R1FieldElement = (SecP224R1FieldElement)object;
        return Nat224.eq(this.x, secP224R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 7);
    }

    private static boolean isSquare(int[] nArray) {
        int[] nArray2 = Nat224.create();
        int[] nArray3 = Nat224.create();
        Nat224.copy(nArray, nArray2);
        int n = 0;
        while (n < 7) {
            Nat224.copy(nArray2, nArray3);
            SecP224R1Field.squareN(nArray2, 1 << n, nArray2);
            SecP224R1Field.multiply(nArray2, nArray3, nArray2);
            ++n;
        }
        SecP224R1Field.squareN(nArray2, 95, nArray2);
        return Nat224.isOne(nArray2);
    }

    private static void RM(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        SecP224R1Field.multiply(nArray5, nArray3, nArray7);
        SecP224R1Field.multiply(nArray7, nArray, nArray7);
        SecP224R1Field.multiply(nArray4, nArray2, nArray6);
        SecP224R1Field.add(nArray6, nArray7, nArray6);
        SecP224R1Field.multiply(nArray4, nArray3, nArray7);
        Nat224.copy(nArray6, nArray4);
        SecP224R1Field.multiply(nArray5, nArray2, nArray5);
        SecP224R1Field.add(nArray5, nArray7, nArray5);
        SecP224R1Field.square(nArray5, nArray6);
        SecP224R1Field.multiply(nArray6, nArray, nArray6);
    }

    private static void RP(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        Nat224.copy(nArray, nArray4);
        int[] nArray6 = Nat224.create();
        int[] nArray7 = Nat224.create();
        int n = 0;
        while (n < 7) {
            Nat224.copy(nArray2, nArray6);
            Nat224.copy(nArray3, nArray7);
            int n2 = 1 << n;
            while (--n2 >= 0) {
                SecP224R1FieldElement.RS(nArray2, nArray3, nArray4, nArray5);
            }
            SecP224R1FieldElement.RM(nArray, nArray6, nArray7, nArray2, nArray3, nArray4, nArray5);
            ++n;
        }
    }

    private static void RS(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        SecP224R1Field.multiply(nArray2, nArray, nArray2);
        SecP224R1Field.twice(nArray2, nArray2);
        SecP224R1Field.square(nArray, nArray4);
        SecP224R1Field.add(nArray3, nArray4, nArray);
        SecP224R1Field.multiply(nArray3, nArray4, nArray3);
        int n = Nat.shiftUpBits(7, nArray3, 2, 0);
        SecP224R1Field.reduce32(n, nArray3);
    }

    private static boolean trySqrt(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat224.create();
        Nat224.copy(nArray2, nArray4);
        int[] nArray5 = Nat224.create();
        nArray5[0] = 1;
        int[] nArray6 = Nat224.create();
        SecP224R1FieldElement.RP(nArray, nArray4, nArray5, nArray6, nArray3);
        int[] nArray7 = Nat224.create();
        int[] nArray8 = Nat224.create();
        int n = 1;
        while (n < 96) {
            Nat224.copy(nArray4, nArray7);
            Nat224.copy(nArray5, nArray8);
            SecP224R1FieldElement.RS(nArray4, nArray5, nArray6, nArray3);
            if (Nat224.isZero(nArray4)) {
                SecP224R1Field.inv(nArray8, nArray3);
                SecP224R1Field.multiply(nArray3, nArray7, nArray3);
                return true;
            }
            ++n;
        }
        return false;
    }
}

