/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import org.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import org.bouncycastle.pqc.crypto.gmss.util.GMSSUtil;
import org.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSVerify;
import org.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import org.bouncycastle.util.Arrays;

public class GMSSSigner
implements MessageSigner {
    private GMSSUtil gmssUtil = new GMSSUtil();
    private byte[] pubKeyBytes;
    private Digest messDigestTrees;
    private int mdLength;
    private int numLayer;
    private Digest messDigestOTS;
    private WinternitzOTSignature ots;
    private GMSSDigestProvider digestProvider;
    private int[] index;
    private byte[][][] currentAuthPaths;
    private byte[][] subtreeRootSig;
    private GMSSParameters gmssPS;
    private GMSSRandom gmssRandom;
    GMSSKeyParameters key;
    private SecureRandom random;

    public GMSSSigner(GMSSDigestProvider gMSSDigestProvider) {
        this.digestProvider = gMSSDigestProvider;
        this.messDigestOTS = this.messDigestTrees = gMSSDigestProvider.get();
        this.mdLength = this.messDigestTrees.getDigestSize();
        this.gmssRandom = new GMSSRandom(this.messDigestTrees);
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.random = parametersWithRandom.getRandom();
                this.key = (GMSSPrivateKeyParameters)parametersWithRandom.getParameters();
                this.initSign();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
                this.key = (GMSSPrivateKeyParameters)cipherParameters;
                this.initSign();
            }
        } else {
            this.key = (GMSSPublicKeyParameters)cipherParameters;
            this.initVerify();
        }
    }

    private void initSign() {
        this.messDigestTrees.reset();
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = (GMSSPrivateKeyParameters)this.key;
        if (gMSSPrivateKeyParameters.isUsed()) {
            throw new IllegalStateException("Private key already used");
        }
        if (gMSSPrivateKeyParameters.getIndex(0) >= gMSSPrivateKeyParameters.getNumLeafs(0)) {
            throw new IllegalStateException("No more signatures can be generated");
        }
        this.gmssPS = gMSSPrivateKeyParameters.getParameters();
        this.numLayer = this.gmssPS.getNumOfLayers();
        byte[] byArray = gMSSPrivateKeyParameters.getCurrentSeeds()[this.numLayer - 1];
        byte[] byArray2 = new byte[this.mdLength];
        byte[] byArray3 = new byte[this.mdLength];
        System.arraycopy(byArray, 0, byArray3, 0, this.mdLength);
        byArray2 = this.gmssRandom.nextSeed(byArray3);
        this.ots = new WinternitzOTSignature(byArray2, this.digestProvider.get(), this.gmssPS.getWinternitzParameter()[this.numLayer - 1]);
        byte[][][] byArray4 = gMSSPrivateKeyParameters.getCurrentAuthPaths();
        this.currentAuthPaths = new byte[this.numLayer][][];
        int n = 0;
        while (n < this.numLayer) {
            this.currentAuthPaths[n] = new byte[byArray4[n].length][this.mdLength];
            int n2 = 0;
            while (n2 < byArray4[n].length) {
                System.arraycopy(byArray4[n][n2], 0, this.currentAuthPaths[n][n2], 0, this.mdLength);
                ++n2;
            }
            ++n;
        }
        this.index = new int[this.numLayer];
        System.arraycopy(gMSSPrivateKeyParameters.getIndex(), 0, this.index, 0, this.numLayer);
        this.subtreeRootSig = new byte[this.numLayer - 1][];
        int n3 = 0;
        while (n3 < this.numLayer - 1) {
            byte[] byArray5 = gMSSPrivateKeyParameters.getSubtreeRootSig(n3);
            this.subtreeRootSig[n3] = new byte[byArray5.length];
            System.arraycopy(byArray5, 0, this.subtreeRootSig[n3], 0, byArray5.length);
            ++n3;
        }
        gMSSPrivateKeyParameters.markUsed();
    }

    public byte[] generateSignature(byte[] byArray) {
        byte[] byArray2;
        byte[] byArray3 = new byte[this.mdLength];
        byArray3 = this.ots.getSignature(byArray);
        byte[] byArray4 = this.gmssUtil.concatenateArray(this.currentAuthPaths[this.numLayer - 1]);
        byte[] byArray5 = this.gmssUtil.intToBytesLittleEndian(this.index[this.numLayer - 1]);
        byte[] byArray6 = new byte[byArray5.length + byArray3.length + byArray4.length];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
        System.arraycopy(byArray3, 0, byArray6, byArray5.length, byArray3.length);
        System.arraycopy(byArray4, 0, byArray6, byArray5.length + byArray3.length, byArray4.length);
        byte[] byArray7 = new byte[]{};
        int n = this.numLayer - 1 - 1;
        while (n >= 0) {
            byArray4 = this.gmssUtil.concatenateArray(this.currentAuthPaths[n]);
            byArray5 = this.gmssUtil.intToBytesLittleEndian(this.index[n]);
            byArray2 = new byte[byArray7.length];
            System.arraycopy(byArray7, 0, byArray2, 0, byArray7.length);
            byArray7 = new byte[byArray2.length + byArray5.length + this.subtreeRootSig[n].length + byArray4.length];
            System.arraycopy(byArray2, 0, byArray7, 0, byArray2.length);
            System.arraycopy(byArray5, 0, byArray7, byArray2.length, byArray5.length);
            System.arraycopy(this.subtreeRootSig[n], 0, byArray7, byArray2.length + byArray5.length, this.subtreeRootSig[n].length);
            System.arraycopy(byArray4, 0, byArray7, byArray2.length + byArray5.length + this.subtreeRootSig[n].length, byArray4.length);
            --n;
        }
        byArray2 = new byte[byArray6.length + byArray7.length];
        System.arraycopy(byArray6, 0, byArray2, 0, byArray6.length);
        System.arraycopy(byArray7, 0, byArray2, byArray6.length, byArray7.length);
        return byArray2;
    }

    private void initVerify() {
        this.messDigestTrees.reset();
        GMSSPublicKeyParameters gMSSPublicKeyParameters = (GMSSPublicKeyParameters)this.key;
        this.pubKeyBytes = gMSSPublicKeyParameters.getPublicKey();
        this.gmssPS = gMSSPublicKeyParameters.getParameters();
        this.numLayer = this.gmssPS.getNumOfLayers();
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        this.messDigestOTS.reset();
        byte[] byArray3 = byArray;
        int n = 0;
        int n2 = this.numLayer - 1;
        while (n2 >= 0) {
            WinternitzOTSVerify winternitzOTSVerify = new WinternitzOTSVerify(this.digestProvider.get(), this.gmssPS.getWinternitzParameter()[n2]);
            int n3 = winternitzOTSVerify.getSignatureLength();
            byArray = byArray3;
            int n4 = this.gmssUtil.bytesToIntLittleEndian(byArray2, n);
            byte[] byArray4 = new byte[n3];
            System.arraycopy(byArray2, n += 4, byArray4, 0, n3);
            n += n3;
            byte[] byArray5 = winternitzOTSVerify.Verify(byArray, byArray4);
            if (byArray5 == null) {
                System.err.println("OTS Public Key is null in GMSSSignature.verify");
                return false;
            }
            byte[][] byArray6 = new byte[this.gmssPS.getHeightOfTrees()[n2]][this.mdLength];
            int n5 = 0;
            while (n5 < byArray6.length) {
                System.arraycopy(byArray2, n, byArray6[n5], 0, this.mdLength);
                n += this.mdLength;
                ++n5;
            }
            byArray3 = new byte[this.mdLength];
            byArray3 = byArray5;
            int n6 = 1 << byArray6.length;
            n6 += n4;
            int n7 = 0;
            while (n7 < byArray6.length) {
                byte[] byArray7 = new byte[this.mdLength << 1];
                if (n6 % 2 == 0) {
                    System.arraycopy(byArray3, 0, byArray7, 0, this.mdLength);
                    System.arraycopy(byArray6[n7], 0, byArray7, this.mdLength, this.mdLength);
                    n6 /= 2;
                } else {
                    System.arraycopy(byArray6[n7], 0, byArray7, 0, this.mdLength);
                    System.arraycopy(byArray3, 0, byArray7, this.mdLength, byArray3.length);
                    n6 = (n6 - 1) / 2;
                }
                this.messDigestTrees.update(byArray7, 0, byArray7.length);
                byArray3 = new byte[this.messDigestTrees.getDigestSize()];
                this.messDigestTrees.doFinal(byArray3, 0);
                ++n7;
            }
            --n2;
        }
        if (Arrays.areEqual(this.pubKeyBytes, byArray3)) {
            bl = true;
        }
        return bl;
    }
}

