/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss.util;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;

public class WinternitzOTSignature {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[][] privateKeyOTS;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int checksumsize;

    public WinternitzOTSignature(byte[] byArray, Digest digest, int n) {
        this.w = n;
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        this.messagesize = ((this.mdsize << 3) + n - 1) / n;
        this.checksumsize = this.getLog((this.messagesize << n) + 1);
        this.keysize = this.messagesize + (this.checksumsize + n - 1) / n;
        this.privateKeyOTS = new byte[this.keysize][];
        byte[] byArray2 = new byte[this.mdsize];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        int n2 = 0;
        while (n2 < this.keysize) {
            this.privateKeyOTS[n2] = this.gmssRandom.nextSeed(byArray2);
            ++n2;
        }
    }

    public byte[][] getPrivateKey() {
        return this.privateKeyOTS;
    }

    public byte[] getPublicKey() {
        byte[] byArray = new byte[this.keysize * this.mdsize];
        int n = 0;
        int n2 = (1 << this.w) - 1;
        int n3 = 0;
        while (n3 < this.keysize) {
            this.hashPrivateKeyBlock(n3, n2, byArray, n);
            n += this.mdsize;
            ++n3;
        }
        this.messDigestOTS.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[this.mdsize];
        this.messDigestOTS.doFinal(byArray2, 0);
        return byArray2;
    }

    public byte[] getSignature(byte[] byArray) {
        byte[] byArray2;
        block18: {
            long l;
            int n;
            int n2;
            long l2;
            int n3;
            int n4;
            int n5;
            int n6;
            byte[] byArray3;
            block19: {
                int n7;
                int n8;
                long l3;
                int n9;
                block17: {
                    int n10;
                    byArray2 = new byte[this.keysize * this.mdsize];
                    byArray3 = new byte[this.mdsize];
                    n6 = 0;
                    n5 = 0;
                    n9 = 0;
                    this.messDigestOTS.update(byArray, 0, byArray.length);
                    this.messDigestOTS.doFinal(byArray3, 0);
                    if (8 % this.w != 0) break block17;
                    int n11 = 8 / this.w;
                    int n12 = (1 << this.w) - 1;
                    int n13 = 0;
                    while (n13 < byArray3.length) {
                        n10 = 0;
                        while (n10 < n11) {
                            n9 = byArray3[n13] & n12;
                            n5 += n9;
                            this.hashPrivateKeyBlock(n6, n9, byArray2, n6 * this.mdsize);
                            byArray3[n13] = (byte)(byArray3[n13] >>> this.w);
                            ++n6;
                            ++n10;
                        }
                        ++n13;
                    }
                    n5 = (this.messagesize << this.w) - n5;
                    n10 = 0;
                    while (n10 < this.checksumsize) {
                        n9 = n5 & n12;
                        this.hashPrivateKeyBlock(n6, n9, byArray2, n6 * this.mdsize);
                        n5 >>>= this.w;
                        ++n6;
                        n10 += this.w;
                    }
                    break block18;
                }
                if (this.w >= 8) break block19;
                int n14 = this.mdsize / this.w;
                int n15 = (1 << this.w) - 1;
                int n16 = 0;
                int n17 = 0;
                while (n17 < n14) {
                    l3 = 0L;
                    n8 = 0;
                    while (n8 < this.w) {
                        l3 ^= (long)((byArray3[n16] & 0xFF) << (n8 << 3));
                        ++n16;
                        ++n8;
                    }
                    n7 = 0;
                    while (n7 < 8) {
                        n9 = (int)l3 & n15;
                        n5 += n9;
                        this.hashPrivateKeyBlock(n6, n9, byArray2, n6 * this.mdsize);
                        l3 >>>= this.w;
                        ++n6;
                        ++n7;
                    }
                    ++n17;
                }
                n14 = this.mdsize % this.w;
                l3 = 0L;
                n8 = 0;
                while (n8 < n14) {
                    l3 ^= (long)((byArray3[n16] & 0xFF) << (n8 << 3));
                    ++n16;
                    ++n8;
                }
                n14 <<= 3;
                n7 = 0;
                while (n7 < n14) {
                    n9 = (int)l3 & n15;
                    n5 += n9;
                    this.hashPrivateKeyBlock(n6, n9, byArray2, n6 * this.mdsize);
                    l3 >>>= this.w;
                    ++n6;
                    n7 += this.w;
                }
                n5 = (this.messagesize << this.w) - n5;
                int n18 = 0;
                while (n18 < this.checksumsize) {
                    n9 = n5 & n15;
                    this.hashPrivateKeyBlock(n6, n9, byArray2, n6 * this.mdsize);
                    n5 >>>= this.w;
                    ++n6;
                    n18 += this.w;
                }
                break block18;
            }
            if (this.w >= 57) break block18;
            int n19 = (this.mdsize << 3) - this.w;
            int n20 = (1 << this.w) - 1;
            byte[] byArray4 = new byte[this.mdsize];
            int n21 = 0;
            while (n21 <= n19) {
                n4 = n21 >>> 3;
                n3 = n21 % 8;
                int n22 = (n21 += this.w) + 7 >>> 3;
                l2 = 0L;
                n2 = 0;
                n = n4;
                while (n < n22) {
                    l2 ^= (long)((byArray3[n] & 0xFF) << (n2 << 3));
                    ++n2;
                    ++n;
                }
                l = (l2 >>>= n3) & (long)n20;
                n5 = (int)((long)n5 + l);
                System.arraycopy(this.privateKeyOTS[n6], 0, byArray4, 0, this.mdsize);
                while (l > 0L) {
                    this.messDigestOTS.update(byArray4, 0, byArray4.length);
                    this.messDigestOTS.doFinal(byArray4, 0);
                    --l;
                }
                System.arraycopy(byArray4, 0, byArray2, n6 * this.mdsize, this.mdsize);
                ++n6;
            }
            n4 = n21 >>> 3;
            if (n4 < this.mdsize) {
                n3 = n21 % 8;
                l2 = 0L;
                n2 = 0;
                n = n4;
                while (n < this.mdsize) {
                    l2 ^= (long)((byArray3[n] & 0xFF) << (n2 << 3));
                    ++n2;
                    ++n;
                }
                l = (l2 >>>= n3) & (long)n20;
                n5 = (int)((long)n5 + l);
                System.arraycopy(this.privateKeyOTS[n6], 0, byArray4, 0, this.mdsize);
                while (l > 0L) {
                    this.messDigestOTS.update(byArray4, 0, byArray4.length);
                    this.messDigestOTS.doFinal(byArray4, 0);
                    --l;
                }
                System.arraycopy(byArray4, 0, byArray2, n6 * this.mdsize, this.mdsize);
                ++n6;
            }
            n5 = (this.messagesize << this.w) - n5;
            n = 0;
            while (n < this.checksumsize) {
                l = n5 & n20;
                System.arraycopy(this.privateKeyOTS[n6], 0, byArray4, 0, this.mdsize);
                while (l > 0L) {
                    this.messDigestOTS.update(byArray4, 0, byArray4.length);
                    this.messDigestOTS.doFinal(byArray4, 0);
                    --l;
                }
                System.arraycopy(byArray4, 0, byArray2, n6 * this.mdsize, this.mdsize);
                n5 >>>= this.w;
                ++n6;
                n += this.w;
            }
        }
        return byArray2;
    }

    public int getLog(int n) {
        int n2 = 1;
        int n3 = 2;
        while (n3 < n) {
            n3 <<= 1;
            ++n2;
        }
        return n2;
    }

    private void hashPrivateKeyBlock(int n, int n2, byte[] byArray, int n3) {
        if (n2 < 1) {
            System.arraycopy(this.privateKeyOTS[n], 0, byArray, n3, this.mdsize);
        } else {
            this.messDigestOTS.update(this.privateKeyOTS[n], 0, this.mdsize);
            this.messDigestOTS.doFinal(byArray, n3);
            while (--n2 > 0) {
                this.messDigestOTS.update(byArray, n3, this.mdsize);
                this.messDigestOTS.doFinal(byArray, n3);
            }
        }
    }
}

