/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincsplus;

import java.util.LinkedList;
import org.bouncycastle.pqc.crypto.sphincsplus.ADRS;
import org.bouncycastle.pqc.crypto.sphincsplus.NodeEntry;
import org.bouncycastle.pqc.crypto.sphincsplus.SIG_FORS;
import org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusEngine;
import org.bouncycastle.util.Arrays;

class Fors {
    SPHINCSPlusEngine engine;

    public Fors(SPHINCSPlusEngine sPHINCSPlusEngine) {
        this.engine = sPHINCSPlusEngine;
    }

    byte[] treehash(byte[] byArray, int n, int n2, byte[] byArray2, ADRS aDRS) {
        ADRS aDRS2 = new ADRS(aDRS);
        LinkedList<NodeEntry> linkedList = new LinkedList<NodeEntry>();
        if (n % (1 << n2) != 0) {
            return null;
        }
        int n3 = 0;
        while (n3 < 1 << n2) {
            aDRS2.setTreeHeight(0);
            aDRS2.setTreeIndex(n + n3);
            byte[] byArray3 = this.engine.PRF(byArray2, byArray, aDRS2);
            byte[] byArray4 = this.engine.F(byArray2, aDRS2, byArray3);
            aDRS2.setTreeHeight(1);
            aDRS2.setTreeIndex(n + n3);
            while (!linkedList.isEmpty() && ((NodeEntry)linkedList.get((int)0)).nodeHeight == aDRS2.getTreeHeight()) {
                aDRS2.setTreeIndex((aDRS2.getTreeIndex() - 1) / 2);
                NodeEntry nodeEntry = (NodeEntry)linkedList.remove(0);
                byArray4 = this.engine.H(byArray2, aDRS2, nodeEntry.nodeValue, byArray4);
                aDRS2.setTreeHeight(aDRS2.getTreeHeight() + 1);
            }
            linkedList.add(0, new NodeEntry(byArray4, aDRS2.getTreeHeight()));
            ++n3;
        }
        return ((NodeEntry)linkedList.get((int)0)).nodeValue;
    }

    public SIG_FORS[] sign(byte[] byArray, byte[] byArray2, byte[] byArray3, ADRS aDRS) {
        int[] nArray = Fors.message_to_idxs(byArray, this.engine.K, this.engine.A);
        SIG_FORS[] sIG_FORSArray = new SIG_FORS[this.engine.K];
        int n = this.engine.T;
        int n2 = 0;
        while (n2 < this.engine.K) {
            int n3 = nArray[n2];
            aDRS.setTreeHeight(0);
            aDRS.setTreeIndex(n2 * n + n3);
            byte[] byArray4 = this.engine.PRF(byArray3, byArray2, aDRS);
            byte[][] byArrayArray = new byte[this.engine.A][];
            int n4 = 0;
            while (n4 < this.engine.A) {
                int n5 = n3 / (1 << n4) ^ 1;
                byArrayArray[n4] = this.treehash(byArray2, n2 * n + n5 * (1 << n4), n4, byArray3, aDRS);
                ++n4;
            }
            sIG_FORSArray[n2] = new SIG_FORS(byArray4, byArrayArray);
            ++n2;
        }
        return sIG_FORSArray;
    }

    public byte[] pkFromSig(SIG_FORS[] sIG_FORSArray, byte[] byArray, byte[] byArray2, ADRS aDRS) {
        byte[][] byArrayArray = new byte[2][];
        byte[][] byArrayArray2 = new byte[this.engine.K][];
        int n = this.engine.T;
        int[] nArray = Fors.message_to_idxs(byArray, this.engine.K, this.engine.A);
        int n2 = 0;
        while (n2 < this.engine.K) {
            int n3 = nArray[n2];
            byte[] byArray3 = sIG_FORSArray[n2].getSK();
            aDRS.setTreeHeight(0);
            aDRS.setTreeIndex(n2 * n + n3);
            byArrayArray[0] = this.engine.F(byArray2, aDRS, byArray3);
            byte[][] byArray4 = sIG_FORSArray[n2].getAuthPath();
            aDRS.setTreeIndex(n2 * n + n3);
            int n4 = 0;
            while (n4 < this.engine.A) {
                aDRS.setTreeHeight(n4 + 1);
                if (n3 / (1 << n4) % 2 == 0) {
                    aDRS.setTreeIndex(aDRS.getTreeIndex() / 2);
                    byArrayArray[1] = this.engine.H(byArray2, aDRS, byArrayArray[0], byArray4[n4]);
                } else {
                    aDRS.setTreeIndex((aDRS.getTreeIndex() - 1) / 2);
                    byArrayArray[1] = this.engine.H(byArray2, aDRS, byArray4[n4], byArrayArray[0]);
                }
                byArrayArray[0] = byArrayArray[1];
                ++n4;
            }
            byArrayArray2[n2] = byArrayArray[0];
            ++n2;
        }
        ADRS aDRS2 = new ADRS(aDRS);
        aDRS2.setType(4);
        aDRS2.setKeyPairAddress(aDRS.getKeyPairAddress());
        return this.engine.T_l(byArray2, aDRS2, Arrays.concatenate(byArrayArray2));
    }

    static int[] message_to_idxs(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int[] nArray = new int[n];
        int n4 = 0;
        while (n4 < n) {
            nArray[n4] = 0;
            int n5 = 0;
            while (n5 < n2) {
                int n6 = n4;
                nArray[n6] = nArray[n6] ^ (byArray[n3 >> 3] >> (n3 & 7) & 1) << n5;
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return nArray;
    }
}

