/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.util;

import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.util.Arrays;

public class SecretWithEncapsulationImpl
implements SecretWithEncapsulation {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] sessionKey;
    private final byte[] cipher_text;

    public SecretWithEncapsulationImpl(byte[] byArray, byte[] byArray2) {
        this.sessionKey = byArray;
        this.cipher_text = byArray2;
    }

    public byte[] getSecret() {
        this.checkDestroyed();
        return Arrays.clone(this.sessionKey);
    }

    public byte[] getEncapsulation() {
        this.checkDestroyed();
        return Arrays.clone(this.cipher_text);
    }

    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.sessionKey);
            Arrays.clear(this.cipher_text);
        }
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("data has been destroyed");
        }
    }

    private static class AtomicBoolean {
        private volatile boolean value;

        AtomicBoolean(boolean bl) {
            this.value = bl;
        }

        public synchronized void set(boolean bl) {
            this.value = bl;
        }

        public synchronized boolean getAndSet(boolean bl) {
            boolean bl2 = this.value;
            this.value = bl;
            return bl2;
        }

        public synchronized boolean get() {
            return this.value;
        }
    }
}

